/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSROLESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSROLES";
    private static final int SYSROLES_COLUMN_COUNT = 6;
    private static final int SYSROLES_ROLE_UUID = 1;
    private static final int SYSROLES_ROLEID = 2;
    private static final int SYSROLES_GRANTEE = 3;
    private static final int SYSROLES_GRANTOR = 4;
    private static final int SYSROLES_WITHADMINOPTION = 5;
    private static final int SYSROLES_ISDEF = 6;
    private static final int[][] indexColumnPositions = new int[][]{{2, 3, 4}, {2, 6}, {1}};
    static final int SYSROLES_INDEX_ID_EE_OR_IDX = 0;
    static final int SYSROLES_INDEX_ID_DEF_IDX = 1;
    static final int SYSROLES_INDEX_UUID_IDX = 2;
    static final int SYSROLES_ROLEID_COLPOS_IN_INDEX_ID_EE_OR = 1;
    static final int SYSROLES_GRANTEE_COLPOS_IN_INDEX_ID_EE_OR = 2;
    private static final boolean[] uniqueness = new boolean[]{true, false, true};
    private static final String[] uuids = new String[]{"e03f4017-0115-382c-08df-ffffe275b270", "c851401a-0115-382c-08df-ffffe275b270", "c065801d-0115-382c-08df-ffffe275b270", "787c0020-0115-382c-08df-ffffe275b270", "629f8094-0116-d8f9-5f97-ffffe275b270"};

    SYSROLESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(6, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String oid_string = null;
        String roleid = null;
        String grantee = null;
        String grantor = null;
        boolean wao = false;
        boolean isdef = false;
        if (td != null) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)td;
            roleid = roleDescriptor.getRoleName();
            grantee = roleDescriptor.getGrantee();
            grantor = roleDescriptor.getGrantor();
            wao = roleDescriptor.isWithAdminOption();
            isdef = roleDescriptor.isDef();
            UUID oid = roleDescriptor.getUUID();
            oid_string = oid.toString();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(6);
        row.setColumn(1, new SQLChar(oid_string));
        row.setColumn(2, new SQLVarchar(roleid));
        row.setColumn(3, new SQLVarchar(grantee));
        row.setColumn(4, new SQLVarchar(grantor));
        row.setColumn(5, new SQLChar(wao ? "Y" : "N"));
        row.setColumn(6, new SQLChar(isdef ? "Y" : "N"));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT((row.nColumns() == 6 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSROLES row");
        DataValueDescriptor col = row.getColumn(1);
        String oid_string = col.getString();
        col = row.getColumn(2);
        String roleid = col.getString();
        col = row.getColumn(3);
        String grantee = col.getString();
        col = row.getColumn(4);
        String grantor = col.getString();
        col = row.getColumn(5);
        String wao = col.getString();
        col = row.getColumn(6);
        String isdef = col.getString();
        RoleDescriptor descriptor = ddg.newRoleDescriptor(this.getUUIDFactory().recreateUUID(oid_string), roleid, grantee, grantor, wao.equals("Y"), isdef.equals("Y"));
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("UUID", false), SystemColumnImpl.getIdentifierColumn("ROLEID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getIndicatorColumn("WITHADMINOPTION"), SystemColumnImpl.getIndicatorColumn("ISDEF")};
    }
}

