/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSFOREIGNKEYSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSFOREIGNKEYS";
    protected static final int SYSFOREIGNKEYS_COLUMN_COUNT = 5;
    protected static final int SYSFOREIGNKEYS_CONSTRAINTID = 1;
    protected static final int SYSFOREIGNKEYS_CONGLOMERATEID = 2;
    protected static final int SYSFOREIGNKEYS_KEYCONSTRAINTID = 3;
    protected static final int SYSFOREIGNKEYS_DELETERULE = 4;
    protected static final int SYSFOREIGNKEYS_UPDATERULE = 5;
    protected static final int SYSFOREIGNKEYS_CONSTRAINTID_WIDTH = 36;
    protected static final int SYSFOREIGNKEYS_INDEX1_ID = 0;
    protected static final int SYSFOREIGNKEYS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}};
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000005b-00d0-fd77-3ed8-000a0a0b1900", "80000060-00d0-fd77-3ed8-000a0a0b1900", "8000005d-00d0-fd77-3ed8-000a0a0b1900", "8000005f-00d0-fd77-3ed8-000a0a0b1900"};

    SYSFOREIGNKEYSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String constraintId = null;
        String keyConstraintId = null;
        String conglomId = null;
        String raDeleteRule = "N";
        String raUpdateRule = "N";
        if (td != null) {
            ForeignKeyConstraintDescriptor cd = (ForeignKeyConstraintDescriptor)td;
            constraintId = cd.getUUID().toString();
            ReferencedKeyConstraintDescriptor refCd = cd.getReferencedConstraint();
            SanityManager.ASSERT((refCd != null ? 1 : 0) != 0, (String)"this fk returned a null referenced key");
            keyConstraintId = refCd.getUUID().toString();
            conglomId = cd.getIndexUUIDString();
            raDeleteRule = this.getRefActionAsString(cd.getRaDeleteRule());
            raUpdateRule = this.getRefActionAsString(cd.getRaUpdateRule());
        }
        ExecIndexRow row = this.getExecutionFactory().getIndexableRow(5);
        row.setColumn(1, new SQLChar(constraintId));
        row.setColumn(2, new SQLChar(conglomId));
        row.setColumn(3, new SQLChar(keyConstraintId));
        row.setColumn(4, new SQLChar(raDeleteRule));
        row.setColumn(5, new SQLChar(raUpdateRule));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 5 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSKEYS row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String conglomerateUUIDString = col.getString();
        UUID conglomerateUUID = this.getUUIDFactory().recreateUUID(conglomerateUUIDString);
        col = row.getColumn(3);
        constraintUUIDString = col.getString();
        UUID keyConstraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(4);
        String raRuleString = col.getString();
        int raDeleteRule = this.getRefActionAsInt(raRuleString);
        col = row.getColumn(5);
        raRuleString = col.getString();
        int raUpdateRule = this.getRefActionAsInt(raRuleString);
        return new SubKeyConstraintDescriptor(constraintUUID, conglomerateUUID, keyConstraintUUID, raDeleteRule, raUpdateRule);
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("CONGLOMERATEID", false), SystemColumnImpl.getUUIDColumn("KEYCONSTRAINTID", false), SystemColumnImpl.getIndicatorColumn("DELETERULE"), SystemColumnImpl.getIndicatorColumn("UPDATERULE")};
    }

    int getRefActionAsInt(String raRuleString) {
        int raRule;
        switch (raRuleString.charAt(0)) {
            case 'C': {
                raRule = 0;
                break;
            }
            case 'S': {
                raRule = 1;
                break;
            }
            case 'R': {
                raRule = 2;
                break;
            }
            case 'U': {
                raRule = 3;
                break;
            }
            case 'D': {
                raRule = 4;
                break;
            }
            default: {
                raRule = 2;
                SanityManager.THROWASSERT((String)("Invalid  value '" + raRuleString + "' for a referetial Action"));
            }
        }
        return raRule;
    }

    String getRefActionAsString(int raRule) {
        String raRuleString;
        switch (raRule) {
            case 0: {
                raRuleString = "C";
                break;
            }
            case 1: {
                raRuleString = "S";
                break;
            }
            case 2: {
                raRuleString = "R";
                break;
            }
            case 3: {
                raRuleString = "U";
                break;
            }
            case 4: {
                raRuleString = "D";
                raRule = 4;
                break;
            }
            default: {
                raRuleString = "N";
                SanityManager.THROWASSERT((String)("Invalid  value '" + raRule + "' for a referetial Action"));
            }
        }
        return raRuleString;
    }
}

