/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.ReferencedColumns;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CheckConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

class SYSCHECKSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCHECKS";
    private static final int SYSCHECKS_COLUMN_COUNT = 3;
    private static final int SYSCHECKS_CONSTRAINTID = 1;
    private static final int SYSCHECKS_CHECKDEFINITION = 2;
    private static final int SYSCHECKS_REFERENCEDCOLUMNS = 3;
    static final int SYSCHECKS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[] uuids = new String[]{"80000056-00d0-fd77-3ed8-000a0a0b1900", "80000059-00d0-fd77-3ed8-000a0a0b1900", "80000058-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCHECKSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(3, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        ReferencedColumns rcd = null;
        String checkDefinition = null;
        String constraintID = null;
        if (td != null) {
            CheckConstraintDescriptor cd = (CheckConstraintDescriptor)td;
            constraintID = cd.getUUID().toString();
            checkDefinition = cd.getConstraintText();
            rcd = cd.getReferencedColumnsDescriptor();
        }
        ExecIndexRow row = this.getExecutionFactory().getIndexableRow(3);
        row.setColumn(1, new SQLChar(constraintID));
        row.setColumn(2, this.dvf.getLongvarcharDataValue(checkDefinition));
        row.setColumn(3, this.dvf.getDataValue(rcd));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SubCheckConstraintDescriptor checkDesc = null;
        SanityManager.ASSERT((row.nColumns() == 3 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSCHECKS row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String constraintText = col.getString();
        col = row.getColumn(3);
        ReferencedColumns referencedColumns = (ReferencedColumns)col.getObject();
        checkDesc = new SubCheckConstraintDescriptor(constraintUUID, constraintText, referencedColumns);
        return checkDesc;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getColumn("CHECKDEFINITION", -1, false), SystemColumnImpl.getJavaColumn("REFERENCEDCOLUMNS", "com.pivotal.gemfirexd.internal.catalog.ReferencedColumns", false)};
    }
}

