/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdAsyncEventListenerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class GfxdSysAsyncEventListenerRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "ASYNCEVENTLISTENERS";
    public static final int ASYNCEEVENTLISTENERS_COLUMN_COUNT = 14;
    public static final int SENDER_ID = 1;
    public static final int LISTENER_CLASS = 2;
    public static final int SERVER_GROUPS = 3;
    public static final int MANUAL_START = 4;
    public static final int BATCH_CONFLATION = 5;
    public static final int BATCH_SIZE = 6;
    public static final int BATCH_TIME_INTERVAL = 7;
    public static final int IS_PERSISTENCE = 8;
    public static final int DISK_STORE_NAME = 9;
    public static final int MAX_QUEUE_MEMORY = 10;
    public static final int ALERT_THRESHOLD = 11;
    public static final int IS_STARTED = 12;
    public static final int INIT_PARAMS = 13;
    public static final int DISK_SYNCHRONOUS = 14;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"l073400e-00b6-fdfc-71ce-000b0a763800", "l073400e-00b6-fbba-75d4-000b0a763800", "l073400e-00b6-00b9-bbde-000b0a763800"};

    GfxdSysAsyncEventListenerRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(14, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        UUID uuid = null;
        String senderId = null;
        String className = null;
        String serverGroup = null;
        Boolean manualStart = null;
        Integer maximumQueueMemory = null;
        Integer batchSize = null;
        Integer batchTimeInterval = null;
        Boolean isBatchConflationEnabled = null;
        Boolean isPersistenceEnabled = null;
        Boolean diskSynchronous = null;
        String diskStoreName = null;
        Integer alertThreshold = null;
        Boolean isStarted = null;
        String initParams = null;
        if (td != null) {
            GfxdAsyncEventListenerDescriptor dsd = (GfxdAsyncEventListenerDescriptor)td;
            uuid = dsd.getUUID();
            senderId = dsd.getSenderId();
            className = dsd.getClassName();
            serverGroup = dsd.getServerGroup();
            manualStart = dsd.isManualStart();
            maximumQueueMemory = dsd.getMaximumQueueMemory();
            batchSize = dsd.getBatchSize();
            batchTimeInterval = dsd.getBatchTimeInterval();
            isBatchConflationEnabled = dsd.isBatchConflationEnabled();
            isPersistenceEnabled = dsd.isPersistenceEnabled();
            diskSynchronous = dsd.isDiskSynchronous();
            diskStoreName = dsd.getDiskStoreName();
            alertThreshold = dsd.getAlertThreshold();
            isStarted = dsd.isStarted();
            initParams = dsd.getInitParams();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(14);
        row.setColumn(1, new SQLVarchar(senderId));
        row.setColumn(2, new SQLVarchar(className));
        row.setColumn(3, new SQLVarchar(serverGroup));
        row.setColumn(4, new SQLBoolean(manualStart));
        row.setColumn(5, new SQLBoolean(isBatchConflationEnabled));
        row.setColumn(6, new SQLInteger(batchSize));
        row.setColumn(7, new SQLInteger(batchTimeInterval));
        row.setColumn(8, new SQLBoolean(isPersistenceEnabled));
        row.setColumn(14, new SQLBoolean(diskSynchronous));
        row.setColumn(9, new SQLVarchar(diskStoreName));
        row.setColumn(10, new SQLInteger(maximumQueueMemory));
        row.setColumn(11, new SQLInteger(alertThreshold));
        row.setColumn(12, new SQLBoolean(isStarted));
        row.setColumn(13, new SQLVarchar(initParams));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 14 ? 1 : 0) != 0, (String)"Wrong number of columns for a ASYNCEEVENTLISTENERS row");
        DataValueDescriptor col = row.getColumn(1);
        String senderId = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(senderId);
        col = row.getColumn(2);
        String className = col.getString();
        col = row.getColumn(3);
        String serverGroups = col.getString();
        col = row.getColumn(4);
        Boolean manualStart = col.getBoolean();
        col = row.getColumn(5);
        Boolean batchConflation = col.getBoolean();
        col = row.getColumn(6);
        Integer batchSize = col.getInt();
        col = row.getColumn(7);
        Integer batchTimeInterval = col.getInt();
        col = row.getColumn(8);
        Boolean isPersistent = col.getBoolean();
        col = row.getColumn(14);
        Boolean diskSynchronous = col.getBoolean();
        col = row.getColumn(9);
        String diskStoreName = col.getString();
        col = row.getColumn(10);
        Integer maxQueueMemory = col.getInt();
        col = row.getColumn(11);
        Integer alertThreshold = col.getInt();
        col = row.getColumn(12);
        Boolean isStarted = col.getBoolean();
        col = row.getColumn(13);
        String initParams = col.getString();
        return new GfxdAsyncEventListenerDescriptor(dd, id, senderId, className, serverGroups, manualStart, batchConflation, batchSize, batchTimeInterval, isPersistent, diskSynchronous, diskStoreName, maxQueueMemory, alertThreshold, isStarted, initParams);
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("ID", false), SystemColumnImpl.getColumn("LISTENER_CLASS", 12, false), SystemColumnImpl.getColumn("SERVER_GROUPS", 12, false), SystemColumnImpl.getColumn("MANUAL_START", 16, false), SystemColumnImpl.getColumn("BATCH_CONFLATION", 16, false), SystemColumnImpl.getColumn("BATCH_SIZE", 4, false), SystemColumnImpl.getColumn("BATCH_TIME_INTERVAL", 4, false), SystemColumnImpl.getColumn("IS_PERSISTENCE", 16, false), SystemColumnImpl.getColumn("DISK_STORE_NAME", 12, true), SystemColumnImpl.getColumn("MAX_QUEUE_MEMORY", 4, false), SystemColumnImpl.getColumn("ALERT_THRESHOLD", 4, false), SystemColumnImpl.getColumn("IS_STARTED", 16, false), SystemColumnImpl.getColumn("INIT_PARAMS", 12, true), SystemColumnImpl.getColumn("DISK_SYNCHRONOUS", 16, false)};
    }
}

