/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TupleFilter;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;

public class DropDependencyFilter
implements TupleFilter {
    UUID providerID;
    UUIDFactory uuidFactory = null;
    DataValueFactory dataValueFactory = null;
    BooleanDataValue trueValue;
    BooleanDataValue falseValue;

    public DropDependencyFilter(UUID providerID) {
        this.providerID = providerID;
    }

    @Override
    public void init(ExecRow parameters) throws StandardException {
    }

    @Override
    public BooleanDataValue execute(ExecRow currentRow) throws StandardException {
        DataValueDescriptor col = currentRow.getColumn(3);
        String providerIDstring = col.getString();
        UUID providerUUID = this.getUUIDFactory().recreateUUID(providerIDstring);
        if (this.providerID.equals(providerUUID)) {
            return this.getTrueValue();
        }
        return this.getFalseValue();
    }

    private UUIDFactory getUUIDFactory() throws StandardException {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    private DataValueFactory getDataValueFactory() {
        if (this.dataValueFactory == null) {
            LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            this.dataValueFactory = lcc.getDataValueFactory();
        }
        return this.dataValueFactory;
    }

    private BooleanDataValue getTrueValue() throws StandardException {
        if (this.trueValue == null) {
            this.trueValue = this.getDataValueFactory().getDataValue(true);
        }
        return this.trueValue;
    }

    private BooleanDataValue getFalseValue() throws StandardException {
        if (this.falseValue == null) {
            this.falseValue = this.getDataValueFactory().getDataValue(false);
        }
        return this.falseValue;
    }
}

