/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InsertQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.engine.reflect.GemFireActivationClass;
import com.pivotal.gemfirexd.internal.engine.reflect.SnappyActivationClass;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyActivation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStorablePreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AlterTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InsertNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericLanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineArbiter;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class GenericStatement
implements Statement {
    protected SchemaDescriptor compilationSchema;
    protected String statementText;
    protected int prepareIsolationLevel;
    protected GenericPreparedStatement preparedStmt;
    protected int hash;
    protected int stmtHash;
    protected short execFlags;
    public static final short IS_READ_ONLY = 1;
    public static final short CREATE_QUERY_INFO = 2;
    public static final short GFXD_SUBACTIVATION_NEEDED = 4;
    public static final short DISALLOW_SUBQUERY_FLATTENING = 8;
    public static final short IS_PREP_STMT = 16;
    public static final short DISALLOW_OR_LIST_OPTIMIZATION = 32;
    public static final short ALL_TABLES_ARE_REPLICATED_ON_REMOTE = 64;
    public static final short IS_OPTIMIZED_STMT = 128;
    public static final short QUERY_HDFS = 256;
    public static final short IS_CALLABLE_STATEMENT = 512;
    public static final short ROUTE_QUERY = 1024;
    public static final Pattern SKIP_CANCEL_STMTS = Pattern.compile("^\\s*\\{?\\s*(DROP|TRUNCATE)\\s+(TABLE|INDEX)\\s+", 2);
    public static final Pattern DELETE_STMT = Pattern.compile("^\\s*\\{?\\s*DELETE\\s+FROM\\s+.*", 2);
    private static final Pattern ignoreStmts = Pattern.compile("\\s.*(\"SYSSTAT\"|SYS.\")", 34);
    private final GfxdHeapThresholdListener thresholdListener;
    private THashMap ncjMetaData = null;
    private static final Pattern STREAMING_DDL_PREFIX = Pattern.compile("\\s*STREAMING\\s+.*", 34);
    private static final Pattern INSERT_INTO_TABLE_SELECT_PATTERN = Pattern.compile(".*INSERT\\s+INTO\\s+(TABLE)?.*\\s+SELECT\\s+.*", 34);
    private static final Pattern DML_TABLE_PATTERN = Pattern.compile("^\\s*(INSERT|UPDATE|DELETE)\\s+.*", 34);
    private static final Pattern PUT_INTO_TABLE_SELECT_PATTERN = Pattern.compile(".*PUT\\s+INTO\\s+(TABLE)?.*\\s+SELECT\\s+.*", 34);
    private static final Pattern FUNCTION_DDL_PREFIX = Pattern.compile("\\s?(CREATE|DROP)\\s+FUNCTION\\s+.*", 34);
    private static final Pattern ALTER_TABLE_COLUMN = Pattern.compile("\\s*ALTER\\s+TABLE?.*\\s+(ADD|DROP)\\s+.*", 34);
    private static final Pattern ALTER_TABLE_CONSTRAINTS = Pattern.compile("\\s*ALTER\\s+TABLE?.*\\s+ADD\\s+CONSTRAINT\\s+.*", 34);
    private static ExecutionEngineArbiter engineArbiter = new ExecutionEngineArbiter();

    public GenericStatement(SchemaDescriptor compilationSchema, String statementText, short execFlags, THashMap ncjMetaData) {
        int h;
        this.compilationSchema = compilationSchema;
        this.statementText = statementText;
        this.execFlags = execFlags;
        this.stmtHash = h = this.getHashCode(0, this.statementText.length(), 0);
        h = ResolverUtils.addIntToHash((int)(this.createQueryInfo() ? 1231 : 1237), (int)h);
        h = ResolverUtils.addIntToHash((int)(this.isPreparedStatement() || !this.isOptimizedStatement() ? 19531 : 20161), (int)h);
        h = ResolverUtils.addIntToHash((int)(this.getRouteQuery() ? 22409 : 22433), (int)h);
        this.hash = h = ResolverUtils.addIntToHash((int)(this.getQueryHDFS() ? 999599 : 999983), (int)h);
        GemFireStore store = GemFireStore.getBootingInstance();
        this.thresholdListener = store != null ? store.thresholdListener() : null;
        this.ncjMetaData = ncjMetaData;
    }

    @Override
    public PreparedStatement prepare(LanguageConnectionContext lcc) throws StandardException {
        return this.prepMinion(lcc, true, null, null, false);
    }

    @Override
    public final PreparedStatement prepare(LanguageConnectionContext lcc, boolean forMetaData) throws StandardException {
        return this.prepMinion(lcc, true, null, null, forMetaData);
    }

    private GenericPreparedStatement getPreparedStatementForSnappy(boolean commitNestedTransaction, StatementContext statementContext, LanguageConnectionContext lcc, boolean isDDL, boolean checkCancellation, boolean isUpdateOrDelete) throws StandardException {
        GenericPreparedStatement gps = this.preparedStmt;
        SnappyActivationClass ac = new SnappyActivationClass(lcc, !isDDL, this.isPreparedStatement() && !isDDL, isUpdateOrDelete);
        gps.setActivationClass(ac);
        gps.incrementVersionCounter();
        gps.makeValid();
        if (commitNestedTransaction) {
            lcc.commitNestedTransaction();
        }
        if (statementContext != null) {
            lcc.popStatementContext(statementContext, null);
        }
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GenericStatement.getPreparedStatementForSnappy: Created SnappyActivation for sql: " + this.getSource() + " ,isDDL=" + isDDL + " ,isUpdateOrDelete=" + isUpdateOrDelete));
        }
        if (checkCancellation) {
            Misc.checkMemory(this.thresholdListener, this.statementText, -1L);
        }
        return gps;
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"ML_SYNC_ON_FIELD_TO_GUARD_CHANGING_THAT_FIELD"})
    private final PreparedStatement prepMinion(LanguageConnectionContext lcc, boolean cacheMe, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [91[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean invalidQueryOnColumnTable(LanguageConnectionContext _lcc, DMLQueryInfo qi) {
        boolean isColumnTable = SnappyActivation.isColumnTable(qi);
        List<SubQueryInfo> subQinfoList = qi.getSubqueryInfoList();
        if (!isColumnTable && subQinfoList.size() > 0) {
            SubQueryInfo sq;
            Iterator<SubQueryInfo> iterator = subQinfoList.iterator();
            while (iterator.hasNext() && !(isColumnTable = SnappyActivation.isColumnTable(sq = iterator.next()))) {
            }
        }
        if (!isColumnTable && qi.isInsertAsSubSelect()) {
            isColumnTable = SnappyActivation.isColumnTable(((InsertQueryInfo)qi).getSubSelectQueryInfo());
        }
        return isColumnTable && !Misc.routeQuery(_lcc) && !_lcc.isSnappyInternalConnection();
    }

    private boolean shouldSkipMemoryChecks(StatementNode qt) {
        int nodeType = qt.getNodeType();
        return nodeType == 101 || nodeType == 91 || nodeType == 63 || nodeType == 114 && ((AlterTableNode)qt).isTruncateTable();
    }

    @Override
    public PreparedStatement prepareStorable(LanguageConnectionContext lcc, PreparedStatement ps, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        if (ps == null) {
            ps = new GenericStorablePreparedStatement(this);
        } else {
            ((GenericPreparedStatement)ps).statement = this;
        }
        this.preparedStmt = (GenericPreparedStatement)ps;
        return this.prepMinion(lcc, false, paramDefaults, spsSchema, internalSQL);
    }

    @Override
    public String getSource() {
        return this.statementText;
    }

    public String getCompilationSchema() {
        return this.compilationSchema.getDescriptorName();
    }

    private static long getCurrentTimeMillis(LanguageConnectionContext lcc) {
        if (lcc.getStatisticsTiming()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private static long getElapsedTimeMillis(long beginTime) {
        if (beginTime != 0L) {
            return System.currentTimeMillis() - beginTime;
        }
        return 0L;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean isSystemSchema() {
        return this.compilationSchema.isSystemSchema();
    }

    @Override
    public GenericPreparedStatement prepareStatement(LanguageConnectionContext lcc, QueryInfo qinfo, DataTypeDescriptor[] paramDTDs, CursorNode cn, CompilerContext cc) throws StandardException {
        HeaderPrintWriter istream;
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"GenericStatement:: prepareStatement for subquery activation creation");
        }
        boolean createGFEPrepStmt = false;
        if (this.preparedStmt != null && this.preparedStmt.upToDate()) {
            return this.preparedStmt;
        }
        this.prepareIsolationLevel = lcc.getPrepareIsolationLevel();
        this.preparedStmt = new GenericPreparedStatement(this, true);
        this.preparedStmt.setSource(this.getSource());
        HeaderPrintWriter headerPrintWriter = istream = lcc.getLogStatementText() ? Monitor.getStream() : null;
        if (istream != null) {
            String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
            istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), End compiling prepared statement: " + this.getSource() + " :End prepared statement");
        }
        GeneratedClass ac = null;
        createGFEPrepStmt = qinfo.createGFEActivation();
        if (createGFEPrepStmt) {
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"GenericStatement::prepareStatement for subquery activation: Creating GemFireActivationClass");
            }
            ac = new GemFireActivationClass(lcc, qinfo);
        } else {
            if (GemFireXDUtils.TraceActivation) {
                SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)"GenericStatement::prepareStatement for subquery activation: Creating Derby Activation Class");
            }
            ac = cn.generate(this.preparedStmt.getByteCodeSaver());
        }
        this.preparedStmt.setConstantAction(null);
        Object[] savedObjects = cc.getSavedObjects();
        this.preparedStmt.setSavedObjects(savedObjects);
        cc.setSavedObjects(savedObjects);
        this.preparedStmt.setRequiredPermissionsList(Collections.EMPTY_LIST);
        this.preparedStmt.setActivationClass(ac);
        this.preparedStmt.setNeedsSavepoint(false);
        this.preparedStmt.setCursorInfo(null);
        this.preparedStmt.setIsAtomic(true);
        this.preparedStmt.setStatementType(0);
        this.preparedStmt.setValid();
        this.preparedStmt.paramTypeDescriptors = paramDTDs;
        return this.preparedStmt;
    }

    @Override
    public String getQueryStringForParse(LanguageConnectionContext lcc) {
        return this.getSource();
    }

    public boolean equals(Object other) {
        if (other instanceof GenericStatement) {
            GenericStatement os = (GenericStatement)other;
            return this.statementText.equals(os.statementText) && this.isForReadOnly() == os.isForReadOnly() && this.compilationSchema.equals(os.compilationSchema) && this.createQueryInfo() == os.createQueryInfo() && this.getQueryHDFS() == os.getQueryHDFS() && this.prepareIsolationLevel == os.prepareIsolationLevel;
        }
        return false;
    }

    public final int hashCode() {
        return this.hash;
    }

    private QueryInfo handleInsertAndInsertSubSelect(QueryInfo qinfo, StatementNode qt) throws StandardException {
        if (qinfo.hasSubSelect() && !DMLQueryInfo.isSingleVMCase()) {
            assert (qinfo.isInsert());
            if (!qinfo.isTableVTI()) {
                InsertQueryInfo.checkSupportedInsertSubSelect(((InsertQueryInfo)qinfo).getSubSelectQueryInfo());
                String targetTable = ((InsertNode)qt).getNonVTITargetTableName();
                if (targetTable == null) {
                    throw StandardException.newException("0A000.S", "inserts as sub selects for VTIs");
                }
                qinfo.setInsertAsSubSelect(true, targetTable);
                return qinfo;
            }
        }
        return qinfo;
    }

    protected final int getHashCode(int beginOffset, int endOffset, int hash) {
        while (beginOffset < endOffset) {
            int c = this.statementText.charAt(beginOffset);
            int val = Character.isHighSurrogate((char)c) ? Character.toCodePoint((char)c, this.statementText.charAt(++beginOffset)) : c;
            hash = ResolverUtils.addIntToHash((int)val, (int)hash);
            ++beginOffset;
        }
        if (this.compilationSchema != null) {
            String schema = this.compilationSchema.getSchemaName();
            int len = schema.length();
            for (beginOffset = 0; beginOffset < len; ++beginOffset) {
                int c = schema.charAt(beginOffset);
                int val = Character.isHighSurrogate((char)c) ? Character.toCodePoint((char)c, schema.charAt(++beginOffset)) : c;
                hash = ResolverUtils.addIntToHash((int)val, (int)hash);
            }
        }
        return hash;
    }

    @Override
    public boolean createQueryInfo() {
        return GemFireXDUtils.isSet(this.execFlags, (short)2);
    }

    protected boolean isPreparedStatement() {
        return GemFireXDUtils.isSet(this.execFlags, (short)16);
    }

    protected boolean isOptimizedStatement() {
        return GemFireXDUtils.isSet(this.execFlags, (short)128);
    }

    protected boolean isForReadOnly() {
        return GemFireXDUtils.isSet(this.execFlags, (short)1);
    }

    protected boolean needGfxdSubactivation() {
        return GemFireXDUtils.isSet(this.execFlags, (short)4);
    }

    protected boolean subqueryFlatteningAllowed() {
        return !GemFireXDUtils.isSet(this.execFlags, (short)8);
    }

    protected boolean orListOptimizationAllowed() {
        return !GemFireXDUtils.isSet(this.execFlags, (short)32);
    }

    protected boolean allTablesAreReplicatedOnRemote() {
        return GemFireXDUtils.isSet(this.execFlags, (short)64);
    }

    protected boolean getQueryHDFS() {
        return GemFireXDUtils.isSet(this.execFlags, (short)256);
    }

    protected boolean getRouteQuery() {
        return GemFireXDUtils.isSet(this.execFlags, (short)1024);
    }

    private final boolean fetchStatementStats(LanguageConnectionContext lcc, CompilerContext cc) {
        if (!lcc.statsEnabled()) {
            return true;
        }
        if (this.preparedStmt == null) {
            return false;
        }
        if (ignoreStmts.matcher(this.statementText).find()) {
            return true;
        }
        if (this.preparedStmt.getStatementStats() != null) {
            if (cc != null) {
                cc.setStatementStats(this.preparedStmt.getStatementStats());
            }
            return true;
        }
        StatementStats s = null;
        if (!this.createQueryInfo()) {
            s = this.getQueryNodeStatementStats();
        }
        if (s != null) {
            this.preparedStmt.setStatementStats(s);
            if (cc != null) {
                cc.setStatementStats(s);
            }
            return true;
        }
        return false;
    }

    private final void fetchOrCreateStatementStats(LanguageConnectionContext lcc, StatementNode qt, CompilerContext cc, StringBuilder queryTextForStats) {
        String stmtDesc;
        if (this.fetchStatementStats(lcc, cc)) {
            return;
        }
        assert (cc != null);
        if (cc.getStatementAlias() == null) {
            if (queryTextForStats != null && queryTextForStats.length() > 0) {
                stmtDesc = queryTextForStats.length() > 190 ? queryTextForStats.substring(0, 190) : queryTextForStats.toString();
                stmtDesc = stmtDesc + "/" + this.getUniqueIdFromStatementText(lcc);
                SanityManager.DEBUG_PRINT((String)"info:statementAlias:", (String)("created statement descriptor [" + stmtDesc + "] for statement [" + this.getQueryStringForParse(lcc) + "] schema=" + this.compilationSchema));
            } else {
                String stmtText = this.getQueryStringForParse(lcc);
                stmtDesc = stmtText.length() > 255 ? stmtText.substring(0, 250) : stmtText;
            }
        } else {
            stmtDesc = cc.getStatementAlias();
        }
        stmtDesc = stmtDesc.replaceAll("\\s+", "_");
        int quoteIndex = stmtDesc.indexOf("\"");
        int n = quoteIndex = stmtDesc.startsWith("\"") ? 0 : quoteIndex;
        if (quoteIndex > -1) {
            if (!(stmtDesc = stmtDesc.replaceAll("\"", "\\\\\"")).startsWith("\"")) {
                stmtDesc = "\"" + stmtDesc;
            }
            if (!stmtDesc.endsWith("\"") || stmtDesc.endsWith("\\\"")) {
                stmtDesc = stmtDesc + "\"";
            }
        }
        SanityManager.DEBUG_PRINT((String)"info:statementAlias:", (String)("creating statistics with stmtDesc=" + stmtDesc));
        StatementStats st = StatementStats.newInstance(stmtDesc, this.createQueryInfo(), this.getUniqueIdFromStatementText(lcc));
        assert (this.preparedStmt != null) : " prepMinion: At this time prepared statement cannot be null ";
        this.preparedStmt.setStatementStats(st);
        cc.setStatementStats(st);
        if (!st.isCreatedWithExistingStats()) {
            GfxdManagementService.handleEvent(7, this);
        }
    }

    private final StatementStats getQueryNodeStatementStats() {
        GenericPreparedStatement gps = null;
        try {
            GenericLanguageConnectionContext lcc = (GenericLanguageConnectionContext)ConnectionUtil.getCurrentLCC();
            short qnExecFlags = this.execFlags;
            qnExecFlags = GemFireXDUtils.set(qnExecFlags, (short)2);
            GenericStatement g = new GenericStatement(this.compilationSchema, this.statementText, qnExecFlags, null);
            gps = lcc.seekGenericPreparedStatement(g);
            if (gps != null) {
                return gps.getStatementStats();
            }
        }
        catch (SQLException e) {
            gps = null;
        }
        catch (StandardException e) {
            gps = null;
        }
        return null;
    }

    protected int getUniqueIdFromStatementText(LanguageConnectionContext lcc) {
        return this.stmtHash;
    }

    public void setReplicatedFlag(boolean allTablesReplicated) {
        if (allTablesReplicated) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GenericStatement::setReplicatedFlag - Setting ALL_TABLES_ARE_REPLICATED_ON_REMOTE to TRUE");
            }
            this.execFlags = GemFireXDUtils.set(this.execFlags, (short)64);
        } else {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GenericStatement::setReplicatedFlag - Flag ALL_TABLES_ARE_REPLICATED_ON_REMOTE is being cleared");
            }
            this.execFlags = GemFireXDUtils.clear(this.execFlags, (short)64);
        }
    }
}

