/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.timer;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.timer.TimerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private Timer singletonTimer;

    public SingletonTimerFactory() {
        ClassLoader savecl = null;
        boolean hasGetClassLoaderPerms = false;
        try {
            savecl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            hasGetClassLoaderPerms = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (hasGetClassLoaderPerms) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(null);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.singletonTimer = new Timer(true);
        if (hasGetClassLoaderPerms) {
            try {
                final ClassLoader tmpsavecl = savecl;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(tmpsavecl);
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public Timer getCancellationTimer() {
        return this.singletonTimer;
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }
}

