/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.stream;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.GFToSlf4jBridge;
import com.gemstone.gemfire.internal.PureLogWriter;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.stream.PrintWriterGetHeader;
import com.pivotal.gemfirexd.internal.impl.services.stream.BasicHeaderPrintWriter;
import com.pivotal.gemfirexd.internal.impl.services.stream.SingleStream;
import com.pivotal.gemfirexd.internal.shared.common.sanity.GfxdHeaderPrintWriter;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class GfxdHeaderPrintWriterImpl
extends BasicHeaderPrintWriter
implements GfxdHeaderPrintWriter {
    private LogWriter logger;
    private volatile boolean skipPrintLnForLogger;
    private PureLogWriter pureLogger;
    private boolean usingSLF4JBridge;

    public GfxdHeaderPrintWriterImpl(OutputStream writeTo, String fileName, PrintWriterGetHeader headerGetter, boolean canClose, String streamName) {
        super(writeTo, headerGetter, canClose, streamName);
        if (PropertyUtil.getSystemBoolean("gemfire.enable.slf4j.log.bridge", true)) {
            this.usingSLF4JBridge = true;
            this.logger = new GFToSlf4jBridge("SNAPPY", fileName);
        }
    }

    @Override
    public void printlnWithHeader(String message) {
        this.put("TRACE", message, null);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        LogWriter log = this.logger;
        if (log != null) {
            log.info(new String(buf, off, len));
            this.skipPrintLnForLogger = true;
        } else {
            this.moveToEndOfStream();
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        LogWriter log = this.logger;
        if (log != null) {
            log.info(s.substring(off, off + len));
            this.skipPrintLnForLogger = true;
        } else {
            this.moveToEndOfStream();
            super.write(s, off, len);
        }
    }

    @Override
    public void println() {
        LogWriter log = this.logger;
        if (log != null) {
            if (!this.skipPrintLnForLogger) {
                log.info(SanityManager.lineSeparator);
            } else {
                this.skipPrintLnForLogger = false;
            }
        } else {
            this.moveToEndOfStream();
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String flag, String message, Throwable t) {
        GFToSlf4jBridge slf4logger;
        PureLogWriter pureLog = this.pureLogger;
        if (pureLog != null) {
            boolean doLog;
            int colonIndex;
            int level = -1;
            int defaultLevel = 800;
            String levelName = PureLogWriter.levelToString((int)800);
            if (flag != null && (colonIndex = flag.indexOf(58)) > 0) {
                levelName = flag.substring(0, colonIndex);
                try {
                    flag = flag.substring(colonIndex + 1);
                    level = !levelName.equalsIgnoreCase("dump") ? PureLogWriter.levelNameToCode((String)levelName) : Integer.MAX_VALUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (level == -1) {
                if (pureLog.getLevel() > 800) {
                    levelName = "TRACE";
                }
                doLog = true;
            } else {
                boolean bl = doLog = pureLog.getLevel() <= level;
            }
            if (doLog) {
                String formattedMessage = SanityManager.formatMessage((String)levelName, (String)flag, (String)message, (Throwable)t).append(SanityManager.lineSeparator).toString();
                pureLog.writeFormattedMessage(formattedMessage);
            }
        } else if (this.usingSLF4JBridge && (slf4logger = (GFToSlf4jBridge)this.logger) != null) {
            int colonIndex;
            int level = 800;
            if (flag != null && (colonIndex = flag.indexOf(58)) > 0) {
                String levelName = flag.substring(0, colonIndex);
                try {
                    flag = flag.substring(colonIndex + 1);
                    level = !levelName.equalsIgnoreCase("dump") ? PureLogWriter.levelNameToCode((String)levelName) : Integer.MAX_VALUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (slf4logger.getLevel() <= level) {
                StringBuilder sb = new StringBuilder();
                if (flag != null) {
                    sb.append(flag).append(": ");
                }
                sb.append(message);
                slf4logger.put(level, sb.toString(), t);
            }
        } else {
            LogWriter log = this.logger;
            if (log != null) {
                boolean forceLog;
                int colonIndex = -1;
                boolean bl = forceLog = flag != null && (colonIndex = flag.indexOf(58)) > 0 && flag.substring(0, colonIndex).equalsIgnoreCase("dump");
                if (log.infoEnabled() && !forceLog) {
                    StringBuilder sb = new StringBuilder("GFXD");
                    if (flag != null) {
                        sb.append(':').append(flag);
                    }
                    sb.append(": ").append(message);
                    log.info(sb.toString(), t);
                } else if (forceLog) {
                    flag = flag.substring(colonIndex + 1);
                    log.warning("GFXD:" + flag + ": " + message, t);
                }
            } else {
                String formattedMessage = SanityManager.formatMessage(null, (String)flag, (String)message, (Throwable)t).append(SanityManager.lineSeparator).toString();
                Object object = this.lock;
                synchronized (object) {
                    this.moveToEndOfStream();
                    super.write(formattedMessage, 0, formattedMessage.length());
                    super.flush();
                }
            }
        }
    }

    protected final void moveToEndOfStream() {
        FileOutputStream fos;
        SingleStream ss;
        ModuleFactory mf = Monitor.getMonitor();
        if (mf != null && (ss = (SingleStream)mf.getSystemStreams()) != null && (fos = ss.fileStream) != null) {
            try {
                FileChannel fch = fos.getChannel();
                long pos = fch.position();
                long size = fch.size();
                if (pos < size) {
                    fch.position(size);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final boolean isFineEnabled() {
        PureLogWriter pureLog = this.pureLogger;
        if (pureLog != null) {
            return pureLog.fineEnabled();
        }
        LogWriter log = this.logger;
        return log != null && log.fineEnabled();
    }

    public final boolean isFinerEnabled() {
        PureLogWriter pureLog = this.pureLogger;
        if (pureLog != null) {
            return pureLog.finerEnabled();
        }
        LogWriter log = this.logger;
        return log != null && log.finerEnabled();
    }

    public void refreshDebugFlag(String debugFlag, boolean enable) {
        GemFireXDUtils.initFlags();
    }

    public void setLogWriter(LogWriter logger) {
        assert (logger != null);
        if (logger instanceof PureLogWriter) {
            this.pureLogger = (PureLogWriter)logger;
            this.logger = null;
            this.out = this.pureLogger.getPrintWriter();
            GfxdLogWriter.getInstance().setLogWriter(this.pureLogger);
        } else if (logger instanceof GFToSlf4jBridge) {
            this.usingSLF4JBridge = true;
            this.pureLogger = null;
            this.logger = logger;
        } else {
            this.pureLogger = null;
            this.logger = logger;
        }
        this.lock = logger;
    }

    @Override
    public void flush() {
        if (this.logger == null) {
            super.flush();
        }
    }

    @Override
    public void close() {
        if (this.pureLogger == null && this.logger == null) {
            super.close();
        }
    }

    @Override
    public int getLogSeverityLevel() {
        LogWriter log = this.getLogger();
        if (log != null) {
            if (log.fineEnabled()) {
                return 0;
            }
            if (log.infoEnabled()) {
                return 20000;
            }
            if (log.warningEnabled()) {
                return 40000;
            }
            if (log.severeEnabled()) {
                return 45000;
            }
            return 50000;
        }
        return super.getLogSeverityLevel();
    }

    private LogWriter getLogger() {
        PureLogWriter pureLog = this.pureLogger;
        if (pureLog != null) {
            return pureLog;
        }
        return this.logger;
    }

    @Override
    public boolean printStackTrace(Throwable error, int logSeverityLevel) {
        if (logSeverityLevel >= 20000 && error instanceof StandardException) {
            StandardException se = (StandardException)error;
            if (se.getSQLState().startsWith("23") || se.getSQLState().startsWith("X0Z02")) {
                return false;
            }
            LogWriter log = this.getLogger();
            if (log != null && !log.fineEnabled() && se.getSQLState().startsWith("42")) {
                return false;
            }
        }
        return true;
    }

    public static final class GfxdLogWriter
    implements PrintWriterGetHeader {
        private static final GfxdLogWriter _self = new GfxdLogWriter();
        private PureLogWriter pureLogger;

        public static GfxdLogWriter getInstance() {
            return _self;
        }

        void setLogWriter(PureLogWriter logger) {
            this.pureLogger = logger;
        }

        @Override
        public String getHeader() {
            String levelStr = null;
            String connectionName = null;
            if (this.pureLogger != null) {
                int level = 800;
                if (this.pureLogger.getLevel() > level) {
                    level = this.pureLogger.getLevel();
                }
                levelStr = PureLogWriter.levelToString((int)level);
                connectionName = this.pureLogger.getConnectionName();
            }
            return SanityManager.formatHeader(levelStr, (String)(connectionName != null ? connectionName : "TRACE")).toString();
        }
    }
}

