/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.services.reflect.DatabaseClasses;
import com.pivotal.gemfirexd.internal.impl.services.reflect.LoadedGeneratedClass;
import com.pivotal.gemfirexd.internal.impl.services.reflect.ReflectGeneratedClass;
import com.pivotal.gemfirexd.internal.impl.services.reflect.ReflectLoaderJava2;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public final class ReflectClassesJava2
extends DatabaseClasses
implements PrivilegedAction {
    private HashMap preCompiled;
    private int action = -1;

    @Override
    synchronized LoadedGeneratedClass loadGeneratedClassFromData(String fullyQualifiedName, ByteArray classDump) {
        if (classDump == null || classDump.getArray() == null) {
            if (this.preCompiled == null) {
                this.preCompiled = new HashMap();
            } else {
                ReflectGeneratedClass gc = (ReflectGeneratedClass)this.preCompiled.get(fullyQualifiedName);
                if (gc != null) {
                    return gc;
                }
            }
            try {
                Class<?> jvmClass = Class.forName(fullyQualifiedName);
                ReflectGeneratedClass gc = new ReflectGeneratedClass(this, jvmClass, null);
                this.preCompiled.put(fullyQualifiedName, gc);
                return gc;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NoClassDefFoundError(cnfe.toString());
            }
        }
        this.action = 1;
        return ((ReflectLoaderJava2)AccessController.doPrivileged(this)).loadGeneratedClass(fullyQualifiedName, classDump);
    }

    public final Object run() {
        try {
            switch (this.action) {
                case 1: {
                    ReflectLoaderJava2 reflectLoaderJava2 = new ReflectLoaderJava2(this.getClass().getClassLoader(), this);
                    return reflectLoaderJava2;
                }
                case 2: {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return classLoader;
                }
            }
            Object var1_3 = null;
            return var1_3;
        }
        finally {
            this.action = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Class loadClassNotInDatabaseJar(String name) throws ClassNotFoundException {
        Class<?> foundClass = null;
        try {
            ClassLoader cl;
            ReflectClassesJava2 reflectClassesJava2 = this;
            synchronized (reflectClassesJava2) {
                this.action = 2;
                cl = (ClassLoader)AccessController.doPrivileged(this);
            }
            foundClass = cl != null ? cl.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            foundClass = Class.forName(name);
        }
        return foundClass;
    }
}

