/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.monitor;

import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FileUtil;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.impl.services.monitor.BaseMonitor;
import com.pivotal.gemfirexd.internal.impl.services.stream.GfxdHeaderPrintWriterImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public final class FileMonitor
extends BaseMonitor
implements PrivilegedExceptionAction<Object> {
    private File home;
    private ProductVersionHolder engineVersion;
    private int action;
    private String key3;
    private String value3;
    private Runnable task;
    private int intValue;

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintStream log) {
        this.runWithState(properties, log);
    }

    private InputStream PBapplicationPropertiesStream(BaseMonitor m) throws IOException {
        String fileName = this.PBgetJVMProperty("gemfirexd.properties");
        if (fileName == null) {
            fileName = this.PBgetJVMProperty("sqlfire.properties");
        }
        if (fileName != null) {
            File sr = FileUtil.newFile(null, fileName);
            if (!sr.exists()) {
                String errorStr = "[warning] " + fileName + " gemfirexd.properties not found to read ";
                HeaderPrintWriter hpw = Monitor.getStream();
                if (hpw == null) {
                    new GfxdHeaderPrintWriterImpl(System.err, null, GfxdHeaderPrintWriterImpl.GfxdLogWriter.getInstance(), true, "System.err").println(errorStr);
                    this.getTempWriter().append(errorStr);
                }
                throw new IOException(errorStr);
            }
            return new FileInputStream(sr);
        }
        File sr = FileUtil.newFile(this.home, "gemfirexd.properties");
        File sqlfsr = FileUtil.newFile(this.home, "sqlfire.properties");
        if (!sr.exists()) {
            File userhome = new File(System.getProperty("user.home"));
            if (!sqlfsr.exists()) {
                if (!userhome.exists() || !userhome.isDirectory()) {
                    return null;
                }
                sr = FileUtil.newFile(userhome, "gemfirexd.properties");
                if (!sr.exists()) {
                    sr = FileUtil.newFile(userhome, "sqlfire.properties");
                    sqlfsr = sr;
                    if (!sqlfsr.exists()) {
                        return null;
                    }
                    this.PBsetJVMProperty("gemfirexd.__rt.isSQLFire", Boolean.TRUE.toString());
                    PropertyUtil.setSQLFire();
                }
            } else {
                this.PBsetJVMProperty("gemfirexd.__rt.isSQLFire", Boolean.TRUE.toString());
                PropertyUtil.setSQLFire();
            }
        }
        return new FileInputStream(PropertyUtil.isSQLFire ? sqlfsr : sr);
    }

    @Override
    public Object getEnvironment() {
        return this.home;
    }

    private boolean PBinitialize(boolean lite) {
        String systemHome;
        if (!lite) {
            try {
                this.daemonGroup = new ThreadGroup("gemfirexd.daemons");
                this.daemonGroup.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        InputStream versionStream = this.getClass().getResourceAsStream("/com/pivotal/gemfirexd/internal/info/DBMS.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv((InputStream)versionStream);
        try {
            systemHome = System.getProperty("gemfirexd.system.home");
            if (systemHome == null) {
                systemHome = System.getProperty("sqlfire.system.home");
            }
        }
        catch (SecurityException se) {
            systemHome = null;
        }
        if (systemHome != null) {
            this.home = new File(systemHome);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("gemfirexd.system.home=" + systemHome + " does not represent a directory");
                    return false;
                }
            } else if (!lite) {
                try {
                    boolean se = this.home.mkdir() || this.home.mkdirs();
                }
                catch (SecurityException se) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private String PBsetJVMProperty(String key, String value) {
        try {
            return System.setProperty(key, value);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private String PBclearJVMProperty(String key) {
        try {
            return System.clearProperty(key);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    @Override
    final synchronized boolean initialize(boolean lite) {
        this.action = lite ? 0 : 1;
        try {
            Object ret = AccessController.doPrivileged(this);
            return (Boolean)ret;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    final synchronized Properties getDefaultModuleProperties() {
        this.action = 2;
        try {
            return (Properties)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    public final synchronized String getJVMProperty(String key) {
        if (!key.startsWith("gemfirexd.") && !key.startsWith("derby.")) {
            return this.PBgetJVMProperty(key);
        }
        try {
            this.action = 3;
            this.key3 = key;
            String value = (String)AccessController.doPrivileged(this);
            this.key3 = null;
            return value;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    public final synchronized String setJVMProperty(String key, String value) {
        if (!key.startsWith("gemfirexd.") || !key.startsWith("derby.")) {
            return this.PBsetJVMProperty(key, value);
        }
        try {
            this.action = 7;
            this.key3 = key;
            this.value3 = value;
            String rValue = (String)AccessController.doPrivileged(this);
            this.key3 = null;
            this.value3 = null;
            return rValue;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    public final synchronized String clearJVMProperty(String key) {
        if (!key.startsWith("gemfirexd.") || !key.startsWith("derby.")) {
            return this.PBclearJVMProperty(key);
        }
        try {
            this.action = 8;
            this.key3 = key;
            String rValue = (String)AccessController.doPrivileged(this);
            this.key3 = null;
            return rValue;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    public final synchronized Thread getDaemonThread(Runnable task, String name, boolean setMinPriority) {
        this.action = 4;
        this.key3 = name;
        this.task = task;
        this.intValue = setMinPriority ? 1 : 0;
        try {
            Thread t = (Thread)AccessController.doPrivileged(this);
            this.key3 = null;
            task = null;
            return t;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    public final synchronized void setThreadPriority(int priority) {
        this.action = 5;
        this.intValue = priority;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    @Override
    final synchronized InputStream applicationPropertiesStream() throws IOException {
        this.action = 6;
        try {
            return (InputStream)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    @Override
    public final synchronized Object run() throws IOException {
        switch (this.action) {
            case 0: 
            case 1: {
                return this.PBinitialize(this.action == 0);
            }
            case 2: {
                return super.getDefaultModuleProperties();
            }
            case 3: {
                return this.PBgetJVMProperty(this.key3);
            }
            case 4: {
                return super.getDaemonThread(this.task, this.key3, this.intValue != 0);
            }
            case 5: {
                super.setThreadPriority(this.intValue);
                return null;
            }
            case 6: {
                return this.PBapplicationPropertiesStream(this);
            }
            case 7: {
                return this.PBsetJVMProperty(this.key3, this.value3);
            }
            case 8: {
                return this.PBclearJVMProperty(this.key3);
            }
        }
        return null;
    }

    @Override
    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }
}

