/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import java.util.Hashtable;

public class TableNameInfo {
    private DataDictionary dd;
    private Hashtable ddCache;
    private Hashtable tdCache;
    private Hashtable tableCache = new Hashtable(31);
    private Hashtable indexCache;

    public TableNameInfo(LanguageConnectionContext lcc, boolean andIndex) throws StandardException {
        if (andIndex) {
            this.indexCache = new Hashtable(13);
        }
        TransactionController tc = lcc.getTransactionExecute();
        this.dd = lcc.getDataDictionary();
        this.ddCache = this.dd.hashAllConglomerateDescriptorsByNumber(tc);
        this.tdCache = this.dd.hashAllTableDescriptorsByTableId(tc);
    }

    public String getTableName(Long conglomId) {
        if (conglomId == null) {
            return "?";
        }
        TableDescriptor td = (TableDescriptor)this.tableCache.get(conglomId);
        if (td == null) {
            ConglomerateDescriptor cd = (ConglomerateDescriptor)this.ddCache.get(conglomId);
            if (cd != null) {
                td = (TableDescriptor)this.tdCache.get(cd.getTableID());
            }
            if (cd == null || td == null) {
                String name;
                if (conglomId > 20L) {
                    name = "*** TRANSIENT_" + conglomId;
                } else {
                    switch (conglomId.intValue()) {
                        case 0: {
                            name = "*** INVALID CONGLOMERATE ***";
                            break;
                        }
                        case 1: {
                            name = "ConglomerateDirectory";
                            break;
                        }
                        case 2: {
                            name = "PropertyConglomerate";
                            break;
                        }
                        default: {
                            name = "*** INTERNAL TABLE " + conglomId;
                        }
                    }
                }
                return name;
            }
            this.tableCache.put(conglomId, td);
            if (this.indexCache != null && cd.isIndex()) {
                this.indexCache.put(conglomId, cd.getConglomerateName());
            }
        }
        return td.getName();
    }

    public String getTableType(Long conglomId) {
        String type;
        if (conglomId == null) {
            return "?";
        }
        TableDescriptor td = (TableDescriptor)this.tableCache.get(conglomId);
        if (td != null) {
            switch (td.getTableType()) {
                case 0: {
                    type = "T";
                    break;
                }
                case 1: {
                    type = "S";
                    break;
                }
                case 6: {
                    type = "C";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)("Illegal table type " + td.getName() + " " + td.getTableType()));
                    type = "?";
                    break;
                }
            }
        } else {
            type = conglomId > 20L ? "T" : "S";
        }
        return type;
    }

    public String getIndexName(Long conglomId) {
        if (conglomId == null) {
            return "?";
        }
        return (String)this.indexCache.get(conglomId);
    }
}

