/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.locks.AbstractPool;
import com.pivotal.gemfirexd.internal.impl.services.locks.ActiveLock;
import com.pivotal.gemfirexd.internal.impl.services.locks.Control;
import com.pivotal.gemfirexd.internal.impl.services.locks.D_LockControl;
import com.pivotal.gemfirexd.internal.impl.services.locks.Deadlock;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockControl;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockTable;
import com.pivotal.gemfirexd.internal.impl.services.locks.SinglePool;
import com.pivotal.gemfirexd.internal.impl.services.locks.Timeout;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class LockSet
implements LockTable {
    private final SinglePool factory;
    private final HashMap locks;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private int blockCount;

    protected LockSet(SinglePool factory) {
        this.factory = factory;
        this.locks = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable ref, Object qualifier, int timeout) throws StandardException {
        int actualTimeout;
        Lock lockItem;
        LockControl control;
        if (SanityManager.TraceMemoryLeak && this.locks.size() > 1000) {
            System.out.println("TraceMemoryLeak:LockSet: " + this.locks.size());
        }
        String lockDebug = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control gc = this.getControl(ref);
            if (gc == null) {
                Lock gl = new Lock(compatibilitySpace, ref, qualifier);
                gl.grant();
                this.locks.put(ref, gl);
                return gl;
            }
            control = gc.getLockControl();
            if (control != gc) {
                this.locks.put(ref, control);
            }
            SanityManager.ASSERT((boolean)ref.equals(control.getLockable()));
            if (this.getControl(control.getLockable()) != control) {
                SanityManager.THROWASSERT((String)("lockObject mismatched lock items " + this.getControl(control.getLockable()) + " " + control));
            }
            if ((lockItem = control.addLock(this, compatibilitySpace, qualifier)).getCount() != 0) {
                return lockItem;
            }
            if (AbstractPool.noLockWait(timeout, compatibilitySpace)) {
                control.giveUpWait(lockItem, this);
                if (SanityManager.DEBUG_ON((String)"DeadlockTrace")) {
                    SanityManager.showTrace((Throwable)new Throwable());
                    lockDebug = DiagnosticUtil.toDiagString(lockItem) + "\nCould not grant lock with zero timeout, here's the table" + this.toDebugString();
                }
                return null;
            }
        }
        boolean deadlockWait = false;
        if (timeout == -1) {
            deadlockWait = true;
            actualTimeout = this.deadlockTimeout;
            if (actualTimeout == -1) {
                actualTimeout = 20000;
            }
        } else {
            if (timeout == -2) {
                timeout = actualTimeout = this.waitTimeout;
            } else {
                actualTimeout = timeout;
            }
            if (this.deadlockTimeout >= 0) {
                if (actualTimeout < 0) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                } else if (this.deadlockTimeout < actualTimeout) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                    timeout -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock waitingLock = (ActiveLock)lockItem;
        lockItem = null;
        int earlyWakeupCount = 0;
        long startWaitTime = 0L;
        while (true) {
            byte wakeupReason = waitingLock.waitForGrant(actualTimeout);
            ActiveLock nextWaitingLock = null;
            Object[] deadlockData = null;
            try {
                boolean willQuitWait;
                Enumeration timeoutLockTable = null;
                long currentTime = 0L;
                LockSet lockSet2 = this;
                synchronized (lockSet2) {
                    block41: {
                        if (!control.isGrantable(control.firstWaiter() == waitingLock, compatibilitySpace, qualifier)) break block41;
                        control.grant(waitingLock);
                        nextWaitingLock = control.getNextWaiter(waitingLock, true, this);
                        ActiveLock activeLock = waitingLock;
                        return activeLock;
                    }
                    waitingLock.clearPotentiallyGranted();
                    boolean bl = willQuitWait = wakeupReason != 1;
                    if (wakeupReason == 0 && deadlockWait || wakeupReason == 2) {
                        deadlockData = Deadlock.look(this.factory, this, control, waitingLock, wakeupReason);
                        if (deadlockData == null) {
                            deadlockWait = false;
                            actualTimeout = timeout;
                            startWaitTime = 0L;
                            willQuitWait = false;
                        } else {
                            willQuitWait = true;
                        }
                    }
                    nextWaitingLock = control.getNextWaiter(waitingLock, willQuitWait, this);
                    if (willQuitWait) {
                        if (SanityManager.DEBUG_ON((String)"DeadlockTrace")) {
                            SanityManager.showTrace((Throwable)new Throwable());
                            lockDebug = DiagnosticUtil.toDiagString(waitingLock) + "\nGot deadlock/timeout, here's the table" + this.toDebugString();
                        }
                        if (this.deadlockTrace && deadlockData == null) {
                            currentTime = System.currentTimeMillis();
                            timeoutLockTable = this.factory.makeVirtualLockTable();
                        }
                    }
                }
                if (willQuitWait) {
                    if (lockDebug != null) {
                        String type = deadlockData != null ? "deadlock:" : "timeout:";
                        SanityManager.DEBUG_PRINT((String)type, (String)("wait on lockitem caused " + type + lockDebug));
                    }
                    if (deadlockData == null) {
                        if (this.deadlockTrace) {
                            throw Timeout.buildException(waitingLock, timeoutLockTable, currentTime);
                        }
                        StandardException se = StandardException.newException("40XL1");
                        throw se;
                    }
                    throw Deadlock.buildException(this.factory, deadlockData);
                }
            }
            finally {
                if (nextWaitingLock != null) {
                    nextWaitingLock.wakeUp((byte)1);
                    nextWaitingLock = null;
                }
            }
            if (actualTimeout == -1) continue;
            if (wakeupReason != 0) {
                ++earlyWakeupCount;
            }
            if (earlyWakeupCount <= 5) continue;
            long now = System.currentTimeMillis();
            if (startWaitTime != 0L) {
                long sleepTime = now - startWaitTime;
                actualTimeout = (int)((long)actualTimeout - sleepTime);
            }
            startWaitTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Latch item, int unlockCount) {
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            SanityManager.DEBUG((String)"LockTrace", (String)("Release lock: " + DiagnosticUtil.toDiagString(item)));
        }
        boolean tryGrant = false;
        ActiveLock nextGrant = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(item.getLockable());
            if (item.getLockable() == null) {
                SanityManager.THROWASSERT((String)("item.getLockable() = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item)));
            }
            if (control == null) {
                SanityManager.THROWASSERT((String)("control = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item)));
            }
            if (this.getControl(control.getLockable()) != control) {
                SanityManager.THROWASSERT((String)("unlock mismatched lock items " + this.getControl(control.getLockable()) + " " + control));
            }
            if (unlockCount != 0 && unlockCount > item.getCount()) {
                SanityManager.THROWASSERT((String)("unlockCount " + unlockCount + " larger than actual lock count " + item.getCount() + " item " + item));
            }
            tryGrant = control.unlock(item, unlockCount);
            item = null;
            boolean mayBeEmpty = true;
            if (tryGrant && (nextGrant = control.firstWaiter()) != null) {
                mayBeEmpty = false;
                if (!nextGrant.setPotentiallyGranted()) {
                    nextGrant = null;
                }
            }
            if (mayBeEmpty) {
                if (control.isEmpty()) {
                    this.locks.remove(control.getLockable());
                }
                return;
            }
        }
        if (tryGrant && nextGrant != null) {
            nextGrant.wakeUp((byte)1);
        }
    }

    @Override
    public synchronized Lock unlockReference(CompatibilitySpace space, Lockable ref, Object qualifier, Map group) {
        Control control = this.getControl(ref);
        if (control == null) {
            return null;
        }
        Lock setLock = control.getLock(space, qualifier);
        if (setLock == null) {
            return null;
        }
        Lock lockInGroup = (Lock)group.remove(setLock);
        if (lockInGroup != null) {
            this.unlock(lockInGroup, 1);
        }
        return lockInGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zeroDurationLockObject(CompatibilitySpace space, Lockable ref, Object qualifier, int timeout) throws StandardException {
        Object t;
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Zero Duration Lock Request before Grant: ", space, null, ref, qualifier, timeout);
            if (SanityManager.DEBUG_ON((String)"LockStackTrace")) {
                t = new Throwable();
                PrintWriter istream = SanityManager.GET_DEBUG_STREAM();
                istream.println("Stack trace of lock request:");
                ((Throwable)t).printStackTrace(istream);
            }
        }
        t = this;
        synchronized (t) {
            Control control = this.getControl(ref);
            if (control == null) {
                return true;
            }
            if (control.isGrantable(true, space, qualifier)) {
                return true;
            }
            if (AbstractPool.noLockWait(timeout, space)) {
                return false;
            }
        }
        Lock lock = this.lockObject(space, ref, qualifier, timeout);
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Zero Lock Request Granted: ", space, null, ref, qualifier, timeout);
        }
        this.unlock(lock, 1);
        return true;
    }

    @Override
    public void setDeadlockTimeout(int timeout) {
        this.deadlockTimeout = timeout;
    }

    @Override
    public void setWaitTimeout(int timeout) {
        this.waitTimeout = timeout;
    }

    @Override
    public void setDeadlockTrace(boolean val) {
        this.deadlockTrace = val;
    }

    public String toDebugString() {
        String str = new String();
        int i = 0;
        Iterator it = this.locks.values().iterator();
        while (it.hasNext()) {
            str = str + "\n  lock[" + i + "]: " + DiagnosticUtil.toDiagString(it.next());
        }
        return str;
    }

    @Override
    public void addWaiters(Map waiters) {
        for (Control control : this.locks.values()) {
            control.addWaiters(waiters);
        }
    }

    @Override
    public synchronized Map shallowClone() {
        HashMap<Lockable, Control> clone = new HashMap<Lockable, Control>();
        for (Lockable lockable : this.locks.keySet()) {
            Control control = this.getControl(lockable);
            clone.put(lockable, control.shallowClone());
        }
        return clone;
    }

    @Override
    public void oneMoreWaiter() {
        ++this.blockCount;
    }

    @Override
    public void oneLessWaiter() {
        --this.blockCount;
    }

    @Override
    public synchronized boolean anyoneBlocked() {
        SanityManager.ASSERT((this.blockCount >= 0 ? 1 : 0) != 0, (String)"blockCount should not be negative");
        return this.blockCount != 0;
    }

    private final Control getControl(Lockable ref) {
        return (Control)this.locks.get(ref);
    }
}

