/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;

public final class ActiveLock
extends Lock {
    byte wakeUpNow;
    boolean potentiallyGranted;
    protected boolean canSkip;

    protected ActiveLock(CompatibilitySpace space, Lockable ref, Object qualifier) {
        super(space, ref, qualifier);
    }

    protected boolean setPotentiallyGranted() {
        if (!this.potentiallyGranted) {
            this.potentiallyGranted = true;
            return true;
        }
        return false;
    }

    protected void clearPotentiallyGranted() {
        this.potentiallyGranted = false;
    }

    protected synchronized byte waitForGrant(int timeout) throws StandardException {
        if (this.wakeUpNow == 0) {
            try {
                if (timeout == -1) {
                    this.wait();
                } else if (timeout > 0) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException ie) {
                throw StandardException.interrupt(ie);
            }
        }
        byte why = this.wakeUpNow;
        this.wakeUpNow = 0;
        return why;
    }

    protected synchronized void wakeUp(byte why) {
        if (this.wakeUpNow != 2) {
            this.wakeUpNow = why;
        }
        this.notify();
    }
}

