/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.jmx;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.info.Version;
import com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.mbeans.ManagementMBean;
import com.pivotal.gemfirexd.internal.mbeans.VersionMBean;
import com.pivotal.gemfirexd.internal.security.SystemPermission;
import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public final class JMXManagementService
implements ManagementService,
ModuleControl {
    private MBeanServer mbeanServer;
    private Map<ObjectName, StandardMBean> registeredMbeans;
    private ObjectName myManagementBean;
    private MBeanServer myManagementServer;
    private String systemIdentifier;
    private static final SystemPermission CONTROL = new SystemPermission("jmx", "control");

    @Override
    public synchronized void boot(boolean create, Properties properties) throws StandardException {
        this.registeredMbeans = new HashMap<ObjectName, StandardMBean>();
        this.systemIdentifier = Monitor.getMonitor().getUUIDFactory().createUUID().toString();
        this.findServer();
        this.myManagementBean = (ObjectName)this.registerMBean(this, ManagementMBean.class, "type=Management");
        this.myManagementServer = this.mbeanServer;
        this.registerMBean(new Version(Monitor.getMonitor().getEngineVersion(), "engine"), VersionMBean.class, "type=Version,jar=gemfirexd.jar");
    }

    @Override
    public synchronized void stop() {
        if (this.mbeanServer == null && this.myManagementBean != null) {
            this.mbeanServer = this.myManagementServer;
            this.unregisterMBean(this.myManagementBean);
            this.mbeanServer = null;
        }
        for (ObjectName mbeanName : new HashSet<ObjectName>(this.registeredMbeans.keySet())) {
            this.unregisterMBean(mbeanName);
        }
        this.mbeanServer = null;
        this.registeredMbeans = null;
        this.myManagementServer = null;
        this.systemIdentifier = null;
    }

    private synchronized void findServer() {
        try {
            this.mbeanServer = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

                @Override
                public MBeanServer run() {
                    return ManagementFactory.getPlatformMBeanServer();
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public synchronized Object registerMBean(Object bean, final Class beanInterface, String keyProperties) throws StandardException {
        try {
            ObjectName beanName = new ObjectName("com.pivotal.gemfirexd.internal:" + keyProperties + ",system=" + this.systemIdentifier);
            StandardMBean standardMBean = new StandardMBean(bean, beanInterface){

                @Override
                protected String getClassName(MBeanInfo info) {
                    return beanInterface.getName();
                }
            };
            this.registeredMbeans.put(beanName, standardMBean);
            if (this.mbeanServer != null) {
                this.jmxRegister(standardMBean, beanName);
            }
            return beanName;
        }
        catch (JMException jme) {
            throw StandardException.plainWrapException(jme);
        }
    }

    private void jmxRegister(final StandardMBean standardMBean, final ObjectName beanName) throws JMException {
        if (this.mbeanServer.isRegistered(beanName)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JMException {
                    JMXManagementService.this.mbeanServer.registerMBean(standardMBean, beanName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (JMException)pae.getException();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void unregisterMBean(Object mbeanIdentifier) {
        if (mbeanIdentifier == null) {
            return;
        }
        this.unregisterMBean((ObjectName)mbeanIdentifier);
    }

    private synchronized void unregisterMBean(ObjectName mbeanName) {
        if (this.registeredMbeans == null) {
            return;
        }
        if (this.registeredMbeans.remove(mbeanName) == null) {
            return;
        }
        if (this.mbeanServer == null) {
            return;
        }
        this.jmxUnregister(mbeanName);
    }

    private void jmxUnregister(final ObjectName mbeanName) {
        if (!this.mbeanServer.isRegistered(mbeanName)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JMException {
                    JMXManagementService.this.mbeanServer.unregisterMBean(mbeanName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean isManagementActive() {
        return this.mbeanServer != null;
    }

    @Override
    public synchronized void startManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            return;
        }
        this.findServer();
        if (this.mbeanServer == null) {
            return;
        }
        for (ObjectName mbeanName : this.registeredMbeans.keySet()) {
            if (mbeanName.equals(this.myManagementBean) && this.mbeanServer.isRegistered(this.myManagementBean)) continue;
            try {
                this.jmxRegister(this.registeredMbeans.get(mbeanName), mbeanName);
            }
            catch (JMException jMException) {}
        }
    }

    @Override
    public synchronized void stopManagement() {
        if (this.registeredMbeans == null) {
            return;
        }
        this.checkJMXControl();
        if (this.isManagementActive()) {
            for (ObjectName mbeanName : this.registeredMbeans.keySet()) {
                if (mbeanName.equals(this.myManagementBean)) continue;
                this.jmxUnregister(mbeanName);
            }
            this.mbeanServer = null;
        }
    }

    private void checkJMXControl() {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(CONTROL);
            }
        }
        catch (AccessControlException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    @Override
    public synchronized String getSystemIdentifier() {
        return this.systemIdentifier;
    }
}

