/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.vti.VTIMetaDataTemplate;
import java.sql.SQLException;
import java.util.HashMap;

class ImportResultSetMetaData
extends VTIMetaDataTemplate {
    private final int numberOfColumns;
    private final String[] columnNames;
    private final int[] columnWidths;
    private final int[] tableColumnTypes;
    private final String[] columnTypeNames;
    private final HashMap udtClasses;

    public ImportResultSetMetaData(int numberOfColumns, String[] columnNames, int[] columnWidths, int[] tableColumnTypes, String[] columnTypeNames, HashMap udtClasses) {
        this.numberOfColumns = numberOfColumns;
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.tableColumnTypes = tableColumnTypes;
        this.columnTypeNames = columnTypeNames;
        this.udtClasses = udtClasses;
    }

    @Override
    public int getColumnCount() {
        return this.numberOfColumns;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column - 1];
    }

    @Override
    public int getColumnType(int column) {
        int colType;
        switch (this.tableColumnTypes[column - 1]) {
            case 2004: {
                colType = 2004;
                break;
            }
            case 2005: {
                colType = 2005;
                break;
            }
            case -4: {
                colType = -4;
                break;
            }
            case -3: {
                colType = -3;
                break;
            }
            case -2: {
                colType = -2;
                break;
            }
            case 2000: {
                colType = 2000;
                break;
            }
            default: {
                colType = 12;
            }
        }
        return colType;
    }

    @Override
    public int isNullable(int column) {
        return 2;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        if (this.columnWidths == null) {
            return 32672;
        }
        return this.columnWidths[column - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnTypeNames[column - 1];
    }

    public Class getUDTClass(int column) throws SQLException {
        String columnName = this.getColumnName(column);
        return (Class)this.udtClasses.get(this.getColumnName(column));
    }
}

