/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationService;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class JNDIAuthenticationSchemeBase
implements UserAuthenticator {
    protected final JNDIAuthenticationService authenticationService;
    protected String providerURL;
    private AccessFactory store;
    protected Properties initDirContextEnv;

    public JNDIAuthenticationSchemeBase(JNDIAuthenticationService as, Properties dbProperties) {
        this.authenticationService = as;
        this.setInitDirContextEnv(dbProperties);
        this.setJNDIProviderProperties();
    }

    protected abstract void setJNDIProviderProperties();

    private void setInitDirContextEnv(Properties dbProps) {
        this.initDirContextEnv = new Properties();
        if (dbProps != null) {
            Enumeration<?> keys = dbProps.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("java.naming.")) continue;
                this.initDirContextEnv.put(key, dbProps.getProperty(key));
            }
        }
    }

    protected static final SQLException getLoginSQLException(Exception e) {
        String text = MessageService.getTextMessage("08004", e);
        SQLException sqle = new SQLException(text, "08004", 40000);
        return sqle;
    }
}

