/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.util.UTF8Util;
import com.pivotal.gemfirexd.internal.impl.jdbc.ClobUpdatableReader;
import com.pivotal.gemfirexd.internal.impl.jdbc.ClobUtf8Writer;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.InternalClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBInputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBStreamControl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;

final class TemporaryClob
implements InternalClob {
    private ConnectionChild conChild;
    private final LOBStreamControl bytes;
    private boolean released = false;
    private final CharToBytePositionCache posCache = new CharToBytePositionCache();

    static InternalClob cloneClobContent(String dbName, ConnectionChild conChild, InternalClob clob) throws IOException, SQLException {
        TemporaryClob newClob = new TemporaryClob(dbName, conChild);
        newClob.copyClobContent(clob);
        return newClob;
    }

    static InternalClob cloneClobContent(String dbName, ConnectionChild conChild, InternalClob clob, long length) throws IOException, SQLException {
        TemporaryClob newClob = new TemporaryClob(dbName, conChild);
        newClob.copyClobContent(clob, length);
        return newClob;
    }

    TemporaryClob(String dbName, ConnectionChild conChild) {
        this.conChild = conChild;
        this.bytes = new LOBStreamControl(dbName);
    }

    @Override
    public synchronized void release() throws IOException {
        if (!this.released) {
            this.released = true;
            this.bytes.free();
        }
    }

    @Override
    public synchronized InputStream getRawByteStream() throws IOException {
        this.checkIfValid();
        return this.bytes.getInputStream(0L);
    }

    TemporaryClob(String dbName, String data, ConnectionChild conChild) throws IOException, SQLException, StandardException {
        this.conChild = conChild;
        this.bytes = new LOBStreamControl(dbName, this.getByteFromString(data));
    }

    @Override
    public synchronized long getBytePosition(long charPos) throws IOException {
        long bytePos;
        this.checkIfValid();
        if (charPos == this.posCache.getCharPos()) {
            bytePos = this.posCache.getBytePos();
        } else {
            long startingBytePosition = 0L;
            long charsToSkip = charPos - 1L;
            if (charPos > this.posCache.getCharPos()) {
                startingBytePosition = this.posCache.getBytePos();
                charsToSkip -= this.posCache.getCharPos() - 1L;
            }
            InputStream utf8Bytes = this.bytes.getInputStream(startingBytePosition);
            bytePos = startingBytePosition + UTF8Util.skipFully(new BufferedInputStream(utf8Bytes), charsToSkip);
            this.posCache.updateCachedPos(charPos, bytePos);
        }
        return bytePos;
    }

    @Override
    public synchronized Writer getWriter(long pos) throws IOException, SQLException {
        this.checkIfValid();
        if (pos < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        return new ClobUtf8Writer(this, pos);
    }

    @Override
    public synchronized Reader getReader(long pos) throws IOException, SQLException {
        long skipped;
        this.checkIfValid();
        if (pos < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + pos);
        }
        ClobUpdatableReader isr = new ClobUpdatableReader((LOBInputStream)this.getRawByteStream(), this.conChild);
        for (long leftToSkip = pos - 1L; leftToSkip > 0L; leftToSkip -= skipped) {
            skipped = isr.skip(leftToSkip);
            if (skipped > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return isr;
    }

    @Override
    public synchronized long getCharLength() throws IOException {
        this.checkIfValid();
        return UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
    }

    @Override
    public synchronized long getByteLength() throws IOException {
        this.checkIfValid();
        return this.bytes.getLength();
    }

    @Override
    public synchronized long insertString(String str, long insertionPoint) throws IOException, SQLException {
        long endPos;
        this.checkIfValid();
        if (insertionPoint < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + insertionPoint);
        }
        long byteInsertionPoint = this.getBytePosition(insertionPoint);
        long curByteLength = this.bytes.getLength();
        byte[] newBytes = this.getByteFromString(str);
        if (byteInsertionPoint == curByteLength) {
            try {
                this.bytes.write(newBytes, 0, newBytes.length, byteInsertionPoint);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        try {
            endPos = this.getBytePosition(insertionPoint + (long)str.length());
            this.posCache.updateCachedPos(insertionPoint, byteInsertionPoint);
        }
        catch (EOFException eofe) {
            endPos = curByteLength;
        }
        try {
            this.bytes.replaceBytes(newBytes, byteInsertionPoint, endPos);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        return str.length();
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public synchronized void truncate(long newCharLength) throws IOException, SQLException {
        this.checkIfValid();
        try {
            long byteLength = UTF8Util.skipFully(new BufferedInputStream(this.getRawByteStream()), newCharLength);
            this.bytes.truncate(byteLength);
            if (newCharLength <= this.posCache.getCharPos()) {
                this.posCache.reset();
            }
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private byte[] getByteFromString(String str) {
        byte[] buffer = new byte[3 * str.length()];
        int len = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                buffer[len++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                buffer[len++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[len++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[len++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buffer[len++] = (byte)(0xC0 | c >> 6 & 0x1F);
            buffer[len++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        byte[] buff = new byte[len];
        System.arraycopy(buffer, 0, buff, 0, len);
        return buff;
    }

    private void copyClobContent(InternalClob clob) throws IOException, SQLException {
        try {
            long byteLength = clob.getByteLength();
            this.bytes.copyData(clob.getRawByteStream(), byteLength);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private void copyClobContent(InternalClob clob, long charLength) throws IOException, SQLException {
        try {
            long byteLength = UTF8Util.skipFully(new BufferedInputStream(clob.getRawByteStream()), charLength);
            this.bytes.copyData(new BufferedInputStream(clob.getRawByteStream()), byteLength);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private final void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }

    private static class CharToBytePositionCache {
        private long charPos = 1L;
        private long bytePos = 0L;

        CharToBytePositionCache() {
        }

        long getBytePos() {
            return this.bytePos;
        }

        long getCharPos() {
            return this.charPos;
        }

        void updateCachedPos(long charPos, long bytePos) {
            if (charPos - 1L > bytePos) {
                throw new IllegalArgumentException("(charPos -1) cannot be greater than bytePos; " + (charPos - 1L) + " > " + bytePos);
            }
            this.charPos = charPos;
            this.bytePos = bytePos;
        }

        void reset() {
            this.charPos = 1L;
            this.bytePos = 0L;
        }
    }
}

