/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PositionedStoreStream
extends InputStream
implements Resetable {
    private final InputStream stream;
    private long pos = 0L;

    public PositionedStoreStream(InputStream in) {
        this.stream = in;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        if (ret > -1) {
            this.pos += (long)ret;
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = this.stream.read();
        if (ret > -1) {
            ++this.pos;
        }
        return ret;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        long ret = this.stream.skip(toSkip);
        this.pos += ret;
        return ret;
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.stream)).resetStream();
        this.pos = 0L;
    }

    @Override
    public void initStream() throws StandardException {
        ((Resetable)((Object)this.stream)).initStream();
        this.pos = 0L;
    }

    @Override
    public void closeStream() {
        ((Resetable)((Object)this.stream)).closeStream();
    }

    public void reposition(long requestedPos) throws IOException, StandardException {
        if (this.pos > requestedPos) {
            this.resetStream();
        }
        if (this.pos < requestedPos) {
            try {
                this.skipFully(requestedPos - this.pos);
            }
            catch (EOFException eofe) {
                this.resetStream();
                throw eofe;
            }
            this.pos = requestedPos;
        }
    }

    public long getPosition() {
        return this.pos;
    }

    private void skipFully(long toSkip) throws IOException {
        long skippedNow;
        for (long remaining = toSkip; remaining > 0L; remaining -= skippedNow) {
            skippedNow = this.stream.skip(remaining);
            if (skippedNow != 0L) continue;
            if (this.stream.read() == -1) {
                throw new EOFException("Reached end-of-stream prematurely, with " + remaining + " byte(s) to go");
            }
            skippedNow = 1L;
        }
    }
}

