/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBStreamControl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.shared.common.error.ExceptionUtil;
import java.io.IOException;
import java.io.OutputStream;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(b, this.pos);
        }
        catch (StandardException se) {
            throw Util.newIOException(se);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(b, off, len, this.pos);
        }
        catch (StandardException se) {
            if (se.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(se.getMessage());
            }
            throw Util.newIOException(se);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

