/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class EmbedConnectionContext
extends ContextImpl
implements ConnectionContext {
    private WeakReference connRef;

    EmbedConnectionContext(ContextManager cm, EmbedConnection conn) {
        super(cm, "JDBC_ConnectionContext");
        this.connRef = new WeakReference<EmbedConnection>(conn);
    }

    @Override
    public void cleanupOnError(Throwable error) {
        StandardException se;
        if (this.connRef == null) {
            return;
        }
        EmbedConnection conn = (EmbedConnection)this.connRef.get();
        if (error instanceof StandardException && (se = (StandardException)error).getSeverity() < 40000) {
            if (conn != null) {
                conn.needCommit = false;
            }
            return;
        }
        if (conn != null) {
            conn.setInactive();
        }
        this.connRef = null;
        this.popMe();
    }

    @Override
    public Connection getNestedConnection(boolean internal) throws SQLException {
        StatementContext sc;
        EmbedConnection conn = (EmbedConnection)this.connRef.get();
        if (conn == null || conn.isClosed()) {
            throw Util.noCurrentConnection();
        }
        if (!(internal || (sc = conn.getLanguageConnection().getStatementContext()) != null && sc.getSQLAllowed() >= 0)) {
            throw Util.noCurrentConnection();
        }
        return conn.getLocalDriver().getNewNestedConnection(conn);
    }

    @Override
    public ResultSet getResultSet(com.pivotal.gemfirexd.internal.iapi.sql.ResultSet executionResultSet) throws SQLException {
        EmbedConnection conn = (EmbedConnection)this.connRef.get();
        EmbedResultSet rs = conn.getLocalDriver().newEmbedResultSet(conn, executionResultSet, false, null, true);
        return rs;
    }

    @Override
    public boolean processInaccessibleDynamicResult(ResultSet resultSet) {
        EmbedConnection conn = (EmbedConnection)this.connRef.get();
        if (conn == null) {
            return false;
        }
        return EmbedStatement.processDynamicResult(conn, resultSet, null) != null;
    }

    public EmbedConnection getEmbedConnection() {
        return (EmbedConnection)this.connRef.get();
    }

    public static EmbedConnection getEmbedConnection(ContextManager cm) {
        EmbedConnectionContext ctx = (EmbedConnectionContext)cm.getContext("JDBC_ConnectionContext");
        if (ctx != null) {
            return (EmbedConnection)ctx.connRef.get();
        }
        return null;
    }
}

