/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import com.pivotal.gemfirexd.internal.impl.jdbc.ClobAsciiStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.ClobUpdatableReader;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.InternalClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.ReaderToAscii;
import com.pivotal.gemfirexd.internal.impl.jdbc.StoreStreamClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.TemporaryClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public final class EmbedClob
extends ConnectionChild
implements Clob,
EngineLOB,
DataSerializable.Replaceable {
    private InternalClob clob;
    private boolean isValid = true;
    private int locator;

    EmbedClob(EmbedConnection con) throws SQLException {
        super(con);
        this.clob = new TemporaryClob(con.getDBName(), this);
        con.addLOBReference(this);
    }

    public EmbedClob(EmbedConnection con, DataValueDescriptor dvd) throws StandardException {
        super(con);
        SanityManager.ASSERT((!dvd.isNull() ? 1 : 0) != 0, (String)"clob is created on top of a null column");
        InputStream storeStream = dvd.getStream();
        if (storeStream == null) {
            try {
                this.clob = new TemporaryClob("gemfirexd", dvd.getString(), this);
            }
            catch (SQLException sqle) {
                throw StandardException.newException(sqle.getSQLState(), sqle);
            }
            catch (IOException e) {
                throw StandardException.newException("XJ022.S", e);
            }
        }
        SanityManager.ASSERT((boolean)(storeStream instanceof Resetable));
        try {
            this.clob = new StoreStreamClob(storeStream, this);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S");
            }
            throw se;
        }
        if (con != null) {
            con.addLOBReference(this);
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            return this.clob.getCharLength();
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String result;
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0) {
            throw Util.generateCsSQLException("XJ071.S", new Integer(length));
        }
        try {
            int charsRead;
            int read;
            Reader reader = this.clob.getReader(pos);
            char[] chars = new char[length];
            for (charsRead = 0; charsRead < length && (read = reader.read(chars, charsRead, length - charsRead)) != -1; charsRead += read) {
            }
            reader.close();
            result = charsRead == 0 ? "" : ClientSharedUtils.newWrappedString((char[])chars, (int)0, (int)charsRead);
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", eofe);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
        return result;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            return new ClobUpdatableReader(this);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(String searchStr, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(Clob searchClob, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            this.clob.insertString(str.substring(offset, offset + len), pos);
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        return str.length();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            return new ClobAsciiStream(this.clob.getWriter(pos));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            return this.clob.getWriter(pos);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkValidity();
        if (len < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(len));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone(len);
            } else {
                this.clob.truncate(len);
            }
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", new Long(len));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    @Override
    public void free() throws SQLException {
        if (this.isValid) {
            this.isValid = false;
            try {
                this.clob.release();
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
            finally {
                if (this.localConn != null) {
                    this.localConn.removeLOBMapping(this.locator);
                }
                this.clob = null;
            }
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(length));
        }
        if (length > this.length() - pos) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(pos), new Long(length));
        }
        try {
            return new ClobUpdatableReader(this, pos - 1L, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        if (this.localConn != null) {
            this.localConn.checkIfClosed();
        }
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    private void makeWritableClobClone() throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned);
        toBeAbandoned.release();
    }

    private void makeWritableClobClone(long len) throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned, len);
        toBeAbandoned.release();
    }

    InternalClob getInternalClob() {
        return this.clob;
    }

    @Override
    public int getLocator() {
        if (this.locator == 0 && this.localConn != null) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }

    public Object replace() throws IOException {
        try {
            String s = this.getSubString(1L, (int)this.length());
            int slen = s.length();
            if (slen > 0) {
                char[] chars = ResolverUtils.getInternalChars((String)s, (int)slen);
                return HarmonySerialClob.wrapChars(chars);
            }
            return HarmonySerialClob.wrapChars(new char[0]);
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
    }
}

