/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.impl.io.BaseStorageFactory;
import com.pivotal.gemfirexd.internal.impl.io.InputStreamFile;
import com.pivotal.gemfirexd.internal.impl.io.JarStorageFactory;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;

class JarDBFile
extends InputStreamFile {
    private final JarStorageFactory storageFactory;

    JarDBFile(JarStorageFactory storageFactory, String path) {
        super(storageFactory, path);
        this.storageFactory = storageFactory;
    }

    JarDBFile(JarStorageFactory storageFactory, String parent, String name) {
        super((BaseStorageFactory)storageFactory, parent, name);
        this.storageFactory = storageFactory;
    }

    JarDBFile(JarDBFile dir, String name) {
        super(dir, name);
        this.storageFactory = dir.storageFactory;
    }

    private JarDBFile(JarStorageFactory storageFactory, String child, int pathLen) {
        super((BaseStorageFactory)storageFactory, child, pathLen);
        this.storageFactory = storageFactory;
    }

    @Override
    public boolean exists() {
        return this.getEntry() != null;
    }

    private ZipEntry getEntry() {
        return this.storageFactory.zipData.getEntry(this.path);
    }

    @Override
    public long length() {
        ZipEntry entry = this.getEntry();
        if (entry == null) {
            return 0L;
        }
        return entry.getSize();
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new JarDBFile(this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return this.storageFactory.zipData.getInputStream(zipEntry);
        }
        catch (IOException ioe) {
            throw new FileNotFoundException(this.path);
        }
    }

    @Override
    public String toString() {
        return this.path;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        File pathFile = new File(this.storageFactory.zipData.getName());
        String pathFileURL = pathFile.toURL().toString();
        return new URL("jar:" + pathFileURL + "!/" + this.path);
    }
}

