/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.impl.drda.Database;
import com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class XADatabase
extends Database {
    private EmbeddedXADataSource xaDataSource;
    private XAResource xaResource;
    private XAConnection xaConnection;

    XADatabase(String dbName) {
        super(dbName);
        this.forXA = true;
    }

    @Override
    synchronized void makeConnection(Properties p) throws SQLException {
        EngineConnection conn;
        if (this.xaDataSource == null) {
            this.xaDataSource = new EmbeddedXADataSource();
        }
        this.xaDataSource.setDatabaseName(this.shortDbName);
        this.appendAttrString(p);
        if (this.attrString != null) {
            this.xaDataSource.setConnectionAttributes(this.attrString);
        }
        if ((conn = this.getConnection()) == null) {
            this.xaConnection = this.xaDataSource.getXAConnection(this.userId, this.password);
            this.setXAResource(this.xaConnection.getXAResource());
        } else {
            conn.close();
        }
        conn = (EngineConnection)this.xaConnection.getConnection();
        conn.setAutoCommit(false);
        this.setConnection(conn);
    }

    protected void setXAResource(XAResource resource) {
        this.xaResource = resource;
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }
}

