/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.AppRequester;
import java.sql.SQLException;

class FdocaConstants {
    static final int CPT_TRIPLET_TYPE = 127;
    static final int MDD_TRIPLET_TYPE = 120;
    static final int NGDA_TRIPLET_TYPE = 118;
    static final int RLO_TRIPLET_TYPE = 113;
    static final int SDA_TRIPLET_TYPE = 112;
    static final int SDA_MD_TYPE = 1;
    static final int GDA_MD_TYPE = 2;
    static final int ROW_MD_TYPE = 3;
    static final int SQLCADTA_LID = 224;
    static final int SQLDTAGRP_LID = 208;
    static final int NULL_LID = 0;
    static final int INDICATOR_NULLABLE = 0;
    static final int NULL_DATA = 255;
    static final int TYP_NULLIND = 1;
    static final int MAX_ENV_LID = 73;
    static final int MAX_VARS_IN_NGDA = 84;
    static final int FULL_NGDA_SIZE = 255;
    static final int MDD_TRIPLET_SIZE = 7;
    static final int SDA_TRIPLET_SIZE = 12;
    static final int SQLDTA_RLO_SIZE = 6;
    static final int RLO_RPT_GRP_SIZE = 3;
    static final int SQLDTAGRP_SIZE = 3;
    static final int CPT_SIZE = 3;
    static final int FDODSC_FOOTER_SIZE = 6;
    static final int SQLDTAGRP_COL_DSC_SIZE = 3;
    static final int MAX_OVERRIDES = 250;
    static final int MDD_REST_SIZE = 5;
    static final byte[] SQLCADTA_MDD = new byte[]{7, 120, 0, 5, 3, 1, -32};
    static final byte[] SQLDTA_MDD = new byte[]{7, 120, 0, 5, 4, 1, -16};
    static final byte[] SQLDTAGRP_MDD = new byte[]{7, 120, 0, 5, 2, 1, -48};
    static final byte[] SQLCADTA_SQLDTARD_RLO = new byte[]{9, 113, -32, 84, 0, 1, -48, 0, 1, 6, 113, -16, -32, 0, 0};
    static final byte[] SQLDTA_RLO = new byte[]{6, 113, -28, -48, 0, 1};
    static final int SQLCADTA_SQLDTARD_RLO_SIZE = SQLCADTA_SQLDTARD_RLO.length;
    protected static int LONGVARCHAR_MAX_LEN = 32700;
    protected static int LONGVARBINARY_MAX_LEN = 32700;
    protected static int LONGVARCHAR_LEN_NUMBYTES = 2;
    protected static final int NUMERIC_MAX_PRECISION = 127;
    protected static final int NUMERIC_DEFAULT_PRECISION = 38;
    protected static final int NUMERIC_DEFAULT_SCALE = 0;

    FdocaConstants() {
    }

    protected static boolean isNullable(int fdocaType) {
        return (fdocaType & 1) == 1;
    }

    protected static int mapJdbcTypeToDrdaType(int jdbcType, boolean nullable, AppRequester appRequester, int[] outlen) throws SQLException {
        int drdaType = 0;
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                drdaType = 5;
                outlen[0] = 2;
                break;
            }
            case 4: {
                drdaType = 3;
                outlen[0] = 4;
                break;
            }
            case -5: {
                drdaType = 23;
                outlen[0] = 8;
                break;
            }
            case 7: {
                drdaType = 13;
                outlen[0] = 4;
                break;
            }
            case 6: 
            case 8: {
                drdaType = 11;
                outlen[0] = 8;
                break;
            }
            case 2: 
            case 3: {
                drdaType = 15;
                outlen[0] = -1;
                break;
            }
            case 91: {
                drdaType = 33;
                outlen[0] = 10;
                break;
            }
            case 92: {
                drdaType = 35;
                outlen[0] = 8;
                break;
            }
            case 93: {
                drdaType = 37;
                outlen[0] = 26;
                break;
            }
            case 1: {
                drdaType = 49;
                outlen[0] = -1;
                break;
            }
            case 12: {
                drdaType = 51;
                outlen[0] = -1;
                break;
            }
            case 2000: {
                if (appRequester.supportsUDTs()) {
                    drdaType = 81;
                    outlen[0] = -1;
                    break;
                }
                drdaType = 53;
                outlen[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -1: {
                drdaType = 53;
                outlen[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -3: 
            case -2: {
                drdaType = 41;
                outlen[0] = -1;
                break;
            }
            case -4: {
                drdaType = 43;
                outlen[0] = LONGVARBINARY_MAX_LEN;
                break;
            }
            case 2004: {
                drdaType = 201;
                outlen[0] = 32772;
                break;
            }
            case 2005: 
            case 4002: {
                drdaType = 207;
                outlen[0] = 32772;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw new SQLException("Jdbc type" + jdbcType + "not Supported yet");
            }
            default: {
                throw new SQLException("unrecognized sql type: " + jdbcType);
            }
        }
        if (!nullable) {
            --drdaType;
        }
        return drdaType;
    }
}

