/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SqlXmlUtil;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.RuleBasedCollator;
import java.util.List;

public class XML
extends DataType
implements XMLDataValue,
StreamStorable {
    protected static final short UTF8_IMPL_ID = 0;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(XML.class);
    public static final short XQ_PASS_BY_REF = 1;
    public static final short XQ_PASS_BY_VALUE = 2;
    public static final short XQ_RETURN_SEQUENCE = 3;
    public static final short XQ_RETURN_CONTENT = 4;
    public static final short XQ_EMPTY_ON_EMPTY = 5;
    public static final short XQ_NULL_ON_EMPTY = 6;
    public static final int XML_DOC_ANY = 0;
    public static final int XML_SEQUENCE = 1;
    private int xType;
    private SQLChar xmlStringValue;
    private static String xmlReqCheck = null;
    private boolean containsTopLevelAttr;
    private SqlXmlUtil tmpUtil;
    private static final int IMPL_ID_SIZE = 2;

    public XML() {
        this.xmlStringValue = null;
        this.xType = -1;
        this.containsTopLevelAttr = false;
    }

    private XML(SQLChar val, int xmlType, boolean seqWithAttr) {
        this.xmlStringValue = val == null ? null : (SQLChar)val.getClone();
        this.setXType(xmlType);
        if (seqWithAttr) {
            this.markAsHavingTopLevelAttr();
        }
    }

    @Override
    public DataValueDescriptor getClone() {
        return new XML(this.xmlStringValue, this.getXType(), this.hasTopLevelAttr());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new XML();
    }

    @Override
    public String getTypeName() {
        return "XML";
    }

    @Override
    public int typePrecedence() {
        return 180;
    }

    @Override
    public String getString() throws StandardException {
        return this.xmlStringValue == null ? null : this.xmlStringValue.getString();
    }

    @Override
    public int getLength() throws StandardException {
        return this.xmlStringValue == null ? 0 : this.xmlStringValue.getLength();
    }

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (this.xmlStringValue != null) {
            sz += this.xmlStringValue.estimateMemoryUsage();
        }
        return sz;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        in.readShort();
        this.xmlStringValue.readExternalFromArray(in);
        this.setXType(0);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        String strVal = theValue.getString();
        if (strVal == null) {
            this.xmlStringValue = null;
            this.setXType(0);
            return;
        }
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        this.xmlStringValue.setValue(strVal);
        if (theValue instanceof XMLDataValue) {
            this.setXType(((XMLDataValue)theValue).getXType());
            if (((XMLDataValue)theValue).hasTopLevelAttr()) {
                this.markAsHavingTopLevelAttr();
            }
        }
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        String valAsStr = resultSet.getString(colNumber);
        if (this.tmpUtil == null) {
            try {
                this.tmpUtil = new SqlXmlUtil();
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT((String)"Failed to instantiate SqlXmlUtil for XML parsing.");
                this.xmlStringValue.setValue(valAsStr);
                this.setXType(-1);
                return;
            }
        }
        try {
            valAsStr = this.tmpUtil.serializeToString(valAsStr);
            this.xmlStringValue.setValue(valAsStr);
            this.setXType(0);
        }
        catch (Throwable t) {
            this.xmlStringValue.setValue(valAsStr);
            this.setXType(-1);
        }
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (!(other instanceof XMLDataValue)) {
            SanityManager.ASSERT((boolean)(other instanceof XMLDataValue), (String)"Store should NOT have tried to compare an XML value with a non-XML value.");
        }
        if (this.isNull()) {
            if (other.isNull()) {
                return 0;
            }
            return -1;
        }
        if (other.isNull()) {
            return 1;
        }
        SanityManager.THROWASSERT((String)"Store tried to compare two non-null XML values, which isn't allowed.");
        return 0;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        if (!(source instanceof XMLDataValue)) {
            SanityManager.ASSERT((boolean)(source instanceof XMLDataValue), (String)"Tried to store non-XML value into XML column; should have thrown error at compile time.");
        }
        if (((XMLDataValue)source).getXType() != 0) {
            throw StandardException.newException("2200L");
        }
        this.setValue(source);
    }

    @Override
    public int getTypeFormatId() {
        return 458;
    }

    @Override
    public boolean isNull() {
        return this.xmlStringValue == null || this.xmlStringValue.isNull();
    }

    @Override
    public void restoreToNull() {
        if (this.xmlStringValue != null) {
            this.xmlStringValue.restoreToNull();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        in.readShort();
        this.xmlStringValue.readExternal(in);
        this.setXType(0);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeShort(0);
        this.xmlStringValue.writeExternal(out);
    }

    @Override
    public InputStream returnStream() {
        return this.xmlStringValue == null ? null : this.xmlStringValue.returnStream();
    }

    @Override
    public void setStream(InputStream newStream) throws StandardException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        try {
            newStream.read();
            newStream.read();
        }
        catch (Exception e) {
            SanityManager.THROWASSERT((String)"Failed to read impl idbytes in setStream.");
        }
        this.xmlStringValue.setStream(newStream);
        this.setXType(0);
    }

    @Override
    public void loadStream() throws StandardException {
        this.getString();
    }

    @Override
    public XMLDataValue XMLParse(String text, boolean preserveWS, SqlXmlUtil sqlxUtil) throws StandardException {
        try {
            if (preserveWS) {
                text = sqlxUtil.serializeToString(text);
            } else {
                SanityManager.THROWASSERT((String)"Tried to STRIP whitespace but we shouldn't have made it this far");
            }
        }
        catch (Throwable t) {
            throw StandardException.newException("2200M", t, (Object)t.getMessage());
        }
        this.setXType(0);
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        this.xmlStringValue.setValue(text);
        return this;
    }

    @Override
    public StringDataValue XMLSerialize(StringDataValue result, int targetType, int targetWidth, int targetCollationType) throws StandardException {
        if (result == null) {
            switch (targetType) {
                case 1: {
                    result = new SQLChar();
                    break;
                }
                case 12: {
                    result = new SQLVarchar();
                    break;
                }
                case -1: {
                    result = new SQLLongvarchar();
                    break;
                }
                case 2005: {
                    result = new SQLClob();
                    break;
                }
                default: {
                    SanityManager.THROWASSERT((String)("Should NOT have made it to XMLSerialize with a non-string target type: " + targetType));
                    return null;
                }
            }
            if (result instanceof StringDataValue) {
                try {
                    RuleBasedCollator rbs = ConnectionUtil.getCurrentLCC().getDataValueFactory().getCharacterCollator(targetCollationType);
                    result = result.getValue(rbs);
                }
                catch (SQLException sqle) {
                    throw StandardException.plainWrapException(sqle);
                }
            }
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        if (this.hasTopLevelAttr()) {
            throw StandardException.newException("2200W");
        }
        result.setValue(this.getString());
        result.setWidth(targetWidth, 0, true);
        return result;
    }

    @Override
    public BooleanDataValue XMLExists(SqlXmlUtil sqlxUtil) throws StandardException {
        if (this.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        SanityManager.ASSERT((sqlxUtil != null ? 1 : 0) != 0, (String)"Tried to evaluate XML xquery, but no XML objects were loaded.");
        try {
            return new SQLBoolean(null != sqlxUtil.evalXQExpression(this, false, new int[1]));
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable xe) {
            throw StandardException.newException("10000", xe, (Object)"XMLEXISTS", (Object)xe.getMessage());
        }
    }

    @Override
    public XMLDataValue XMLQuery(XMLDataValue result, SqlXmlUtil sqlxUtil) throws StandardException {
        if (this.isNull()) {
            if (result == null) {
                result = (XMLDataValue)this.getNewNull();
            } else {
                result.setToNull();
            }
            return result;
        }
        try {
            int[] xType = new int[1];
            List<?> itemRefs = sqlxUtil.evalXQExpression(this, true, xType);
            if (result == null) {
                result = new XML();
            }
            String strResult = sqlxUtil.serializeToString(itemRefs, result);
            result.setValue(new SQLVarchar(strResult));
            result.setXType(xType[0]);
            return result;
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable xe) {
            throw StandardException.newException("10000", xe, (Object)"XMLQUERY", (Object)xe.getMessage());
        }
    }

    @Override
    public void setXType(int xtype) {
        this.xType = xtype;
        if (xtype == 0) {
            this.containsTopLevelAttr = false;
        }
    }

    @Override
    public int getXType() {
        return this.xType;
    }

    @Override
    public void markAsHavingTopLevelAttr() {
        this.containsTopLevelAttr = true;
    }

    @Override
    public boolean hasTopLevelAttr() {
        return this.containsTopLevelAttr;
    }

    public static void checkXMLRequirements() throws StandardException {
        if (xmlReqCheck == null) {
            xmlReqCheck = "";
            if (!ClassInspector.classIsLoadable("org.w3c.dom.Document")) {
                xmlReqCheck = "JAXP";
            } else if (!ClassInspector.classIsLoadable("javax.xml.xpath.XPath") && !ClassInspector.classIsLoadable("org.apache.xpath.XPath")) {
                xmlReqCheck = "Xalan";
            }
        }
        if (xmlReqCheck.length() != 0) {
            throw StandardException.newException("XML00", xmlReqCheck);
        }
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeShort(0);
            this.xmlStringValue.writeData(out, true);
        } else {
            this.writeNullDVD(out);
        }
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        in.readShort();
        this.xmlStringValue.readData(in, false);
        this.setXType(0);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        dis.readShort();
        this.xmlStringValue.fromDataForOptimizedResultHolder(dis);
        this.setXType(0);
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeShort(0);
        this.xmlStringValue.toDataForOptimizedResultHolder(dos);
    }

    @Override
    public final int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        int columnWidth = 2 + this.xmlStringValue.getLengthInBytes(null);
        return columnWidth;
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        outBytes[offset++] = 0;
        outBytes[offset++] = 0;
        int columnWidth = 2 + this.xmlStringValue.writeBytes(outBytes, offset, dtd);
        return columnWidth;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        int numBytes = 2 + this.xmlStringValue.readBytes(inBytes, offset + 2, columnWidth - 2);
        this.setXType(0);
        return numBytes;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLVarchar();
        }
        int numBytes = 2 + this.xmlStringValue.readBytes(memOffset + 2L, columnWidth - 2, bs);
        this.setXType(0);
        return numBytes;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        hash = ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)typeId);
        return this.xmlStringValue.computeHashCode(maxWidth, hash);
    }

    @Override
    public void setRegionContext(LocalRegion region) {
        if (this.xmlStringValue != null) {
            this.xmlStringValue.setRegionContext(region);
        }
    }

    static final String getAsString(byte[] inBytes, int offset, int columnWidth) {
        return SQLVarchar.getAsString(inBytes, offset + 2, columnWidth - 2);
    }

    static final String getAsString(long memOffset, int columnWidth, OffHeapByteSource bs) {
        return SQLVarchar.getAsString(memOffset + 2L, columnWidth - 2, bs);
    }

    @Override
    public byte getTypeId() {
        return 92;
    }
}

