/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.BaseTypeIdImpl;
import com.pivotal.gemfirexd.internal.catalog.types.DecimalTypeIdImpl;
import com.pivotal.gemfirexd.internal.catalog.types.TypeDescriptorImpl;
import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.CloneableObject;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLRef;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarbit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class TypeId {
    public static final int LONGINT_PRECISION = 19;
    public static final int LONGINT_SCALE = 0;
    public static final int LONGINT_MAXWIDTH = 8;
    public static final int INT_PRECISION = 10;
    public static final int INT_SCALE = 0;
    public static final int INT_MAXWIDTH = 4;
    public static final int SMALLINT_PRECISION = 5;
    public static final int SMALLINT_SCALE = 0;
    public static final int SMALLINT_MAXWIDTH = 2;
    public static final int TINYINT_PRECISION = 3;
    public static final int TINYINT_SCALE = 0;
    public static final int TINYINT_MAXWIDTH = 1;
    public static final int DOUBLE_PRECISION = 52;
    public static final int DOUBLE_PRECISION_IN_DIGITS = 15;
    public static final int DOUBLE_SCALE = 0;
    public static final int DOUBLE_MAXWIDTH = 8;
    public static final int REAL_PRECISION = 23;
    public static final int REAL_PRECISION_IN_DIGITS = 7;
    public static final int REAL_SCALE = 0;
    public static final int REAL_MAXWIDTH = 4;
    public static final int DECIMAL_PRECISION = 127;
    public static final int DECIMAL_SCALE = 127;
    public static final int DECIMAL_MAXWIDTH = 127;
    public static final int BOOLEAN_MAXWIDTH = 1;
    public static final int CHAR_MAXWIDTH = 254;
    public static final int VARCHAR_MAXWIDTH = 32672;
    public static final int LONGVARCHAR_MAXWIDTH = 32700;
    public static final int BIT_MAXWIDTH = 254;
    public static final int VARBIT_MAXWIDTH = 32672;
    public static final int LONGVARBIT_MAXWIDTH = 32700;
    public static final int BLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int CLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int XML_MAXWIDTH = Integer.MAX_VALUE;
    public static final int DATE_MAXWIDTH = 10;
    public static final int TIME_MAXWIDTH = 8;
    public static final int TIMESTAMP_MAXWIDTH = 26;
    public static final int TIME_SCALE = 0;
    public static final int TIMESTAMP_SCALE = 6;
    public static final String BIT_NAME = "CHAR () FOR BIT DATA";
    public static final String VARBIT_NAME = "VARCHAR () FOR BIT DATA";
    public static final String LONGVARBIT_NAME = "LONG VARCHAR FOR BIT DATA";
    public static final String TINYINT_NAME = "TINYINT";
    public static final String SMALLINT_NAME = "SMALLINT";
    public static final String INTEGER_NAME = "INTEGER";
    public static final String LONGINT_NAME = "BIGINT";
    public static final String FLOAT_NAME = "FLOAT";
    public static final String REAL_NAME = "REAL";
    public static final String DOUBLE_NAME = "DOUBLE";
    public static final String NUMERIC_NAME = "NUMERIC";
    public static final String DECIMAL_NAME = "DECIMAL";
    public static final String CHAR_NAME = "CHAR";
    public static final String VARCHAR_NAME = "VARCHAR";
    public static final String LONGVARCHAR_NAME = "LONG VARCHAR";
    public static final String DATE_NAME = "DATE";
    public static final String TIME_NAME = "TIME";
    public static final String TIMESTAMP_NAME = "TIMESTAMP";
    public static final String BINARY_NAME = "BINARY";
    public static final String VARBINARY_NAME = "VARBINARY";
    public static final String LONGVARBINARY_NAME = "LONGVARBINARY";
    public static final String BOOLEAN_NAME = "BOOLEAN";
    public static final String REF_NAME = "REF";
    public static final String NATIONAL_CHAR_NAME = "NATIONAL CHAR";
    public static final String NATIONAL_VARCHAR_NAME = "NATIONAL CHAR VARYING";
    public static final String NATIONAL_LONGVARCHAR_NAME = "LONG NVARCHAR";
    public static final String BLOB_NAME = "BLOB";
    public static final String CLOB_NAME = "CLOB";
    public static final String NCLOB_NAME = "NCLOB";
    public static final String JSON_NAME = "JSON";
    public static final String XML_NAME = "XML";
    public static final String ARRAY_NAME = "ARRAY";
    public static final String STRUCT_NAME = "STRUCT";
    public static final String DATALINK_NAME = "DATALINK";
    public static final String ROWID_NAME = "ROWID";
    public static final String SQLXML_NAME = "SQLXML";
    public static final int USER_PRECEDENCE = 1000;
    public static final int XML_PRECEDENCE = 180;
    public static final int BLOB_PRECEDENCE = 170;
    public static final int LONGVARBIT_PRECEDENCE = 160;
    public static final int VARBIT_PRECEDENCE = 150;
    public static final int BIT_PRECEDENCE = 140;
    public static final int BOOLEAN_PRECEDENCE = 130;
    public static final int TIME_PRECEDENCE = 120;
    public static final int TIMESTAMP_PRECEDENCE = 110;
    public static final int DATE_PRECEDENCE = 100;
    public static final int DOUBLE_PRECEDENCE = 90;
    public static final int REAL_PRECEDENCE = 80;
    public static final int DECIMAL_PRECEDENCE = 70;
    public static final int NUMERIC_PRECEDENCE = 69;
    public static final int LONGINT_PRECEDENCE = 60;
    public static final int INT_PRECEDENCE = 50;
    public static final int SMALLINT_PRECEDENCE = 40;
    public static final int TINYINT_PRECEDENCE = 30;
    public static final int REF_PRECEDENCE = 25;
    public static final int CLOB_PRECEDENCE = 14;
    public static final int LONGVARCHAR_PRECEDENCE = 12;
    public static final int VARCHAR_PRECEDENCE = 10;
    public static final int CHAR_PRECEDENCE = 0;
    public static final TypeId BOOLEAN_ID = TypeId.create(4, 16);
    public static final TypeId SMALLINT_ID = TypeId.create(10, 22);
    public static final TypeId INTEGER_ID = TypeId.create(7, 19);
    public static final TypeId CHAR_ID = TypeId.create(5, 17);
    private static final TypeId TINYINT_ID = TypeId.create(195, 196);
    private static final TypeId BIGINT_ID = TypeId.create(11, 23);
    private static final TypeId REAL_ID = TypeId.create(8, 20);
    private static final TypeId DOUBLE_ID = TypeId.create(6, 18);
    private static final TypeId DECIMAL_ID = new TypeId(197, new DecimalTypeIdImpl(false));
    private static final TypeId NUMERIC_ID = new TypeId(197, new DecimalTypeIdImpl(true));
    public static final TypeId VARCHAR_ID = TypeId.create(13, 25);
    private static final TypeId DATE_ID = TypeId.create(40, 32);
    private static final TypeId TIME_ID = TypeId.create(35, 33);
    private static final TypeId TIMESTAMP_ID = TypeId.create(36, 34);
    private static final TypeId BIT_ID = TypeId.create(27, 28);
    private static final TypeId VARBIT_ID = TypeId.create(29, 30);
    private static final TypeId REF_ID = TypeId.create(9, 21);
    private static final TypeId LONGVARCHAR_ID = TypeId.create(230, 231);
    private static final TypeId LONGVARBIT_ID = TypeId.create(232, 233);
    private static final TypeId BLOB_ID = TypeId.create(440, 442);
    private static final TypeId CLOB_ID = TypeId.create(444, 446);
    public static final TypeId JSON_ID = TypeId.create(475, 477);
    private static final TypeId XML_ID = TypeId.create(456, 457);
    private static final TypeId[] ALL_BUILTIN_TYPE_IDS = new TypeId[]{BOOLEAN_ID, SMALLINT_ID, INTEGER_ID, CHAR_ID, TINYINT_ID, BIGINT_ID, REAL_ID, DOUBLE_ID, DECIMAL_ID, NUMERIC_ID, VARCHAR_ID, DATE_ID, TIME_ID, TIMESTAMP_ID, BIT_ID, VARBIT_ID, REF_ID, LONGVARCHAR_ID, LONGVARBIT_ID, BLOB_ID, CLOB_ID, JSON_ID, XML_ID};
    static DataValueDescriptor decimalImplementation;
    private BaseTypeIdImpl baseTypeId;
    private int formatId;
    private boolean classNameWasDelimitedIdentifier;
    private boolean isBitTypeId;
    private boolean isLOBTypeId;
    private boolean isBooleanTypeId;
    private boolean isConcatableTypeId;
    private boolean isDecimalTypeId;
    private boolean isLongConcatableTypeId;
    private boolean isNumericTypeId;
    private boolean isRefTypeId;
    private boolean isJSONTypeId;
    private boolean isStringTypeId;
    private boolean isFloatingPointTypeId;
    private boolean isRealTypeId;
    private boolean isDateTimeTimeStampTypeId;
    private boolean isUserDefinedTypeId;
    private int maxPrecision;
    private int maxScale;
    private int typePrecedence;
    private String javaTypeName;
    private int maxMaxWidth;
    private boolean canCompareBytesToBytes;
    private DataValueDescriptor zeroForFixedType;

    private static TypeId create(int typeFormatId, int implTypeFormatId) {
        return new TypeId(typeFormatId, new BaseTypeIdImpl(implTypeFormatId));
    }

    public static TypeId[] getAllBuiltinTypeIds() {
        int count = ALL_BUILTIN_TYPE_IDS.length;
        TypeId[] retval = new TypeId[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = ALL_BUILTIN_TYPE_IDS[i];
        }
        return retval;
    }

    public static TypeId getBuiltInTypeId(int JDBCTypeId) {
        switch (JDBCTypeId) {
            case -6: {
                return TINYINT_ID;
            }
            case 5: {
                return SMALLINT_ID;
            }
            case 4: {
                return INTEGER_ID;
            }
            case -5: {
                return BIGINT_ID;
            }
            case 7: {
                return REAL_ID;
            }
            case 6: 
            case 8: {
                return DOUBLE_ID;
            }
            case 3: {
                return DECIMAL_ID;
            }
            case 2: {
                return NUMERIC_ID;
            }
            case 1: {
                return CHAR_ID;
            }
            case 12: {
                return VARCHAR_ID;
            }
            case 91: {
                return DATE_ID;
            }
            case 92: {
                return TIME_ID;
            }
            case 93: {
                return TIMESTAMP_ID;
            }
            case -7: 
            case 16: {
                return BOOLEAN_ID;
            }
            case -2: {
                return BIT_ID;
            }
            case -3: {
                return VARBIT_ID;
            }
            case -4: {
                return LONGVARBIT_ID;
            }
            case -1: {
                return LONGVARCHAR_ID;
            }
            case 2004: {
                return BLOB_ID;
            }
            case 2005: {
                return CLOB_ID;
            }
            case 2009: {
                return XML_ID;
            }
            case 4002: {
                return JSON_ID;
            }
        }
        return null;
    }

    public static TypeId getUserDefinedTypeId(String className, boolean delimitedIdentifier) throws StandardException {
        return new TypeId(267, new UserDefinedTypeIdImpl(className), delimitedIdentifier);
    }

    public static TypeId getUserDefinedTypeId(String schemaName, String unqualifiedName, String className) throws StandardException {
        return new TypeId(267, new UserDefinedTypeIdImpl(schemaName, unqualifiedName, className));
    }

    public static TypeId getUserDefinedTypeId(String className, Object classParam, boolean delimitedIdentifier) throws StandardException {
        return new TypeId(267, new UserDefinedTypeIdImpl(className, classParam), delimitedIdentifier);
    }

    public final boolean canCompareBytesToBytes() {
        return this.canCompareBytesToBytes;
    }

    public final DataValueDescriptor getStaticZeroForFixedType() {
        return this.zeroForFixedType;
    }

    public static TypeId getSQLTypeForJavaType(String javaTypeName) throws StandardException {
        return TypeId.getSQLTypeForJavaType(javaTypeName, null);
    }

    public static TypeId getSQLTypeForJavaType(String javaTypeName, Object typeParam) throws StandardException {
        if (javaTypeName.equals("java.lang.Boolean") || javaTypeName.equals("boolean")) {
            return BOOLEAN_ID;
        }
        if (javaTypeName.equals("byte[]")) {
            return VARBIT_ID;
        }
        if (javaTypeName.equals("java.lang.String")) {
            return VARCHAR_ID;
        }
        if (javaTypeName.equals("java.lang.Integer") || javaTypeName.equals("int")) {
            return INTEGER_ID;
        }
        if (javaTypeName.equals("byte")) {
            return TINYINT_ID;
        }
        if (javaTypeName.equals("short")) {
            return SMALLINT_ID;
        }
        if (javaTypeName.equals("java.lang.Long") || javaTypeName.equals("long")) {
            return BIGINT_ID;
        }
        if (javaTypeName.equals("java.lang.Float") || javaTypeName.equals("float")) {
            return REAL_ID;
        }
        if (javaTypeName.equals("java.lang.Double") || javaTypeName.equals("double")) {
            return DOUBLE_ID;
        }
        if (javaTypeName.equals("java.math.BigDecimal")) {
            return DECIMAL_ID;
        }
        if (javaTypeName.equals("java.sql.Date")) {
            return DATE_ID;
        }
        if (javaTypeName.equals("java.sql.Time")) {
            return TIME_ID;
        }
        if (javaTypeName.equals("java.sql.Timestamp")) {
            return TIMESTAMP_ID;
        }
        if (javaTypeName.equals("java.sql.Blob")) {
            return BLOB_ID;
        }
        if (javaTypeName.equals("java.sql.Clob")) {
            return CLOB_ID;
        }
        if (javaTypeName.equals("com.pivotal.gemfirexd.internal.iapi.types.XML")) {
            return XML_ID;
        }
        if (javaTypeName.equals("char")) {
            return null;
        }
        if (typeParam != null) {
            return TypeId.getUserDefinedTypeId(javaTypeName, typeParam, false);
        }
        return TypeId.getUserDefinedTypeId(javaTypeName, false);
    }

    public static TypeId getBuiltInTypeId(String SQLTypeName) {
        if (SQLTypeName.equals(BOOLEAN_NAME)) {
            return BOOLEAN_ID;
        }
        if (SQLTypeName.equals(CHAR_NAME)) {
            return CHAR_ID;
        }
        if (SQLTypeName.equals(DATE_NAME)) {
            return DATE_ID;
        }
        if (SQLTypeName.equals(DOUBLE_NAME)) {
            return DOUBLE_ID;
        }
        if (SQLTypeName.equals(FLOAT_NAME)) {
            return DOUBLE_ID;
        }
        if (SQLTypeName.equals(INTEGER_NAME)) {
            return INTEGER_ID;
        }
        if (SQLTypeName.equals(LONGINT_NAME)) {
            return BIGINT_ID;
        }
        if (SQLTypeName.equals(REAL_NAME)) {
            return REAL_ID;
        }
        if (SQLTypeName.equals(SMALLINT_NAME)) {
            return SMALLINT_ID;
        }
        if (SQLTypeName.equals(TIME_NAME)) {
            return TIME_ID;
        }
        if (SQLTypeName.equals(TIMESTAMP_NAME)) {
            return TIMESTAMP_ID;
        }
        if (SQLTypeName.equals(VARCHAR_NAME)) {
            return VARCHAR_ID;
        }
        if (SQLTypeName.equals(BIT_NAME)) {
            return BIT_ID;
        }
        if (SQLTypeName.equals(VARBIT_NAME)) {
            return VARBIT_ID;
        }
        if (SQLTypeName.equals(TINYINT_NAME)) {
            return TINYINT_ID;
        }
        if (SQLTypeName.equals(DECIMAL_NAME)) {
            return DECIMAL_ID;
        }
        if (SQLTypeName.equals(NUMERIC_NAME)) {
            return NUMERIC_ID;
        }
        if (SQLTypeName.equals(LONGVARCHAR_NAME)) {
            return LONGVARCHAR_ID;
        }
        if (SQLTypeName.equals(LONGVARBIT_NAME)) {
            return LONGVARBIT_ID;
        }
        if (SQLTypeName.equals(BLOB_NAME)) {
            return BLOB_ID;
        }
        if (SQLTypeName.equals(CLOB_NAME)) {
            return CLOB_ID;
        }
        if (SQLTypeName.equals(JSON_NAME)) {
            return JSON_ID;
        }
        if (SQLTypeName.equals(XML_NAME)) {
            return XML_ID;
        }
        if (SQLTypeName.equals(REF_NAME)) {
            return REF_ID;
        }
        return null;
    }

    public static TypeId getTypeId(TypeDescriptor catalogType) {
        TypeDescriptorImpl tdi = (TypeDescriptorImpl)catalogType;
        int jdbcType = catalogType.getJDBCTypeId();
        TypeId typeId = TypeId.getBuiltInTypeId(jdbcType);
        if (typeId != null) {
            return typeId;
        }
        if (jdbcType == 2000) {
            return new TypeId(267, tdi.getTypeId());
        }
        if (tdi.isRowMultiSet()) {
            return new TypeId(469, tdi.getTypeId());
        }
        return null;
    }

    public TypeId(int formatId, BaseTypeIdImpl baseTypeId) {
        this.formatId = formatId;
        this.baseTypeId = baseTypeId;
        this.setTypeIdSpecificInstanceVariables();
    }

    public TypeId(int formatId, BaseTypeIdImpl baseTypeId, boolean classNameWasDelimitedIdentifier) {
        this.formatId = formatId;
        this.baseTypeId = baseTypeId;
        this.classNameWasDelimitedIdentifier = classNameWasDelimitedIdentifier;
        this.setTypeIdSpecificInstanceVariables();
    }

    public boolean equals(Object that) {
        if (that instanceof TypeId) {
            return this.getSQLTypeName().equals(((TypeId)that).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.formatId) {
            case 27: {
                this.typePrecedence = 140;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 254;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 4: {
                this.typePrecedence = 130;
                this.javaTypeName = "java.lang.Boolean";
                this.maxMaxWidth = 1;
                this.isBooleanTypeId = true;
                this.zeroForFixedType = new SQLBoolean(false);
                break;
            }
            case 5: {
                this.typePrecedence = 0;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 254;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.canCompareBytesToBytes = true;
                break;
            }
            case 40: {
                this.typePrecedence = 100;
                this.javaTypeName = "java.sql.Date";
                this.maxMaxWidth = 10;
                this.maxPrecision = 10;
                this.isDateTimeTimeStampTypeId = true;
                try {
                    this.zeroForFixedType = new SQLDate(new Date(0L));
                    break;
                }
                catch (StandardException se) {
                    throw new GemFireXDRuntimeException(se);
                }
            }
            case 197: {
                this.maxPrecision = 127;
                this.maxScale = 127;
                this.typePrecedence = 70;
                this.javaTypeName = "java.math.BigDecimal";
                this.maxMaxWidth = 127;
                this.isDecimalTypeId = true;
                this.isNumericTypeId = true;
                break;
            }
            case 6: {
                this.maxPrecision = 52;
                this.maxScale = 0;
                this.typePrecedence = 90;
                this.javaTypeName = "java.lang.Double";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                this.isFloatingPointTypeId = true;
                try {
                    this.zeroForFixedType = new SQLDouble(0.0);
                    break;
                }
                catch (StandardException se) {
                    throw new GemFireXDRuntimeException(se);
                }
            }
            case 7: {
                this.maxPrecision = 10;
                this.maxScale = 0;
                this.typePrecedence = 50;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                this.zeroForFixedType = new SQLInteger();
                break;
            }
            case 11: {
                this.maxPrecision = 19;
                this.maxScale = 0;
                this.typePrecedence = 60;
                this.javaTypeName = "java.lang.Long";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                this.zeroForFixedType = new SQLLongint(0L);
                break;
            }
            case 232: {
                this.typePrecedence = 160;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32700;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 230: {
                this.typePrecedence = 12;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32700;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.canCompareBytesToBytes = true;
                break;
            }
            case 8: {
                this.maxPrecision = 23;
                this.maxScale = 0;
                this.typePrecedence = 80;
                this.javaTypeName = "java.lang.Float";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                this.isRealTypeId = true;
                this.isFloatingPointTypeId = true;
                try {
                    this.zeroForFixedType = new SQLReal(0.0f);
                    break;
                }
                catch (StandardException se) {
                    throw new GemFireXDRuntimeException(se);
                }
            }
            case 9: {
                this.typePrecedence = 25;
                this.javaTypeName = "java.sql.Ref";
                this.isRefTypeId = true;
                break;
            }
            case 10: {
                this.maxPrecision = 5;
                this.maxScale = 0;
                this.typePrecedence = 40;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 2;
                this.isNumericTypeId = true;
                this.zeroForFixedType = new SQLSmallint(0);
                break;
            }
            case 35: {
                this.typePrecedence = 120;
                this.javaTypeName = "java.sql.Time";
                this.maxScale = 0;
                this.maxMaxWidth = 8;
                this.maxPrecision = 8;
                this.isDateTimeTimeStampTypeId = true;
                try {
                    this.zeroForFixedType = new SQLTime(new Time(0L));
                    break;
                }
                catch (StandardException se) {
                    throw new GemFireXDRuntimeException(se);
                }
            }
            case 36: {
                this.typePrecedence = 110;
                this.javaTypeName = "java.sql.Timestamp";
                this.maxScale = 6;
                this.maxMaxWidth = 26;
                this.maxPrecision = 26;
                this.isDateTimeTimeStampTypeId = true;
                try {
                    this.zeroForFixedType = new SQLTimestamp(new Timestamp(0L));
                    break;
                }
                catch (StandardException se) {
                    throw new GemFireXDRuntimeException(se);
                }
            }
            case 195: {
                this.maxPrecision = 3;
                this.maxScale = 0;
                this.typePrecedence = 30;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 1;
                this.isNumericTypeId = true;
                this.zeroForFixedType = new SQLTinyint(0);
                break;
            }
            case 267: {
                if (this.baseTypeId != null) {
                    this.setUserTypeIdInfo();
                } else {
                    this.typePrecedence = 1000;
                }
                this.maxMaxWidth = -1;
                this.isUserDefinedTypeId = true;
                break;
            }
            case 29: {
                this.typePrecedence = 150;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32672;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 440: {
                this.typePrecedence = 170;
                this.javaTypeName = "java.sql.Blob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 13: {
                this.typePrecedence = 10;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32672;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.canCompareBytesToBytes = true;
                break;
            }
            case 444: {
                this.typePrecedence = 14;
                this.javaTypeName = "java.sql.Clob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                this.canCompareBytesToBytes = true;
                break;
            }
            case 475: {
                this.typePrecedence = 14;
                this.javaTypeName = "com.pivotal.gemfirexd.internal.iapi.types.JSON";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                this.canCompareBytesToBytes = true;
                this.isJSONTypeId = true;
                break;
            }
            case 456: {
                this.typePrecedence = 180;
                this.javaTypeName = "com.pivotal.gemfirexd.internal.iapi.types.XML";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isLongConcatableTypeId = true;
            }
        }
    }

    public final int getJDBCTypeId() {
        return this.baseTypeId.getJDBCTypeId();
    }

    public String getSQLTypeName() {
        return this.baseTypeId.getSQLTypeName();
    }

    public final boolean userType() {
        return this.baseTypeId.userType();
    }

    public int getMaximumPrecision() {
        return this.maxPrecision;
    }

    public int getMaximumScale() {
        return this.maxScale;
    }

    private void setUserTypeIdInfo() {
        UserDefinedTypeIdImpl baseUserTypeId = (UserDefinedTypeIdImpl)this.baseTypeId;
        this.typePrecedence = 1000;
        this.javaTypeName = baseUserTypeId.getClassName();
        if (baseUserTypeId.getSQLTypeName().endsWith(DVDSet.class.getSimpleName())) {
            DVDSet dvdset = (DVDSet)this.getNull();
            this.typePrecedence = dvdset.resultTypePrecedence();
            this.isNumericTypeId = true;
        }
    }

    public boolean getClassNameWasDelimitedIdentifier() {
        return this.classNameWasDelimitedIdentifier;
    }

    public boolean isStringTypeId() {
        return this.isStringTypeId;
    }

    public boolean isDateTimeTimeStampTypeId() {
        return this.isDateTimeTimeStampTypeId;
    }

    public boolean isRealTypeId() {
        return this.isRealTypeId;
    }

    public boolean isFloatingPointTypeId() {
        return this.isFloatingPointTypeId;
    }

    public boolean isDoubleTypeId() {
        return this.isFloatingPointTypeId && !this.isRealTypeId;
    }

    public boolean isFixedStringTypeId() {
        return this.formatId == 5;
    }

    public boolean isClobTypeId() {
        return this.formatId == 444;
    }

    public boolean isBlobTypeId() {
        return this.formatId == 440;
    }

    public boolean isLongVarcharTypeId() {
        return this.formatId == 230;
    }

    public boolean isLongVarbinaryTypeId() {
        return this.formatId == 232;
    }

    public boolean isDateTimeTimeStampTypeID() {
        return this.formatId == 40 || this.formatId == 35 || this.formatId == 36;
    }

    public boolean isXMLTypeId() {
        return this.formatId == 456;
    }

    public boolean orderable(ClassFactory cf) {
        switch (this.formatId) {
            case 232: 
            case 440: 
            case 456: 
            case 475: {
                return false;
            }
            case 267: {
                return false;
            }
        }
        boolean orderable = true;
        return orderable;
    }

    public int typePrecedence() {
        return this.typePrecedence;
    }

    public String getCorrespondingJavaTypeName() {
        SanityManager.ASSERT((this.javaTypeName != null ? 1 : 0) != 0, (String)"javaTypeName expected to be non-null");
        return this.javaTypeName;
    }

    public String getResultSetMetaDataTypeName() {
        if (BLOB_ID != null && BLOB_ID.equals(this)) {
            return "java.sql.Blob";
        }
        if (CLOB_ID != null && CLOB_ID.equals(this)) {
            return "java.sql.Clob";
        }
        return this.getCorrespondingJavaTypeName();
    }

    public int getMaximumMaximumWidth() {
        return this.maxMaxWidth;
    }

    public String toParsableString(DataTypeDescriptor dts) {
        return this.baseTypeId.toParsableString(dts.getCatalogType());
    }

    public boolean isNumericTypeId() {
        return this.isNumericTypeId;
    }

    public boolean isDecimalTypeId() {
        return this.isDecimalTypeId;
    }

    public boolean isBooleanTypeId() {
        return this.isBooleanTypeId;
    }

    public boolean isRefTypeId() {
        return this.isRefTypeId;
    }

    public boolean isJSONTypeId() {
        return this.isJSONTypeId;
    }

    public boolean isConcatableTypeId() {
        return this.isConcatableTypeId;
    }

    public boolean isBitTypeId() {
        return this.isBitTypeId;
    }

    public boolean isLOBTypeId() {
        return this.isLOBTypeId;
    }

    public boolean isLongConcatableTypeId() {
        return this.isLongConcatableTypeId;
    }

    public boolean isUserDefinedTypeId() {
        return this.isUserDefinedTypeId;
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    public DataValueDescriptor getNull() {
        switch (this.formatId) {
            case 27: {
                return new SQLBit();
            }
            case 4: {
                return new SQLBoolean();
            }
            case 5: {
                return new SQLChar();
            }
            case 197: {
                return decimalImplementation.getNewNull();
            }
            case 6: {
                return new SQLDouble();
            }
            case 7: {
                return new SQLInteger();
            }
            case 11: {
                return new SQLLongint();
            }
            case 232: {
                return new SQLLongVarbit();
            }
            case 440: {
                return new SQLBlob();
            }
            case 444: {
                return new SQLClob();
            }
            case 475: {
                return new JSON();
            }
            case 230: {
                return new SQLLongvarchar();
            }
            case 8: {
                return new SQLReal();
            }
            case 9: {
                return new SQLRef();
            }
            case 10: {
                return new SQLSmallint();
            }
            case 195: {
                return new SQLTinyint();
            }
            case 40: {
                return new SQLDate();
            }
            case 35: {
                return new SQLTime();
            }
            case 36: {
                return new SQLTimestamp();
            }
            case 267: {
                if (this.baseTypeId != null && this.baseTypeId.getSQLTypeName().endsWith(DVDSet.class.getSimpleName())) {
                    return new DVDSet(((UserDefinedTypeIdImpl)this.baseTypeId).getClassParam());
                }
                return new UserType();
            }
            case 29: {
                return new SQLVarbit();
            }
            case 13: {
                return new SQLVarchar();
            }
            case 456: {
                return new XML();
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getNull() - " + this.formatId));
        return null;
    }

    public boolean streamStorable() {
        return this.isStringTypeId() || this.isBitTypeId();
    }

    public int getApproximateLengthInBytes(DataTypeDescriptor dts) {
        switch (this.formatId) {
            case 27: {
                return (int)Math.ceil((double)dts.getMaximumWidth() / 8.0);
            }
            case 5: {
                return 2 * dts.getMaximumWidth() + 2;
            }
            case 197: {
                if (dts.getPrecision() == Integer.MAX_VALUE) {
                    return 200;
                }
                return 8 + (int)Math.ceil((double)dts.getPrecision() / 2.0);
            }
            case 232: 
            case 440: 
            case 444: 
            case 456: 
            case 475: {
                return 10240;
            }
            case 9: {
                return 16;
            }
            case 267: {
                return 200;
            }
            case 29: {
                if (dts.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return (int)Math.ceil((double)dts.getMaximumWidth() / 8.0);
            }
            case 13: 
            case 230: {
                if (dts.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return dts.getMaximumWidth() * 2 + 2;
            }
            case 40: {
                return 18;
            }
            case 35: {
                return 16;
            }
            case 36: {
                return 29;
            }
        }
        return dts.getMaximumWidth();
    }

    public BaseTypeIdImpl getBaseTypeId() {
        return this.baseTypeId;
    }

    public int getPrecision(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.formatId != 197) {
            SanityManager.THROWASSERT((String)("getPrecision() not expected to be called for formatId - " + this.formatId));
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        long val = (long)this.getScale(leftType, rightType) + Math.max(lprec - lscale, rprec - rscale);
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        return (int)val;
    }

    public int getScale(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.formatId != 197) {
            SanityManager.THROWASSERT((String)("getPrecision() not expected to be called for formatId - " + this.formatId));
        }
        return Math.max(leftType.getScale(), rightType.getScale());
    }

    public boolean variableLength() {
        switch (this.formatId) {
            case 5: 
            case 13: 
            case 27: 
            case 29: 
            case 197: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }

    public final void assertTypeEquivalent(DataValueDescriptor dvd, int colIdx) {
        Class c = null;
        switch (this.formatId) {
            case 27: {
                c = SQLBit.class;
                break;
            }
            case 4: {
                c = SQLBoolean.class;
                break;
            }
            case 5: {
                c = SQLChar.class;
                break;
            }
            case 197: {
                c = decimalImplementation.getClass();
                break;
            }
            case 6: {
                c = SQLDouble.class;
                break;
            }
            case 7: {
                c = SQLInteger.class;
                break;
            }
            case 11: {
                c = SQLLongint.class;
                break;
            }
            case 232: {
                c = SQLLongVarbit.class;
                break;
            }
            case 440: {
                c = SQLBlob.class;
                break;
            }
            case 444: {
                c = SQLClob.class;
                break;
            }
            case 475: {
                c = JSON.class;
                break;
            }
            case 230: {
                c = SQLLongvarchar.class;
                break;
            }
            case 8: {
                c = SQLReal.class;
                break;
            }
            case 9: {
                c = SQLRef.class;
                break;
            }
            case 10: {
                c = SQLSmallint.class;
                break;
            }
            case 195: {
                c = SQLTinyint.class;
                break;
            }
            case 40: {
                c = SQLDate.class;
                break;
            }
            case 35: {
                c = SQLTime.class;
                break;
            }
            case 36: {
                c = SQLTimestamp.class;
                break;
            }
            case 267: {
                if (this.baseTypeId != null && this.baseTypeId.getSQLTypeName().endsWith(DVDSet.class.getSimpleName())) {
                    c = DVDSet.class;
                    break;
                }
                c = UserType.class;
                break;
            }
            case 29: {
                c = SQLVarbit.class;
                break;
            }
            case 13: {
                c = SQLVarchar.class;
                break;
            }
            case 456: {
                c = XML.class;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("unexpected formatId in assertTypeEquivalent() - " + this.formatId));
                c = null;
            }
        }
        if (!CloneableObject.class.isAssignableFrom(c)) {
            SanityManager.THROWASSERT((String)("col[" + colIdx + "] (" + (c != null ? c.getName() : c) + ") is not a CloneableObject."));
        }
        if (!c.isInstance(dvd)) {
            SanityManager.THROWASSERT((String)("col1.getClass() (" + c + ") expected to be the same as col2.getClass() (" + dvd.getClass() + ")"));
        }
    }
}

