/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelper;
import com.pivotal.gemfirexd.internal.engine.types.SqlXmlHelperFactory;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.types.XMLDataValue;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SqlXmlUtil
implements Formatable {
    private DocumentBuilder dBuilder;
    private final SqlXmlHelper xmlHelper;
    private String queryExpr;
    private String opName;
    private boolean recompileQuery;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory dBF = null;
            try {
                dBF = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable e) {
                throw StandardException.newException("XML00", "JAXP");
            }
            dBF.setValidating(false);
            dBF.setNamespaceAware(true);
            this.dBuilder = dBF.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler());
            this.xmlHelper = SqlXmlHelperFactory.newInstance();
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.newException("XML01", t, (Object)t.getMessage());
        }
    }

    public void compileXQExpr(String queryExpr, String opName) throws StandardException {
        this.xmlHelper.compileXQExpr(queryExpr, opName, this.dBuilder);
        this.queryExpr = queryExpr;
        this.opName = opName;
        this.recompileQuery = false;
    }

    public String serializeToString(String xmlAsText) throws Exception {
        ArrayList<Object> aList = new ArrayList<Object>();
        try {
            final InputSource is = new InputSource(new StringReader(xmlAsText));
            aList.add(AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, SAXException {
                    return SqlXmlUtil.this.dBuilder.parse(is);
                }
            }));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return this.serializeToString(aList, null);
    }

    public String serializeToString(List<?> items, XMLDataValue xmlVal) throws IOException {
        return this.xmlHelper.serializeToString(items, xmlVal);
    }

    public List<?> evalXQExpression(XMLDataValue xmlContext, boolean returnResults, int[] resultXType) throws Exception {
        return this.xmlHelper.evalXQExpression(xmlContext, returnResults, resultXType, this.dBuilder, this.recompileQuery, this.queryExpr, this.opName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.xmlHelper.nullQuery()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.queryExpr);
            out.writeObject(this.opName);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.queryExpr = (String)in.readObject();
            this.opName = (String)in.readObject();
            this.recompileQuery = true;
        }
    }

    @Override
    public int getTypeFormatId() {
        return 464;
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

