/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.SQLException;

public class SQLVarbit
extends SQLBit {
    @Override
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 32672;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    @Override
    public int getTypeFormatId() {
        return 88;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        byte[] sourceData = source.getBytes();
        this.setValue(sourceData);
        if (sourceData.length > desiredWidth) {
            this.setWidth(desiredWidth, 0, true);
        }
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int sourceWidth = this.dataValue.length;
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                for (int i = desiredWidth; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(desiredWidth));
                }
            }
            byte[] shrunkData = new byte[desiredWidth];
            System.arraycopy(this.dataValue, 0, shrunkData, 0, desiredWidth);
            this.dataValue = shrunkData;
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] val) {
        super(val);
    }

    @Override
    public int typePrecedence() {
        return 150;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        byte[] value;
        assert (!this.isNull());
        try {
            value = this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        return ResolverUtils.addBytesToBucketHash((byte[])value, (int)hash, (int)this.getTypeFormatId());
    }
}

