/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SQLDouble
extends NumberDataType {
    static final int DOUBLE_LENGTH = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDouble.class);
    private double value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if (this.value > 2.147483648E9 || this.value < -2.147483649E9) {
            throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 128.0 || this.value < -129.0) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > 32768.0 || this.value < -32769.0) {
            throw StandardException.newException("22003", (Object)"SMALLINT", (Object)null);
        }
        return (short)this.value;
    }

    @Override
    public long getLong() throws StandardException {
        if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        return (long)this.value;
    }

    @Override
    public float getFloat() throws StandardException {
        if (Float.isInfinite((float)this.value)) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        return (float)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0.0;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Double)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getDouble());
    }

    @Override
    public int getLength() {
        return 32;
    }

    @Override
    public String getTypeName() {
        return "DOUBLE";
    }

    @Override
    public int getTypeFormatId() {
        return 79;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeDouble(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readDouble();
        this.isnull = false;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readDouble();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0.0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        double otherValue;
        double thisValue = this.getDouble();
        if (thisValue == (otherValue = arg.getDouble())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new SQLDouble(this.value, this.isnull);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)("error on clone,  value = " + this.value + " isnull = " + this.isnull), (Throwable)se);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDouble();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        double dv = resultSet.getDouble(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
        this.value = this.isnull ? 0.0 : NumberDataType.normalizeDOUBLE(dv);
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 8);
            return;
        }
        ps.setDouble(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateDouble(position, this.value);
    }

    public SQLDouble() {
        this.isnull = true;
    }

    public SQLDouble(double val) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(val);
    }

    public SQLDouble(Double obj) throws StandardException {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeDOUBLE(obj);
        }
    }

    private SQLDouble(double val, boolean startsnull) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(val);
        this.isnull = startsnull;
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0.0;
            this.isnull = true;
        } else {
            double doubleValue = 0.0;
            try {
                doubleValue = Double.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.value = NumberDataType.normalizeDOUBLE(doubleValue);
            this.isnull = false;
        }
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(theValue);
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.value = NumberDataType.normalizeDOUBLE(theValue);
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Double)) {
            SanityManager.THROWASSERT((String)("SQLDouble.setValue(Number) passed a " + theValue.getClass()));
        }
        this.setValue(theValue.doubleValue());
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        this.setValue(bigDecimal.doubleValue());
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? 1.0 : 0.0;
        this.isnull = false;
    }

    @Override
    public int typePrecedence() {
        return 90;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() == right.getDouble());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() != right.getDouble());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() < right.getDouble());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() > right.getDouble());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() <= right.getDouble());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getDouble() >= right.getDouble());
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        double tmpresult = addend1.getDouble() + addend2.getDouble();
        result.setValue(tmpresult);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double tmpresult = left.getDouble() - right.getDouble();
        result.setValue(tmpresult);
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        double rightValue;
        if (result == null) {
            result = new SQLDouble();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double leftValue = left.getDouble();
        double tempResult = leftValue * (rightValue = right.getDouble());
        if (tempResult == 0.0 && leftValue != 0.0 && rightValue != 0.0) {
            throw StandardException.newException("22003", (Object)"DOUBLE", (Object)null);
        }
        result.setValue(tempResult);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        double divisorValue = divisor.getDouble();
        if (divisorValue == 0.0) {
            throw StandardException.newException("22012");
        }
        double dividendValue = dividend.getDouble();
        double divideResult = dividendValue / divisorValue;
        if (Double.isNaN(divideResult)) {
            throw StandardException.newException("22012");
        }
        if (divideResult == 0.0 && dividendValue != 0.0) {
            throw StandardException.newException("22003", (Object)"DOUBLE", (Object)null);
        }
        result.setValue(divideResult);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDouble();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        double minusResult = -this.getDouble();
        result.setValue(minusResult);
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Double.toString(this.value);
    }

    public int hashCode() {
        long longVal = (long)this.value;
        double doubleLongVal = longVal;
        if (doubleLongVal != this.value) {
            longVal = Double.doubleToLongBits(this.value);
        }
        return (int)(longVal ^ longVal >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeDouble(this.value);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.value = dis.readDouble();
        this.isnull = false;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeDouble(this.value);
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        if (!this.isNull()) {
            return 8;
        }
        return 0;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        long bits = Double.doubleToLongBits(this.value);
        int numBytes = RowFormatter.writeLong(outBytes, bits, offset);
        return numBytes;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        long bits = RowFormatter.readLong(inBytes, offset);
        this.isnull = false;
        this.value = Double.longBitsToDouble(bits);
        assert (columnWidth == 8);
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        long bits = RowFormatter.readLong(memOffset);
        this.isnull = false;
        this.value = Double.longBitsToDouble(bits);
        assert (columnWidth == 8);
        return columnWidth;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        long bits = Double.doubleToLongBits(this.value);
        return ResolverUtils.addLongToBucketHash((long)bits, (int)hash, (int)this.getTypeFormatId());
    }

    static final double getAsDouble(byte[] inBytes, int offset) {
        long bits = RowFormatter.readLong(inBytes, offset);
        return Double.longBitsToDouble(bits);
    }

    static final double getAsDouble(long memOffset) {
        long bits = RowFormatter.readLong(memOffset);
        return Double.longBitsToDouble(bits);
    }

    @Override
    public byte getTypeId() {
        return 60;
    }
}

