/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.spark.unsafe.Platform;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    static final BigDecimal ONE = BigDecimal.valueOf(1L);
    static final BigDecimal MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(ONE);
    static final BigDecimal MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(ONE);
    private BigDecimal value;
    private byte[] rawData;
    private byte rawSig;
    private byte rawScale;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDecimal.class);
    private static final int BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(BigDecimal.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (null != this.rawData) {
            sz += this.rawData.length;
        }
        return sz;
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal val) {
        this.value = val;
    }

    public SQLDecimal(BigDecimal val, int nprecision, int scale) throws StandardException {
        this.value = val;
        if (this.value != null && scale >= 0) {
            this.value = this.value.setScale(scale, 1);
        }
    }

    public SQLDecimal(String val) {
        this.value = new BigDecimal(val);
    }

    public SQLDecimal(char[] val) {
        this.value = new BigDecimal(val);
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -128L && lv <= 127L) {
                return (byte)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -32768L && lv <= 32767L) {
                return (short)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"SMALLINT", (Object)null);
    }

    @Override
    public long getLong() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        return SQLDecimal.getLong(localValue);
    }

    static long getLong(BigDecimal localValue) throws StandardException {
        if (localValue == null) {
            return 0L;
        }
        if (localValue.compareTo(MINLONG_MINUS_ONE) == 1 && localValue.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return localValue.longValue();
        }
        throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
    }

    @Override
    public float getFloat() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return 0.0f;
        }
        float value = NumberDataType.normalizeREAL(localValue.floatValue());
        return value;
    }

    @Override
    public double getDouble() throws StandardException {
        BigDecimal localValue = this.getBigDecimal();
        return SQLDecimal.getDouble(localValue);
    }

    static double getDouble(BigDecimal localValue) throws StandardException {
        if (localValue == null) {
            return 0.0;
        }
        double value = NumberDataType.normalizeDOUBLE(localValue.doubleValue());
        return value;
    }

    public final BigDecimal getBigDecimal() {
        if (this.value != null) {
            return this.value;
        }
        if (this.rawData != null) {
            this.value = new BigDecimal(new BigInteger((int)this.rawSig, this.rawData), this.rawScale);
            this.rawData = null;
        }
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 3;
    }

    @Override
    public boolean getBoolean() {
        BigDecimal localValue = this.getBigDecimal();
        if (localValue == null) {
            return false;
        }
        return localValue.compareTo(ZERO) != 0;
    }

    @Override
    public String getString() {
        byte[] rawData;
        BigDecimal value = this.value;
        if (value != null) {
            int scale = value.scale();
            int signum = value.signum();
            if (signum != 0) {
                BigInteger bi = value.unscaledValue();
                int[] mag = this.getInternalMagnitude(bi);
                if (mag != null) {
                    int maglen = mag.length;
                    if (maglen > 0) {
                        int[] rmag = new int[maglen];
                        for (int i = 0; i < maglen; ++i) {
                            rmag[maglen - 1 - i] = mag[i];
                        }
                        return SQLDecimal.getAsString(signum, scale, rmag, null);
                    }
                    return SQLDecimal.getZeroString(scale, null);
                }
            } else {
                return SQLDecimal.getZeroString(scale, null);
            }
        }
        if ((rawData = this.rawData) != null) {
            return SQLDecimal.getAsString(rawData, 0, rawData.length, this.rawSig, this.rawScale);
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.getBigDecimal();
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((BigDecimal)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setCoreValue(SQLDecimal.getBigDecimal(theValue));
    }

    @Override
    public int getLength() {
        return this.getDecimalValuePrecision();
    }

    @Override
    public String getTypeName() {
        return "DECIMAL";
    }

    @Override
    public int getTypeFormatId() {
        return 200;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int signum;
        int scale;
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        int[] mag = null;
        if (this.value != null) {
            scale = this.value.scale();
            if (scale < 0) {
                scale = 0;
                this.value = this.value.setScale(0);
            }
            BigInteger bi = this.value.unscaledValue();
            mag = this.getInternalMagnitude(bi);
            signum = bi.signum();
        } else {
            scale = this.rawScale;
            signum = this.rawSig;
        }
        if (scale < 0) {
            SanityManager.THROWASSERT((String)("DECIMAL scale at writeExternal is negative " + scale + " value " + this.toString()));
        }
        out.writeByte(scale);
        out.writeByte(signum);
        if (mag != null) {
            InternalDataSerializer.serializeBigIntMagnitude((int[])mag, (DataOutput)out);
        } else {
            InternalDataSerializer.writeByteArray((byte[])this.rawData, (DataOutput)out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = null;
        this.rawScale = in.readByte();
        this.rawSig = in.readByte();
        assert (this.rawSig == 0 || this.rawSig == -1 || this.rawSig == 1) : this.rawSig + " byte=" + this.rawSig;
        this.rawData = InternalDataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = null;
        this.rawScale = in.readByte();
        this.rawSig = in.readByte();
        assert (this.rawSig == 0 || this.rawSig == -1 || this.rawSig == 1) : this.rawSig + " byte=" + this.rawSig;
        this.rawData = InternalDataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        BigDecimal otherValue = SQLDecimal.getBigDecimal(arg);
        return this.getBigDecimal().compareTo(otherValue);
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLDecimal(this.getBigDecimal());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBigDecimal(colNumber);
        this.rawData = null;
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 3);
            return;
        }
        ps.setBigDecimal(position, this.getBigDecimal());
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.rawData = null;
        if (theValue == null) {
            this.value = null;
        } else {
            try {
                theValue = theValue.trim();
                this.value = new BigDecimal(theValue);
                this.rawData = null;
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(theValue));
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(theValue));
    }

    @Override
    public void setValue(long theValue) {
        this.value = BigDecimal.valueOf(theValue);
        this.rawData = null;
    }

    @Override
    public void setValue(int theValue) {
        this.setValue((long)theValue);
    }

    @Override
    public void setBigDecimal(Number theValue) throws StandardException {
        this.setCoreValue((BigDecimal)theValue);
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (theValue != null && !(theValue instanceof BigDecimal) && !(theValue instanceof Long)) {
            SanityManager.THROWASSERT((String)("SQLDecimal.setValue(Number) passed a " + theValue.getClass()));
        }
        if (theValue instanceof BigDecimal || theValue == null) {
            this.setCoreValue((BigDecimal)theValue);
        } else {
            this.setValue(theValue.longValue());
        }
    }

    @Override
    public void setValue(boolean theValue) {
        this.setCoreValue(theValue ? ONE : ZERO);
    }

    @Override
    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal theValue) {
        this.value = theValue;
        this.rawData = null;
    }

    private void setCoreValue(double theValue) {
        this.value = new BigDecimal(Double.toString(theValue));
        this.rawData = null;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredScale = desiredType.getScale();
        int desiredPrecision = desiredType.getPrecision();
        this.setFrom(source);
        this.setWidth(desiredPrecision, desiredScale, true);
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(addend1).add(SQLDecimal.getBigDecimal(addend2)));
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).subtract(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(SQLDecimal.getBigDecimal(left).multiply(SQLDecimal.getBigDecimal(right)));
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        return this.divide(dividend, divisor, result, -1);
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        BigDecimal divisorBigDecimal = SQLDecimal.getBigDecimal(divisor);
        if (divisorBigDecimal.compareTo(ZERO) == 0) {
            throw StandardException.newException("22012");
        }
        BigDecimal dividendBigDecimal = SQLDecimal.getBigDecimal(dividend);
        result.setBigDecimal(dividendBigDecimal.divide(divisorBigDecimal, scale > -1 ? scale : Math.max(dividendBigDecimal.scale() + SQLDecimal.getWholeDigits(divisorBigDecimal) + 1, 4), 1));
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLDecimal();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setBigDecimal(this.getBigDecimal().negate());
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }

    public int hashCode() {
        long longVal;
        double doubleVal;
        BigDecimal localValue = this.getBigDecimal();
        double d = doubleVal = localValue != null ? localValue.doubleValue() : 0.0;
        if (Double.isInfinite(doubleVal)) {
            longVal = localValue.longValue();
        } else {
            longVal = (long)doubleVal;
            if ((double)longVal != doubleVal) {
                longVal = Double.doubleToLongBits(doubleVal);
            }
        }
        return (int)(longVal ^ longVal >> 32);
    }

    @Override
    public void setWidth(int desiredPrecision, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (desiredPrecision != -1 && desiredPrecision - desiredScale < SQLDecimal.getWholeDigits(this.getBigDecimal())) {
            throw StandardException.newException("22003", (Object)("DECIMAL/NUMERIC(" + desiredPrecision + "," + desiredScale + ") - " + this.getBigDecimal()), (Object)null);
        }
        this.value = this.value.setScale(desiredScale, 1);
        this.rawData = null;
    }

    @Override
    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigDecimal localValue = this.getBigDecimal();
        return SQLDecimal.getWholeDigits(localValue) + this.getDecimalValueScale();
    }

    @Override
    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value == null) {
            return this.rawScale;
        }
        int scale = this.value.scale();
        if (scale >= 0) {
            return scale;
        }
        return 0;
    }

    public static BigDecimal getBigDecimal(DataValueDescriptor value) throws StandardException {
        if (value.isNull()) {
            SanityManager.THROWASSERT((String)"NULL value passed to SQLDecimal.getBigDecimal");
        }
        switch (value.typeToBigDecimal()) {
            case 3: {
                return (BigDecimal)value.getObject();
            }
            case 1: {
                try {
                    return new BigDecimal(value.getString().trim());
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", (Object)"java.math.BigDecimal", (Object)null);
                }
            }
            case -5: {
                return BigDecimal.valueOf(value.getLong());
            }
        }
        SanityManager.THROWASSERT((String)("invalid return from " + value.getClass() + ".typeToBigDecimal() " + value.typeToBigDecimal()));
        return null;
    }

    private static int getWholeDigits(BigDecimal decimalValue) {
        if (ONE.compareTo(decimalValue = decimalValue.abs()) == 1) {
            return 0;
        }
        return decimalValue.precision() - decimalValue.scale();
    }

    static final boolean getBoolean(BigDecimal bd) {
        if (bd != null) {
            return bd.compareTo(ZERO) != 0;
        }
        return false;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            this.toDataForOptimizedResultHolder(out);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput in) throws IOException, ClassNotFoundException {
        this.value = null;
        this.rawScale = in.readByte();
        this.rawSig = in.readByte();
        this.rawData = InternalDataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput out) throws IOException {
        int signum;
        int[] mag;
        int scale;
        assert (!this.isNull());
        if (this.value != null) {
            scale = this.adjustScale();
            BigInteger bi = this.value.unscaledValue();
            mag = this.getInternalMagnitude(bi);
            signum = bi.signum();
        } else {
            mag = null;
            scale = this.rawScale;
            signum = this.rawSig;
        }
        assert (signum == 0 || signum == -1 || signum == 1) : signum + " byte=" + signum;
        out.writeByte(scale);
        out.writeByte(signum);
        if (mag != null) {
            InternalDataSerializer.serializeBigIntMagnitude((int[])mag, (DataOutput)out);
        } else {
            InternalDataSerializer.writeByteArray((byte[])this.rawData, (DataOutput)out);
        }
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        if (this.rawData == null) {
            if (this.value != null) {
                this.adjustScale();
                int[] mag = this.getInternalMagnitude(this.value.unscaledValue());
                if (mag != null) {
                    return ClientSharedUtils.getBigIntMagnitudeSizeInBytes((int[])mag) + 2;
                }
            } else {
                return 0;
            }
        }
        return this.rawData.length + 2;
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        if (this.value != null) {
            byte scale = (byte)this.adjustScale();
            BigInteger bi = this.value.unscaledValue();
            int[] magnitude = this.getInternalMagnitude(bi);
            if (magnitude != null) {
                byte signum = (byte)bi.signum();
                outBytes[offset++] = scale;
                outBytes[offset++] = signum;
                return InternalDataSerializer.serializeBigIntMagnitudeToBytes((int[])magnitude, (byte[])outBytes, (int)offset) + 2;
            }
        }
        assert (this.rawData != null);
        int numBytes = this.rawData.length;
        outBytes[offset++] = this.rawScale;
        outBytes[offset++] = this.rawSig;
        System.arraycopy(this.rawData, 0, outBytes, offset, numBytes);
        return numBytes + 2;
    }

    private final int adjustScale() {
        int scale = this.value.scale();
        if (scale >= 0) {
            return scale;
        }
        this.value = this.value.setScale(0);
        return 0;
    }

    private final int[] getInternalMagnitude(BigInteger bi) {
        int[] magnitude = ClientSharedUtils.getBigIntInternalMagnitude((BigInteger)bi);
        if (magnitude != null) {
            return magnitude;
        }
        assert (this.value.scale() >= 0) : "unexpected -ve scale";
        this.rawScale = (byte)this.value.scale();
        this.rawSig = (byte)bi.signum();
        assert (this.rawSig == 0 || this.rawSig == -1 || this.rawSig == 1) : this.rawSig + " byte=" + this.rawSig;
        this.rawData = bi.abs().toByteArray();
        this.value = null;
        return null;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        int numBytes = columnWidth - 2;
        this.value = null;
        this.rawData = new byte[numBytes];
        this.rawScale = inBytes[offset++];
        this.rawSig = inBytes[offset++];
        System.arraycopy(inBytes, offset, this.rawData, 0, numBytes);
        assert (this.rawSig == 0 || this.rawSig == -1 || this.rawSig == 1) : this.rawSig + " byte=" + this.rawSig;
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        int numBytes = columnWidth - 2;
        this.value = null;
        this.rawData = new byte[numBytes];
        this.rawScale = Platform.getByte(null, (long)memOffset++);
        this.rawSig = Platform.getByte(null, (long)memOffset++);
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])this.rawData, (int)numBytes);
        assert (this.rawSig == 0 || this.rawSig == -1 || this.rawSig == 1) : this.rawSig + " byte=" + this.rawSig;
        return columnWidth;
    }

    @Override
    public final int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        int formatId = this.getTypeFormatId();
        if (this.value != null) {
            byte scale = (byte)this.adjustScale();
            BigInteger bi = this.value.unscaledValue();
            int[] magnitude = this.getInternalMagnitude(bi);
            if (magnitude != null) {
                hash = ResolverUtils.addByteToBucketHash((byte)scale, (int)hash, (int)formatId);
                hash = ResolverUtils.addByteToBucketHash((byte)((byte)bi.signum()), (int)hash, (int)formatId);
                return ResolverUtils.computeHashCode((int[])magnitude, (int)hash, (int)formatId);
            }
        }
        assert (this.rawData != null);
        hash = ResolverUtils.addByteToBucketHash((byte)this.rawScale, (int)hash, (int)formatId);
        hash = ResolverUtils.addByteToBucketHash((byte)this.rawSig, (int)hash, (int)formatId);
        return ResolverUtils.addBytesToBucketHash((byte[])this.rawData, (int)hash, (int)formatId);
    }

    @Override
    public final void setRegionContext(LocalRegion region) {
        BigDecimal val = this.value;
        if (val == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger((int)this.rawSig, this.rawData), this.rawScale);
            this.rawData = null;
        }
    }

    public static final BigDecimal getAsBigDecimal(byte[] inBytes, int offset, int columnWidth) {
        byte scale = inBytes[offset++];
        byte signum = inBytes[offset++];
        int numBytes = columnWidth - 2;
        byte[] bytes = new byte[numBytes];
        System.arraycopy(inBytes, offset, bytes, 0, numBytes);
        return new BigDecimal(new BigInteger((int)signum, bytes), scale);
    }

    static final BigDecimal getAsBigDecimal(long memOffset, int columnWidth) {
        byte scale = Platform.getByte(null, (long)memOffset++);
        byte signum = Platform.getByte(null, (long)memOffset++);
        int numBytes = columnWidth - 2;
        byte[] bytes = new byte[numBytes];
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])bytes, (int)numBytes);
        return new BigDecimal(new BigInteger((int)signum, bytes), scale);
    }

    private static int addDecimalPointAndSign(int signum, int scale, char[] s, int endPos) {
        if (scale > 0) {
            while (--scale > 0) {
                s[--endPos] = 48;
            }
            s[--endPos] = 46;
            s[--endPos] = 48;
        }
        if (signum < 0) {
            s[--endPos] = 45;
        }
        return endPos;
    }

    private static String getAsString(int signum, int scale, long v, ByteArrayDataOutput buffer) {
        int endPos;
        int size = Math.max(scale, 19) + 3;
        char[] s = new char[size];
        if (scale > 0 && scale < 20) {
            int decimalPos = size - 1 - scale;
            endPos = DataTypeUtilities.toStringUnsignedWithDecimalPoint(v, s, size, decimalPos);
        } else {
            endPos = DataTypeUtilities.toStringUnsigned(v, s, size);
        }
        scale -= size - endPos - 1;
        endPos = SQLDecimal.addDecimalPointAndSign(signum, scale, s, endPos);
        if (buffer == null) {
            return new String(s, endPos, size - endPos);
        }
        buffer.writeBytes(s, endPos, size);
        return null;
    }

    private static String getAsString(int signum, int scale, int[] mag, ByteArrayDataOutput buffer) {
        int maglen = mag.length;
        int[] result = new int[maglen];
        int size = Math.max((int)(0.51 + Base10Conversion.LOG10_2 * (double)(maglen << 5)), scale) + 3;
        char[] s = new char[size];
        int endPos = size;
        assert (maglen > 0) : Integer.toString(maglen);
        while (true) {
            int i;
            long lenAndRemainder = Base10Conversion.divideByBillion(mag, maglen, result);
            int newEnd = endPos - 9;
            if (scale > 0 && scale < 9) {
                int decimalPos = endPos - 1 - scale;
                endPos = DataTypeUtilities.toStringUnsignedWithDecimalPoint((int)(lenAndRemainder & 0xFFFFFFFFL), s, endPos, decimalPos);
                maglen = (int)(lenAndRemainder >>> 32);
                if (maglen == 0) {
                    scale = endPos - decimalPos;
                    break;
                }
                --newEnd;
                if (endPos < decimalPos) {
                    for (i = newEnd; i < endPos; ++i) {
                        s[i] = 48;
                    }
                } else {
                    for (i = newEnd; i < decimalPos; ++i) {
                        s[i] = 48;
                    }
                    s[decimalPos] = 46;
                    ++i;
                    while (i < endPos) {
                        s[i] = 48;
                        ++i;
                    }
                }
                scale = 0;
            } else {
                int initEndPos = endPos;
                endPos = DataTypeUtilities.toStringUnsigned((int)(lenAndRemainder & 0xFFFFFFFFL), s, endPos);
                maglen = (int)(lenAndRemainder >>> 32);
                if (maglen == 0) {
                    if (scale <= 0) break;
                    scale -= initEndPos - endPos - 1;
                    break;
                }
                for (i = newEnd; i < endPos; ++i) {
                    s[i] = 48;
                }
                if (scale > 0 && (scale -= 9) == 0) {
                    s[--newEnd] = 46;
                }
            }
            if (endPos > newEnd) {
                endPos = newEnd;
            }
            int[] tmp = result;
            result = mag;
            mag = tmp;
        }
        endPos = SQLDecimal.addDecimalPointAndSign(signum, scale, s, endPos);
        if (buffer == null) {
            return new String(s, endPos, size - endPos);
        }
        buffer.writeBytes(s, endPos, size);
        return null;
    }

    private static String getZeroString(int scale, ByteArrayDataOutput buffer) {
        if (scale > 0) {
            int size = scale + 2;
            char[] s = new char[size];
            s[0] = 48;
            s[1] = 46;
            for (int i = 2; i < size; ++i) {
                s[i] = 48;
            }
            if (buffer == null) {
                return ClientSharedUtils.newWrappedString((char[])s, (int)0, (int)size);
            }
            buffer.writeBytes(s, 0, size);
            return null;
        }
        if (buffer == null) {
            return "0";
        }
        buffer.write(48);
        return null;
    }

    private static String getAsString(byte[] inBytes, int offset, int bytesLen, int signum, int scale) {
        if (signum != 0 && bytesLen > 0) {
            if (bytesLen < 8 || bytesLen == 8 && inBytes[offset] >= 0) {
                long v = Base10Conversion.convertBytesToLong(inBytes, offset, bytesLen + offset);
                return SQLDecimal.getAsString(signum, scale, v, null);
            }
            int[] mag = Base10Conversion.convertBytesToIntegerMagnitude(inBytes, offset, bytesLen + offset);
            return SQLDecimal.getAsString(signum, scale, mag, null);
        }
        return SQLDecimal.getZeroString(scale, null);
    }

    public static String getAsString(byte[] inBytes, int offset, int columnWidth) {
        byte scale = inBytes[offset++];
        byte signum = inBytes[offset++];
        return SQLDecimal.getAsString(inBytes, offset, columnWidth - 2, signum, scale);
    }

    static String getAsString(UnsafeWrapper unsafe, long memOffset, int columnWidth) {
        byte signum;
        long endBytesAddr = memOffset + (long)columnWidth;
        byte scale = unsafe.getByte(memOffset++);
        if ((signum = unsafe.getByte(memOffset++)) != 0 && columnWidth > 2) {
            if (columnWidth < 10 || columnWidth == 10 && unsafe.getByte(memOffset) >= 0) {
                long v = Base10Conversion.convertBytesToLong(unsafe, memOffset, endBytesAddr);
                return SQLDecimal.getAsString((int)signum, (int)scale, v, null);
            }
            int[] mag = Base10Conversion.convertBytesToIntegerMagnitude(unsafe, memOffset, endBytesAddr);
            return SQLDecimal.getAsString((int)signum, (int)scale, mag, null);
        }
        return SQLDecimal.getZeroString(scale, null);
    }

    static void writeAsString(byte[] inBytes, int offset, int columnWidth, ByteArrayDataOutput buffer) {
        byte signum;
        byte scale = inBytes[offset++];
        if ((signum = inBytes[offset++]) != 0 && columnWidth > 2) {
            if (columnWidth < 10 || columnWidth == 10 && inBytes[offset] >= 0) {
                long v = Base10Conversion.convertBytesToLong(inBytes, offset, columnWidth - 2 + offset);
                SQLDecimal.getAsString((int)signum, (int)scale, v, buffer);
            } else {
                int[] mag = Base10Conversion.convertBytesToIntegerMagnitude(inBytes, offset, columnWidth - 2 + offset);
                SQLDecimal.getAsString((int)signum, (int)scale, mag, buffer);
            }
        } else {
            SQLDecimal.getZeroString(scale, buffer);
        }
    }

    static void writeAsString(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteArrayDataOutput buffer) {
        byte signum;
        long endBytesAddr = memOffset + (long)columnWidth;
        byte scale = unsafe.getByte(memOffset++);
        if ((signum = unsafe.getByte(memOffset++)) != 0 && columnWidth > 2) {
            if (columnWidth < 10 || columnWidth == 10 && unsafe.getByte(memOffset) >= 0) {
                long v = Base10Conversion.convertBytesToLong(unsafe, memOffset, endBytesAddr);
                SQLDecimal.getAsString((int)signum, (int)scale, v, buffer);
            } else {
                int[] mag = Base10Conversion.convertBytesToIntegerMagnitude(unsafe, memOffset, endBytesAddr);
                SQLDecimal.getAsString((int)signum, (int)scale, mag, buffer);
            }
        } else {
            SQLDecimal.getZeroString(scale, buffer);
        }
    }

    @Override
    public byte getTypeId() {
        return 24;
    }

    static final class Base10Conversion {
        static final double LOG10_2 = Math.log10(2.0);
        static final int MAX_INT_DIGITS = (int)Math.ceil(127.0 / (LOG10_2 * 32.0));
        static final long[][] POW2_QUOTIENTS = new long[MAX_INT_DIGITS][];
        static final int[] POW2_REMAINDERS = new int[MAX_INT_DIGITS];
        static final int BILLION_INT = 1000000000;
        static final long MAX_UINT = 0xFFFFFFFFL;

        Base10Conversion() {
        }

        static long[] covertIntsToUnsignedLongs(int[] a) {
            int alen = a.length;
            long[] l = new long[alen];
            for (int index = 0; index < alen; ++index) {
                l[index] = (long)a[index] & 0xFFFFFFFFL;
            }
            return l;
        }

        static long convertBytesToLong(byte[] mag, int offset, int endOffset) {
            assert (endOffset - offset <= 8) : "endOffset=" + endOffset + " offset=" + offset;
            while (offset < endOffset && mag[offset] == 0) {
                ++offset;
            }
            int numQs = endOffset - offset + 3 >>> 2;
            int bend = endOffset;
            int res = mag[--bend] & 0xFF;
            int shift = 8;
            int bstart = Math.max(offset, bend - 3);
            while (bend > bstart) {
                res |= (mag[--bend] & 0xFF) << shift;
                shift += 8;
            }
            long result = (long)res & 0xFFFFFFFFL;
            if (numQs > 1) {
                res = mag[--bend] & 0xFF;
                shift = 8;
                bstart = Math.max(offset, bend - 3);
                while (bend > bstart) {
                    res |= (mag[--bend] & 0xFF) << shift;
                    shift += 8;
                }
                result |= ((long)res & 0xFFFFFFFFL) << 32;
            }
            return result;
        }

        static long convertBytesToLong(UnsafeWrapper unsafe, long memOffset, long memEnd) {
            assert (memEnd - memOffset <= 8L) : "memEnd=" + memEnd + " memOffset=" + memOffset;
            while (memOffset < memEnd && unsafe.getByte(memOffset) == 0) {
                ++memOffset;
            }
            int numQs = (int)(memEnd - memOffset) + 3 >>> 2;
            long bend = memEnd;
            int res = unsafe.getByte(--bend) & 0xFF;
            int shift = 8;
            long bstart = Math.max(memOffset, bend - 3L);
            while (bend > bstart) {
                res |= (unsafe.getByte(--bend) & 0xFF) << shift;
                shift += 8;
            }
            long result = (long)res & 0xFFFFFFFFL;
            if (numQs > 1) {
                res = unsafe.getByte(--bend) & 0xFF;
                shift = 8;
                bstart = Math.max(memOffset, bend - 3L);
                while (bend > bstart) {
                    res |= (unsafe.getByte(--bend) & 0xFF) << shift;
                    shift += 8;
                }
                result |= ((long)res & 0xFFFFFFFFL) << 32;
            }
            return result;
        }

        static int[] convertBytesToIntegerMagnitude(byte[] mag, int offset, int endOffset) {
            while (offset < endOffset && mag[offset] == 0) {
                ++offset;
            }
            int numQs = endOffset - offset + 3 >>> 2;
            int[] result = new int[numQs];
            int bend = endOffset;
            for (int i = 0; i < numQs; ++i) {
                int res = mag[--bend] & 0xFF;
                int shift = 8;
                int bstart = Math.max(offset, bend - 3);
                while (bend > bstart) {
                    res |= (mag[--bend] & 0xFF) << shift;
                    shift += 8;
                }
                result[i] = res;
            }
            return result;
        }

        static int[] convertBytesToIntegerMagnitude(UnsafeWrapper unsafe, long memOffset, long memEnd) {
            while (memOffset < memEnd && unsafe.getByte(memOffset) == 0) {
                ++memOffset;
            }
            int numQs = (int)(memEnd - memOffset) + 3 >>> 2;
            int[] result = new int[numQs];
            long bend = memEnd;
            for (int i = 0; i < numQs; ++i) {
                int res = unsafe.getByte(--bend) & 0xFF;
                int shift = 8;
                long bstart = Math.max(memOffset, bend - 3L);
                while (bend > bstart) {
                    res |= (unsafe.getByte(--bend) & 0xFF) << shift;
                    shift += 8;
                }
                result[i] = res;
            }
            return result;
        }

        static long divideByBillion(int[] mag, int maglen, int[] result) {
            if (maglen > 2 || maglen == 2 && mag[1] < 0) {
                long[][] POW2_QUOTIENTS_ = POW2_QUOTIENTS;
                int[] POW2_REMAINDERS_ = POW2_REMAINDERS;
                int remainder = 0;
                int resultLen = 0;
                boolean resultInitialized = false;
                int i = maglen;
                while (--i >= 0) {
                    long m;
                    int j;
                    long v = (long)mag[i] & 0xFFFFFFFFL;
                    long r = (long)POW2_REMAINDERS_[i] * v;
                    remainder = (int)((long)remainder + r % 1000000000L);
                    long[] pow2q = POW2_QUOTIENTS_[i];
                    long carry = r / 1000000000L;
                    if (remainder >= 1000000000) {
                        carry += (long)(remainder / 1000000000);
                        remainder %= 1000000000;
                    }
                    int pow2qLen = pow2q.length;
                    if (resultInitialized) {
                        for (j = 0; j < pow2qLen; ++j) {
                            m = v * pow2q[j] + carry + ((long)result[j] & 0xFFFFFFFFL);
                            result[j] = (int)m;
                            carry = m >>> 32;
                        }
                        if (carry == 0L) continue;
                        int n = pow2qLen;
                        result[n] = result[n] + (int)carry;
                        continue;
                    }
                    for (j = 0; j < pow2qLen; ++j) {
                        m = v * pow2q[j] + carry;
                        result[j] = (int)m;
                        carry = m >>> 32;
                    }
                    if (carry != 0L) {
                        result[pow2qLen] = (int)carry;
                        resultLen = pow2qLen + 1;
                    } else {
                        resultLen = pow2qLen;
                    }
                    resultInitialized = true;
                }
                return (long)resultLen << 32 | (long)remainder;
            }
            if (maglen == 1) {
                int mag0 = mag[0];
                if (mag0 >= 0) {
                    if (mag0 >= 1000000000) {
                        result[0] = mag0 / 1000000000;
                        return 0x100000000L | (long)(mag0 % 1000000000);
                    }
                    return mag0;
                }
                long v = (long)mag0 & 0xFFFFFFFFL;
                result[0] = (int)(v / 1000000000L);
                return 0x100000000L | v % 1000000000L;
            }
            long v = (long)mag[1] << 32 | (long)mag[0] & 0xFFFFFFFFL;
            long q = v / 1000000000L;
            if (q <= 0xFFFFFFFFL) {
                result[0] = (int)q;
                return 0x100000000L | v % 1000000000L;
            }
            result[0] = (int)(q & 0xFFFFFFFFL);
            result[1] = (int)(q >>> 32);
            return 0x200000000L | v % 1000000000L;
        }

        static {
            BigInteger billion = BigInteger.valueOf(1000000000L);
            for (int index = 0; index < MAX_INT_DIGITS; ++index) {
                byte[] mag = new byte[index * 4 + 1];
                mag[0] = 1;
                BigInteger pow2 = new BigInteger(mag);
                BigInteger[] quotientAndRemainder = pow2.divideAndRemainder(billion);
                byte[] qmag = quotientAndRemainder[0].toByteArray();
                Base10Conversion.POW2_QUOTIENTS[index] = Base10Conversion.covertIntsToUnsignedLongs(Base10Conversion.convertBytesToIntegerMagnitude(qmag, 0, qmag.length));
                Base10Conversion.POW2_REMAINDERS[index] = quotientAndRemainder[1].intValue();
            }
        }
    }
}

