/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.tools.i18n;

import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class RedirectedLocalizedOutput
extends LocalizedOutput {
    private final File file;

    public static RedirectedLocalizedOutput getNewInstance() {
        if (!NativeCalls.getInstance().isTTY()) {
            return null;
        }
        File f = new File(".plan");
        try {
            f.createNewFile();
            f.deleteOnExit();
            return new RedirectedLocalizedOutput(f);
        }
        catch (IOException e) {
            System.err.println("Error: ");
            e.printStackTrace(System.err);
            return null;
        }
    }

    private RedirectedLocalizedOutput(File f) throws IOException {
        super(new FileOutputStream(f));
        this.file = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForCompletion() {
        File workingDir = this.file.getParentFile();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "LESSOPEN=\"|color %s\" less -SR " + this.file.getName() + " < /dev/tty > /dev/tty "}, null, workingDir);
            int exitStatus = p.waitFor();
            if (exitStatus != 0) {
                System.err.println("ERROR opening less... " + exitStatus);
            }
            int n = exitStatus;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.file.delete();
        }
        return -1;
    }

    private static final class lesspWaiter
    extends Thread {
        private Process lessp;
        private int exitStatus;
        private volatile boolean isWaiting = false;

        public lesspWaiter(Process p, String name) {
            super(name);
            this.lessp = p;
        }

        @Override
        public void run() {
            try {
                this.isWaiting = true;
                this.exitStatus = this.lessp.waitFor();
                if (this.exitStatus != 0) {
                    System.err.println("SB: ERROR: " + this.exitStatus);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
            finally {
                this.isWaiting = false;
            }
        }

        public boolean isDone() {
            return !this.isWaiting;
        }
    }
}

