/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdSysAsyncEventListenerRowFactory;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;

public class GfxdAsyncEventListenerDescriptor
extends TupleDescriptor
implements Dependent {
    private final UUID uuid;
    private final String senderId;
    private String className;
    private final String serverGroup;
    private boolean manualStart = false;
    private boolean isBatchConflationEnabled = false;
    private int batchSize = 100;
    private int batchTimeInterval = 5;
    private boolean isPersistenceEnabled = false;
    private boolean diskSynchronous = false;
    private final String diskStoreName;
    private int maximumQueueMemory = 100;
    private int alertThreshold = 0;
    private final boolean isStarted;
    private boolean isValid;
    private final String initParams;
    private ValueRow catalogueRow;
    private int invalidateAction;

    public GfxdAsyncEventListenerDescriptor(DataDictionary dd, UUID id, String senderId, String className, String serverGroup, Boolean manualStart, Boolean isBatchConflationEnabled, Integer batchSize, Integer batchTimeInterval, Boolean isPersistenceEnabled, Boolean diskSync, String diskStoreName, Integer maximumQueueMemory, Integer alertThreshold, Boolean isStarted, String initParams) {
        super(dd);
        this.uuid = id;
        this.senderId = senderId;
        this.className = className;
        this.serverGroup = serverGroup;
        this.manualStart = manualStart;
        this.batchSize = batchSize;
        this.batchTimeInterval = batchTimeInterval;
        this.isBatchConflationEnabled = isBatchConflationEnabled;
        this.isPersistenceEnabled = isPersistenceEnabled;
        this.diskSynchronous = diskSync;
        this.diskStoreName = diskStoreName;
        this.maximumQueueMemory = maximumQueueMemory;
        this.alertThreshold = alertThreshold;
        this.isStarted = isStarted;
        this.isValid = true;
        this.initParams = initParams;
    }

    public GfxdAsyncEventListenerDescriptor(String id, UUID uuid) {
        this.uuid = uuid;
        this.senderId = id;
        this.className = null;
        this.serverGroup = null;
        this.manualStart = false;
        this.batchSize = -1;
        this.batchTimeInterval = -1;
        this.isBatchConflationEnabled = false;
        this.isPersistenceEnabled = false;
        this.diskSynchronous = false;
        this.diskStoreName = null;
        this.maximumQueueMemory = 0;
        this.alertThreshold = 0;
        this.isStarted = false;
        this.isValid = true;
        this.initParams = null;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public int getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    public boolean isBatchConflationEnabled() {
        return this.isBatchConflationEnabled;
    }

    public boolean isPersistenceEnabled() {
        return this.isPersistenceEnabled;
    }

    public boolean isDiskSynchronous() {
        return this.diskSynchronous;
    }

    public int getAlertThreshold() {
        return this.alertThreshold;
    }

    public boolean isManualStart() {
        return this.manualStart;
    }

    public final String getSenderId() {
        return this.senderId;
    }

    public final String getClassName() {
        return this.className;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public String getInitParams() {
        return this.initParams;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public String getDescriptorType() {
        return "AsyncEventListener";
    }

    @Override
    public String getDescriptorName() {
        return this.senderId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AsyncEventListener{");
        sb.append("id=" + this.getSenderId());
        sb.append(",listener=" + this.getClassName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(140);
    }

    @Override
    public String getObjectName() {
        return null;
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public String getClassType() {
        return null;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        LogWriter logger = Misc.getCacheLogWriter();
        logger.info("prepareToInvalidate called on: " + this + ", isValid: " + this.isValid);
        TabInfoImpl ti = null;
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ti = dd.getNonCoreTI(22);
        GfxdSysAsyncEventListenerRowFactory rf = (GfxdSysAsyncEventListenerRowFactory)ti.getCatalogRowFactory();
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        keyRow.setColumn(1, new SQLVarchar(this.senderId));
        this.catalogueRow = (ValueRow)ti.getRow(tc, keyRow, 0);
        System.out.println(this.catalogueRow);
        this.invalidateAction = action;
        if (action == 17) {
            int n = ti.deleteRow(tc, keyRow, 0);
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        LogWriter logger = Misc.getCacheLogWriter();
        logger.info("makeInvalid called on: " + this + ", isValid: " + this.isValid);
        assert (this.invalidateAction == action);
        if (!this.isValid) {
            this.refresh();
        }
        this.isValid = false;
    }

    private boolean refresh() {
        try {
            assert (this.catalogueRow != null);
            String classNameStr = ((SQLVarchar)this.catalogueRow.getColumn(2)).getString();
            GemFireCacheImpl cache = Misc.getGemFireCache();
            AsyncEventQueue asyncQueue = cache.getAsyncEventQueue(this.senderId);
            Class c = null;
            c = ClassPathLoader.getLatest().forName(classNameStr);
            AsyncEventListener asyncListener = (AsyncEventListener)c.newInstance();
            GfxdGatewayEventListener gfxdWrapperListener = (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
            gfxdWrapperListener.refreshActualListener(asyncListener);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

