/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.KeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;

public class ForeignKeyConstraintDescriptor
extends KeyConstraintDescriptor {
    ReferencedKeyConstraintDescriptor referencedConstraintDescriptor;
    UUID referencedConstraintId;
    int raDeleteRule;
    int raUpdateRule;

    protected ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, ReferencedKeyConstraintDescriptor referencedConstraintDescriptor, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, isEnabled);
        this.referencedConstraintDescriptor = referencedConstraintDescriptor;
        this.raDeleteRule = raDeleteRule;
        this.raUpdateRule = raUpdateRule;
    }

    ForeignKeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] fkColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, UUID referencedConstraintId, boolean isEnabled, int raDeleteRule, int raUpdateRule) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, fkColumns, constraintId, indexId, schemaDesc, isEnabled);
        this.referencedConstraintId = referencedConstraintId;
        this.raDeleteRule = raDeleteRule;
        this.raUpdateRule = raUpdateRule;
    }

    public ForeignKeyConstraintDescriptor(ForeignKeyConstraintDescriptor fkcd, UUID newIndexUID) {
        this(fkcd.getDataDictionary(), fkcd.table, fkcd.constraintName, fkcd.deferrable(), fkcd.initiallyDeferred(), fkcd.getReferencedColumns(), fkcd.constraintId, newIndexUID, fkcd.getSchemaDescriptor(), fkcd.referencedConstraintId, fkcd.isEnabled, fkcd.raDeleteRule, fkcd.raUpdateRule);
    }

    public ReferencedKeyConstraintDescriptor getReferencedConstraint() throws StandardException {
        TableDescriptor refTd;
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor;
        }
        if (this.referencedConstraintId == null) {
            this.getReferencedConstraintId();
        }
        if ((refTd = this.getDataDictionary().getConstraintTableDescriptor(this.referencedConstraintId)) == null) {
            SanityManager.THROWASSERT((String)("not able to find " + this.referencedConstraintId + " in SYS.SYSCONSTRAINTS"));
        }
        ConstraintDescriptorList cdl = this.getDataDictionary().getConstraintDescriptors(refTd);
        this.referencedConstraintDescriptor = (ReferencedKeyConstraintDescriptor)cdl.getConstraintDescriptorById(this.referencedConstraintId);
        if (this.referencedConstraintDescriptor == null) {
            SanityManager.THROWASSERT((String)("not able to find " + this.referencedConstraintDescriptor + " off of table descriptor " + refTd.getName()));
        }
        return this.referencedConstraintDescriptor;
    }

    public UUID getReferencedConstraintId() throws StandardException {
        if (this.referencedConstraintDescriptor != null) {
            return this.referencedConstraintDescriptor.getUUID();
        }
        SubKeyConstraintDescriptor subKey = this.getDataDictionary().getSubKeyConstraint(this.constraintId, 6);
        if (subKey == null) {
            SanityManager.THROWASSERT((String)("not able to find " + this.constraintName + " in SYS.SYSFOREIGNKEYS"));
        }
        this.referencedConstraintId = subKey.getKeyConstraintId();
        return this.referencedConstraintId;
    }

    @Override
    public int getConstraintType() {
        return 6;
    }

    @Override
    public boolean needsToFire(int stmtType, int[] modifiedCols) {
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 4) {
            return false;
        }
        if (stmtType == 1) {
            return true;
        }
        return ForeignKeyConstraintDescriptor.doColumnsIntersect(modifiedCols, this.getReferencedColumns());
    }

    public boolean isSelfReferencingFK() throws StandardException {
        ReferencedKeyConstraintDescriptor refcd = this.getReferencedConstraint();
        return refcd.getTableId().equals(this.getTableId());
    }

    public int getRaDeleteRule() {
        return this.raDeleteRule;
    }

    public int getRaUpdateRule() {
        return this.raUpdateRule;
    }
}

