/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DefaultInfo;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public final class ColumnDescriptor
extends TupleDescriptor {
    private DefaultInfo columnDefaultInfo;
    private TableDescriptor table;
    private String columnName;
    private int columnPosition;
    public final DataTypeDescriptor columnType;
    public DataValueDescriptor columnDefault;
    public byte[] columnDefaultBytes;
    public final boolean isNullable;
    public final int fixedWidth;
    public final boolean isLob;
    private UUID uuid;
    private UUID defaultUUID;
    private long autoincStart;
    private long autoincInc;
    private long autoincValue;
    private boolean isGeneratedByDefault;
    long autoinc_create_or_modify_Start_Increment = -1L;

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, TableDescriptor table, UUID defaultUUID, long autoincStart, long autoincInc, long userChangedWhat, boolean isGeneratedByDefault) {
        this(columnName, columnPosition, columnType, columnDefault, columnDefaultInfo, table, defaultUUID, autoincStart, autoincInc, isGeneratedByDefault);
        this.autoinc_create_or_modify_Start_Increment = userChangedWhat;
    }

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, TableDescriptor table, UUID defaultUUID, long autoincStart, long autoincInc, boolean isGeneratedByDefault) {
        this.columnName = columnName;
        this.columnPosition = columnPosition;
        this.columnType = columnType;
        this.setColumnDefault(columnDefault);
        this.columnDefaultInfo = columnDefaultInfo;
        this.defaultUUID = defaultUUID;
        if (table != null) {
            this.table = table;
            this.uuid = table.getUUID();
        }
        ColumnDescriptor.assertAutoinc(autoincInc != 0L, autoincInc, columnDefaultInfo);
        this.autoincStart = autoincStart;
        this.autoincValue = autoincStart;
        this.autoincInc = autoincInc;
        this.isGeneratedByDefault = isGeneratedByDefault;
        this.isNullable = columnType.isNullable();
        this.fixedWidth = RowFormatter.getFixedWidthInBytes(columnType, this);
        this.isLob = RowFormatter.isLob(columnType);
    }

    public ColumnDescriptor(String columnName, int columnPosition, DataTypeDescriptor columnType, DataValueDescriptor columnDefault, DefaultInfo columnDefaultInfo, UUID uuid, UUID defaultUUID, long autoincStart, long autoincInc, long autoincValue, boolean isGeneratedByDefault) {
        this.columnName = columnName;
        this.columnPosition = columnPosition;
        this.columnType = columnType;
        this.setColumnDefault(columnDefault);
        this.columnDefaultInfo = columnDefaultInfo;
        this.uuid = uuid;
        this.defaultUUID = defaultUUID;
        ColumnDescriptor.assertAutoinc(autoincInc != 0L, autoincInc, columnDefaultInfo);
        this.autoincStart = autoincStart;
        this.autoincValue = autoincValue;
        this.autoincInc = autoincInc;
        this.isGeneratedByDefault = isGeneratedByDefault;
        this.isNullable = columnType.isNullable();
        this.fixedWidth = RowFormatter.getFixedWidthInBytes(columnType, this);
        this.isLob = RowFormatter.isLob(columnType);
    }

    public void setColumnDefault(DataValueDescriptor columnDefault) {
        if (columnDefault != null && !columnDefault.isNull()) {
            try {
                int len = columnDefault.getLengthInBytes(this.columnType);
                byte[] bytes = new byte[len];
                columnDefault.writeBytes(bytes, 0, this.columnType);
                this.columnDefaultBytes = bytes;
            }
            catch (StandardException se) {
                throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
            }
            this.columnDefault = columnDefault;
        } else {
            this.columnDefaultBytes = null;
            this.columnDefault = null;
        }
    }

    public ColumnDescriptor cloneObject() {
        ColumnDescriptor cd = new ColumnDescriptor(this.columnName, this.columnPosition, this.columnType, this.columnDefault, this.columnDefaultInfo, this.table, this.defaultUUID, this.autoincStart, this.autoincInc, this.autoinc_create_or_modify_Start_Increment, this.isGeneratedByDefault);
        cd.uuid = this.uuid;
        return cd;
    }

    public UUID getReferencingUUID() {
        return this.uuid;
    }

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
    }

    public void setTableDescriptor(TableDescriptor tableDescriptor) {
        this.table = tableDescriptor;
    }

    public int getPosition() {
        return this.columnPosition;
    }

    public DataTypeDescriptor getType() {
        return this.columnType;
    }

    public boolean hasNonNullDefault() {
        if (this.columnDefault != null && !this.columnDefault.isNull()) {
            return true;
        }
        return this.columnDefaultInfo != null;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.columnDefault;
    }

    public DefaultInfo getDefaultInfo() {
        return this.columnDefaultInfo;
    }

    public UUID getDefaultUUID() {
        return this.defaultUUID;
    }

    public DefaultDescriptor getDefaultDescriptor(DataDictionary dd) {
        DefaultDescriptor defaultDescriptor = null;
        if (this.defaultUUID != null) {
            defaultDescriptor = new DefaultDescriptor(dd, this.defaultUUID, this.uuid, this.columnPosition);
        }
        return defaultDescriptor;
    }

    public boolean isAutoincrement() {
        return this.autoincInc != 0L;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public boolean isAutoincAlways() {
        return this.columnDefaultInfo == null && this.isAutoincrement();
    }

    public boolean isGeneratedByDefault() {
        return this.isGeneratedByDefault;
    }

    public long getAutoincStart() {
        return this.autoincStart;
    }

    public long getAutoincInc() {
        return this.autoincInc;
    }

    public long getAutoincValue() {
        return this.autoincValue;
    }

    public long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    public void setAutoinc_create_or_modify_Start_Increment(int c_or_m) {
        this.autoinc_create_or_modify_Start_Increment = c_or_m;
    }

    public void setGeneratedByDefault(boolean value) {
        this.isGeneratedByDefault = value;
    }

    public void setPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public String toString() {
        return "columnName: " + this.columnName + "\ncolumnPosition: " + this.columnPosition + "\ncolumnType: " + this.columnType + "\ncolumnDefault: " + this.columnDefault + "\n" + (this.isLob ? "isLob: true\n" : "") + "maximumWidth: " + this.columnType.getMaximumWidth() + "\nuuid: " + this.uuid + "\ndefaultUUID: " + this.defaultUUID + "\n";
    }

    @Override
    public String getDescriptorName() {
        return this.columnName;
    }

    @Override
    public String getDescriptorType() {
        return "Column";
    }

    private static void assertAutoinc(boolean autoinc, long autoincInc, DefaultInfo defaultInfo) {
        if (autoinc) {
            SanityManager.ASSERT((autoincInc != 0L ? 1 : 0) != 0, (String)"increment is zero for  autoincrement column");
            SanityManager.ASSERT((defaultInfo == null || defaultInfo.isDefaultValueAutoinc() ? 1 : 0) != 0, (String)"If column is autoinc and have defaultInfo, isDefaultValueAutoinc must be true.");
        } else {
            SanityManager.ASSERT((autoincInc == 0L ? 1 : 0) != 0, (String)"increment is non-zero for non-autoincrement column");
            SanityManager.ASSERT((defaultInfo == null || !defaultInfo.isDefaultValueAutoinc() ? 1 : 0) != 0, (String)"If column is not autoinc and have defaultInfo, isDefaultValueAutoinc can not be true");
        }
    }

    public int hashCode() {
        TableDescriptor td = this.table;
        String name = this.columnName;
        if (td != null) {
            return td.hashCode() ^ name.hashCode();
        }
        return name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColumnDescriptor) {
            ColumnDescriptor otherCD = (ColumnDescriptor)other;
            TableDescriptor td = this.table;
            TableDescriptor otherTD = otherCD.table;
            if (td != null && otherTD != null) {
                return this.columnName.equals(otherCD.columnName) && td.equals(otherTD);
            }
        }
        return false;
    }
}

