/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.monitor;

import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.InstanceGetter;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.impl.services.monitor.FileMonitor;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;

public class Monitor {
    public static final String SERVICE_TYPE_DIRECTORY = "serviceDirectory";
    public static final Object syncMe = new Object();
    public static final String NEW_INSTANCE_FROM_ID_TRACE_DEBUG_FLAG = "MonitorNewInstanceFromId";
    public static boolean reportOn = Boolean.getBoolean("gemfirexd.monitor.verbose");
    public static final String DEBUG_TRUE = "gemfirexd.debug.true";
    public static final String DEBUG_FALSE = "gemfirexd.debug.false";
    private static ModuleFactory monitor;
    private static ModuleFactory monitorlite;
    private static boolean active;

    public static void startMonitor(Properties bootProperties, PrintStream logging) {
        GemFireCacheImpl.setGFXDSystem((boolean)true);
        new FileMonitor(bootProperties, logging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitor(ModuleFactory theMonitor) {
        Object object = syncMe;
        synchronized (object) {
            if (active) {
                return false;
            }
            monitor = theMonitor;
            active = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMonitor() {
        Object object = syncMe;
        synchronized (object) {
            active = false;
        }
    }

    public static ModuleFactory getMonitor() {
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getMonitorLite() {
        Object object = syncMe;
        synchronized (object) {
            if (active && monitor != null) {
                return monitor;
            }
        }
        return new FileMonitor();
    }

    public static boolean inShutdown() {
        ModuleFactory m = monitor;
        return m == null || m.inShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleFactory getCachedMonitorLite(boolean clear) {
        Object object = syncMe;
        synchronized (object) {
            if (!clear && active && monitor != null) {
                return monitor;
            }
        }
        if (!clear && monitorlite == null) {
            monitorlite = new FileMonitor();
        }
        ModuleFactory retVal = monitorlite;
        if (clear) {
            monitorlite = null;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCachedMonitorLite() {
        Object object = syncMe;
        synchronized (object) {
            monitorlite = null;
        }
    }

    public static HeaderPrintWriter getStream() {
        return monitor != null ? monitor.getSystemStreams().stream() : null;
    }

    public static String getServiceName(Object serviceModule) {
        return monitor.getServiceName(serviceModule);
    }

    public static Object startSystemModule(String factoryInterface) throws StandardException {
        Object module = monitor.startModule(false, null, factoryInterface, null, null);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object findSystemModule(String factoryInterface) throws StandardException {
        Object module = Monitor.getMonitor().findModule(null, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getSystemModule(String factoryInterface) {
        ModuleFactory monitor = Monitor.getMonitor();
        if (monitor == null) {
            return null;
        }
        Object module = monitor.findModule(null, factoryInterface, null);
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, Properties properties) throws StandardException {
        Object module = monitor.startModule(create, serviceModule, factoryInterface, null, properties);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object bootServiceModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        Object module = monitor.startModule(create, serviceModule, factoryInterface, identifier, properties);
        SanityManager.ASSERT((module != null ? 1 : 0) != 0, (String)("module is null - " + factoryInterface));
        return module;
    }

    public static Object findServiceModule(Object serviceModule, String factoryInterface) throws StandardException {
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        if (module == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return module;
    }

    public static Object getServiceModule(Object serviceModule, String factoryInterface) {
        Object module = Monitor.getMonitor().findModule(serviceModule, factoryInterface, null);
        return module;
    }

    public static Object findServiceModule(Object serviceModule, String factoryInterface, String identifier) {
        return monitor.findModule(serviceModule, factoryInterface, identifier);
    }

    public static Object findService(String factoryInterface, String serviceName) {
        return monitor.findService(factoryInterface, serviceName);
    }

    public static boolean startPersistentService(String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.startPersistentService(serviceName, properties);
    }

    public static Object startNonPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT((factoryInterface != null ? 1 : 0) != 0, (String)"serviceName is null");
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.startNonPersistentService(factoryInterface, serviceName, properties);
    }

    public static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        SanityManager.ASSERT((factoryInterface != null ? 1 : 0) != 0, (String)"serviceName is null");
        SanityManager.ASSERT((serviceName != null ? 1 : 0) != 0, (String)"serviceName is null");
        return monitor.createPersistentService(factoryInterface, serviceName, properties);
    }

    public static void removePersistentService(String name) throws StandardException {
        monitor.removePersistentService(name);
    }

    public static InstanceGetter classFromIdentifier(int identifier) throws StandardException {
        return monitor.classFromIdentifier(identifier);
    }

    public static Object newInstanceFromIdentifier(int identifier) throws StandardException {
        return monitor.newInstanceFromIdentifier(identifier);
    }

    public static StandardException missingProductVersion(String productGenusName) {
        return StandardException.newException("XBM05.D", productGenusName);
    }

    public static StandardException missingImplementation(String implementation) {
        return StandardException.newException("XBM02.D", implementation);
    }

    public static StandardException exceptionStartingModule(Throwable t) {
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        return StandardException.newException("XBM01.D", t);
    }

    public static void logMessage(String messageText) {
        Monitor.getStream().println(messageText);
    }

    public static void logTextMessage(String messageID) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID));
    }

    public static void logTextMessage(String messageID, Object a1) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2, Object a3) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2, a3));
    }

    public static void logTextMessage(String messageID, Object a1, Object a2, Object a3, Object a4) {
        Monitor.getStream().println(MessageService.getTextMessage(messageID, a1, a2, a3, a4));
    }

    public static Locale getLocaleFromString(String localeDescription) throws StandardException {
        return monitor.getLocaleFromString(localeDescription);
    }

    public static boolean isFullUpgrade(Properties startParams, String oldVersionInfo) throws StandardException {
        boolean fullUpgrade = Boolean.valueOf(startParams.getProperty("upgrade"));
        ProductVersionHolder engineVersion = Monitor.getMonitor().getEngineVersion();
        if ((engineVersion.isBeta() || engineVersion.isAlpha()) && !PropertyUtil.getSystemBoolean("gemfirexd.distributedsystem.allowPreReleaseUpgrade")) {
            throw StandardException.newException("XCW00.D", (Object)oldVersionInfo, (Object)engineVersion.getSimpleVersionString());
        }
        return fullUpgrade;
    }

    public static boolean isDesiredType(Properties startParams, int desiredProperty) {
        int engineType = 2;
        if (startParams != null) {
            engineType = Monitor.getEngineType(startParams);
        }
        return (engineType & desiredProperty) != 0;
    }

    public static boolean isDesiredType(int engineType, int desiredType) {
        return (engineType & desiredType) != 0;
    }

    public static int getEngineType(Properties startParams) {
        if (startParams != null) {
            String etp = startParams.getProperty("gemfirexd.engineType");
            int engineType = etp == null ? 2 : Integer.parseInt(etp.trim());
            return engineType;
        }
        return 2;
    }

    public static boolean isDesiredCreateType(Properties p, int type) {
        boolean plainCreate = Boolean.valueOf(p.getProperty("create"));
        if (plainCreate) {
            return (type & 2) != 0;
        }
        return Monitor.isDesiredType(p, type);
    }

    public static void logThrowable(Throwable t) {
        t.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

