/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.ApplicationObjectInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.ErrorInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.ErrorObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactoryContext;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;

public final class FormatIdInputStream
extends DataInputStream
implements ErrorObjectInput,
Resetable {
    protected ClassFactory cf;
    private ErrorInfo errorInfo;
    private Exception myNestedException;

    public FormatIdInputStream(InputStream in) {
        super(in);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        this.setErrorInfo(null);
        int fmtId = FormatIdUtil.readFormatIdInteger(this);
        if (fmtId == 0) {
            return null;
        }
        if (fmtId == 1) {
            return this.readUTF();
        }
        try {
            if (fmtId == 2) {
                ObjectInputStream ois = this.getObjectStream();
                try {
                    Object result = ois.readObject();
                    return result;
                }
                catch (IOException ioe) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw ioe;
                }
                catch (ClassNotFoundException cnfe) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw cnfe;
                }
                catch (LinkageError le) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw le;
                }
                catch (ClassCastException cce) {
                    this.setErrorInfo((ErrorInfo)((Object)ois));
                    throw cce;
                }
            }
            try {
                boolean isNull;
                Formatable f = (Formatable)Monitor.newInstanceFromIdentifier(fmtId);
                if (f instanceof Storable && (isNull = this.readBoolean())) {
                    Storable s = (Storable)f;
                    s.restoreToNull();
                    return s;
                }
                f.readExternal(this);
                return f;
            }
            catch (StandardException se) {
                throw new ClassNotFoundException(se.toString());
            }
        }
        catch (ClassCastException cce) {
            throw new StreamCorruptedException(cce.toString());
        }
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public String getErrorInfo() {
        if (this.errorInfo == null) {
            return "";
        }
        return this.errorInfo.getErrorInfo();
    }

    @Override
    public Exception getNestedException() {
        if (this.myNestedException != null) {
            return null;
        }
        if (this.errorInfo == null) {
            return null;
        }
        return this.errorInfo.getNestedException();
    }

    private void setErrorInfo(ErrorInfo ei) {
        this.errorInfo = ei;
    }

    ClassFactory getClassFactory() {
        ClassFactoryContext cfc;
        if (this.cf == null && (cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext")) != null) {
            this.cf = cfc.getClassFactory();
        }
        return this.cf;
    }

    private ObjectInputStream getObjectStream() throws IOException {
        return this.getClassFactory() == null ? new ObjectInputStream(this) : new ApplicationObjectInputStream(this, this.cf);
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        SanityManager.ASSERT((boolean)(this.in instanceof Resetable));
        ((Resetable)((Object)this.in)).resetStream();
    }

    @Override
    public void initStream() throws StandardException {
        SanityManager.ASSERT((boolean)(this.in instanceof Resetable));
        ((Resetable)((Object)this.in)).initStream();
    }

    @Override
    public void closeStream() {
        SanityManager.ASSERT((boolean)(this.in instanceof Resetable));
        ((Resetable)((Object)this.in)).closeStream();
    }
}

