/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.io;

import com.pivotal.gemfirexd.internal.iapi.services.io.ErrorObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ApplicationObjectInputStream
extends ObjectInputStream
implements ErrorObjectInput {
    protected ClassFactory cf;
    protected ObjectStreamClass initialClass;

    public ApplicationObjectInputStream(InputStream in, ClassFactory cf) throws IOException {
        super(in);
        this.cf = cf;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        if (this.initialClass == null) {
            this.initialClass = v;
        }
        if (this.cf != null) {
            return this.cf.loadApplicationClass(v);
        }
        throw new ClassNotFoundException(v.getName());
    }

    @Override
    public String getErrorInfo() {
        if (this.initialClass == null) {
            return "";
        }
        return this.initialClass.getName() + " (serialVersionUID=" + this.initialClass.getSerialVersionUID() + ")";
    }

    @Override
    public Exception getNestedException() {
        return null;
    }
}

