/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.classfile;

import com.pivotal.gemfirexd.internal.iapi.services.classfile.AttributeEntry;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.Attributes;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassFormatOutput;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import java.io.IOException;

public class ClassMember {
    protected ClassHolder cpt;
    protected int access_flags;
    protected int name_index;
    protected int descriptor_index;
    protected Attributes attribute_info;

    ClassMember(ClassHolder cpt, int modifier, int name, int descriptor) {
        this.cpt = cpt;
        this.name_index = name;
        this.descriptor_index = descriptor;
        this.access_flags = modifier;
    }

    public int getModifier() {
        return this.access_flags;
    }

    public String getDescriptor() {
        return this.cpt.nameIndexToString(this.descriptor_index);
    }

    public String getName() {
        return this.cpt.nameIndexToString(this.name_index);
    }

    public void addAttribute(String attributeName, ClassFormatOutput info) {
        if (this.attribute_info == null) {
            this.attribute_info = new Attributes(1);
        }
        this.attribute_info.addEntry(new AttributeEntry(this.cpt.addUtf8(attributeName), info));
    }

    void put(ClassFormatOutput out) throws IOException {
        out.putU2(this.access_flags);
        out.putU2(this.name_index);
        out.putU2(this.descriptor_index);
        if (this.attribute_info != null) {
            out.putU2(this.attribute_info.size());
            this.attribute_info.put(out);
        } else {
            out.putU2(0);
        }
    }

    int classFileSize() {
        int size = 8;
        if (this.attribute_info != null) {
            size += this.attribute_info.classFileSize();
        }
        return size;
    }
}

