/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredCallableStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredCallableStatement30;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnectionControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredPreparedStatement30;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredStatementControl;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class BrokeredConnection30
extends BrokeredConnection {
    public BrokeredConnection30(BrokeredConnectionControl control) {
        super(control);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint(name);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getRealConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
        try {
            holdability = this.control.checkHoldCursors(holdability, false);
            this.getRealConnection().setHoldability(holdability);
            this.stateHoldability = holdability;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, autoGeneratedKeys), sql, autoGeneratedKeys);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnIndexes), sql, columnIndexes);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnNames), sql, columnNames);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql, Object generatedKeys) throws SQLException {
        return new BrokeredPreparedStatement30(statementControl, sql, generatedKeys);
    }

    @Override
    public BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql) throws SQLException {
        return new BrokeredCallableStatement30(statementControl, sql);
    }
}

