/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyIndexStats;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnappyRegionStatsCollectorResult
extends GfxdDataSerializable {
    private transient List<SnappyRegionStats> combinedStats = new ArrayList<SnappyRegionStats>();
    private transient List<SnappyIndexStats> indexStats = new ArrayList<SnappyIndexStats>();

    public void addRegionStat(SnappyRegionStats stats) {
        this.combinedStats.add(stats);
    }

    public void addIndexStat(SnappyIndexStats stats) {
        this.indexStats.add(stats);
    }

    public void addAllIndexStat(List<SnappyIndexStats> stats) {
        this.indexStats.addAll(stats);
    }

    public List<SnappyRegionStats> getRegionStats() {
        return this.combinedStats;
    }

    public List<SnappyIndexStats> getIndexStats() {
        return this.indexStats;
    }

    @Override
    public byte getGfxdID() {
        return 111;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.combinedStats.size());
        for (SnappyRegionStats snappyRegionStats : this.combinedStats) {
            InternalDataSerializer.writeString((String)snappyRegionStats.getRegionName(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyRegionStats.getTotalSize(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyRegionStats.getSizeInMemory(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyRegionStats.getRowCount(), (DataOutput)out);
            InternalDataSerializer.writeBoolean((Boolean)snappyRegionStats.isColumnTable(), (DataOutput)out);
            InternalDataSerializer.writeBoolean((Boolean)snappyRegionStats.isReplicatedTable(), (DataOutput)out);
        }
        out.writeInt(this.indexStats.size());
        for (SnappyIndexStats snappyIndexStats : this.indexStats) {
            InternalDataSerializer.writeString((String)snappyIndexStats.getIndexName(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyIndexStats.getRowCount(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)snappyIndexStats.getSizeInMemory(), (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        for (int size = in.readInt(); size > 0; --size) {
            String regionName = InternalDataSerializer.readString((DataInput)in);
            long totalSize = InternalDataSerializer.readLong((DataInput)in);
            long memorySize = InternalDataSerializer.readLong((DataInput)in);
            long count = InternalDataSerializer.readLong((DataInput)in);
            boolean isColumnTable = InternalDataSerializer.readBoolean((DataInput)in);
            boolean isReplicated = InternalDataSerializer.readBoolean((DataInput)in);
            this.addRegionStat(new SnappyRegionStats(regionName, totalSize, memorySize, count, isColumnTable, isReplicated));
        }
        for (int numIndex = in.readInt(); numIndex > 0; --numIndex) {
            String indexName = InternalDataSerializer.readString((DataInput)in);
            long rowCount = InternalDataSerializer.readLong((DataInput)in);
            long sizeInMemory = InternalDataSerializer.readLong((DataInput)in);
            this.addIndexStat(new SnappyIndexStats(indexName, rowCount, sizeInMemory));
        }
    }
}

