/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SnappyRegionStats
implements DataSerializable {
    private boolean isColumnTable = false;
    private String regionName;
    private long rowCount = 0L;
    private long sizeInMemory = 0L;
    private long totalSize = 0L;
    private Boolean isReplicatedTable = false;

    public SnappyRegionStats() {
    }

    public SnappyRegionStats(String regionName) {
        this.regionName = regionName;
    }

    public SnappyRegionStats(String regionName, long totalSize, long sizeInMemory, long rowCount, boolean isColumnTable, boolean isReplicatedTable) {
        this.regionName = regionName;
        this.totalSize = totalSize;
        this.sizeInMemory = sizeInMemory;
        this.rowCount = rowCount;
        this.isColumnTable = isColumnTable;
        this.isReplicatedTable = isReplicatedTable;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public boolean isColumnTable() {
        return this.isColumnTable;
    }

    public boolean isReplicatedTable() {
        return this.isReplicatedTable;
    }

    public void setReplicatedTable(boolean replicatedTable) {
        this.isReplicatedTable = replicatedTable;
    }

    public void setColumnTable(boolean columnTable) {
        this.isColumnTable = columnTable;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getSizeInMemory() {
        return this.sizeInMemory;
    }

    public void setSizeInMemory(long sizeInMemory) {
        this.sizeInMemory = sizeInMemory;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public SnappyRegionStats getCombinedStats(SnappyRegionStats stats) {
        String regionName = this.isColumnTable ? stats.regionName : this.regionName;
        SnappyRegionStats combinedStats = new SnappyRegionStats(regionName);
        if (this.isReplicatedTable()) {
            combinedStats.setRowCount(stats.rowCount);
        } else {
            combinedStats.setRowCount(stats.rowCount + this.rowCount);
        }
        combinedStats.setSizeInMemory(stats.sizeInMemory + this.sizeInMemory);
        combinedStats.setTotalSize(stats.totalSize + this.totalSize);
        combinedStats.setColumnTable(this.isColumnTable || stats.isColumnTable);
        combinedStats.setReplicatedTable(this.isReplicatedTable());
        return combinedStats;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.regionName, (DataOutput)out);
        out.writeLong(this.totalSize);
        out.writeLong(this.sizeInMemory);
        out.writeLong(this.rowCount);
        out.writeBoolean(this.isColumnTable);
        out.writeBoolean(this.isReplicatedTable);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionName = DataSerializer.readString((DataInput)in);
        this.totalSize = in.readLong();
        this.sizeInMemory = in.readLong();
        this.rowCount = in.readLong();
        this.isColumnTable = in.readBoolean();
        this.isReplicatedTable = in.readBoolean();
    }

    public String toString() {
        return "RegionStats for " + this.regionName + ": totalSize=" + this.totalSize + " sizeInMemory=" + this.sizeInMemory + " rowCount=" + this.rowCount + " isColumnTable=" + this.isColumnTable + " isReplicatedTable=" + this.isReplicatedTable;
    }
}

