/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.store.offheap.CollectionBasedOHAddressCache;
import java.util.ArrayList;
import java.util.List;

public final class ArrayOHAddressCache
implements CollectionBasedOHAddressCache {
    private ArrayTrackerElement head = new ArrayTrackerElement(null);

    public void release() {
        ArrayTrackerElement e = this.head;
        while (e != null) {
            e.release();
            e = e.down;
        }
        this.head = null;
    }

    @Override
    public void put(long addr) {
        if (this.head == null || this.head.isFull()) {
            this.head = new ArrayTrackerElement(this.head);
        }
        this.head.addRef(addr);
    }

    @Override
    public void releaseByteSource(int idx) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException("list was empty");
        }
        ArrayTrackerElement e = this.head.removeRef(idx);
        if (e.isEmpty()) {
            if (e == this.head) {
                if (e.down != null) {
                    this.head = e.down;
                    e.down.up = null;
                } else {
                    this.head = null;
                }
            } else {
                if (e.down != null) {
                    e.down.up = e.up;
                }
                e.up.down = e.down;
            }
        }
    }

    @Override
    public int testHook_getSize() {
        int result = 0;
        ArrayTrackerElement e = this.head;
        while (e != null) {
            result += e.size();
            e = e.down;
        }
        return result;
    }

    @Override
    public List<Long> testHook_copyToList() {
        ArrayList<Long> result = new ArrayList<Long>(this.testHook_getSize());
        ArrayTrackerElement e = this.head;
        while (e != null) {
            e.copyToList(result);
            e = e.down;
        }
        return result;
    }

    private static class ArrayTrackerElement {
        private static final long NULL = 0L;
        private static final long REMOVED = 1L;
        private final long[] refs = new long[512];
        private short addCount = 0;
        private short removedCount = 0;
        private ArrayTrackerElement down;
        private ArrayTrackerElement up;

        public ArrayTrackerElement(ArrayTrackerElement oldHead) {
            this.down = oldHead;
            this.up = null;
            if (oldHead != null) {
                oldHead.up = this;
            }
        }

        public void release() {
            for (int i = 0; i < this.addCount; ++i) {
                long addr = this.refs[i];
                if (addr == 0L || addr == 1L) continue;
                SimpleMemoryAllocatorImpl.Chunk.release((long)addr, (boolean)true);
            }
        }

        public ArrayTrackerElement removeRef(int idx) {
            return ArrayTrackerElement.removeRef(this, idx);
        }

        private static ArrayTrackerElement removeRef(ArrayTrackerElement e, int idx) {
            if (idx == 0) {
                while (e.isEmpty()) {
                    if (e.down != null) {
                        e = e.down;
                        continue;
                    }
                    throw new IndexOutOfBoundsException("list was empty");
                }
                e.addCount = (short)(e.addCount - 1);
                long addr = e.refs[e.addCount];
                if (addr != 0L) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)addr, (boolean)true);
                }
            } else {
                boolean onLastTarget = false;
                int targetIdx = e.addCount;
                int liveCount = targetIdx - e.removedCount;
                if (liveCount <= idx) {
                    if ((idx -= liveCount) == 0) {
                        onLastTarget = true;
                    }
                    targetIdx = 0;
                }
                boolean doNext = false;
                do {
                    --targetIdx;
                    while (targetIdx < 0) {
                        if (e.down != null) {
                            e = e.down;
                            targetIdx = e.addCount;
                            liveCount = targetIdx - e.removedCount;
                            if (liveCount <= idx) {
                                if ((idx -= liveCount) == 0) {
                                    onLastTarget = true;
                                }
                                targetIdx = 0;
                            }
                            --targetIdx;
                            continue;
                        }
                        throw new IndexOutOfBoundsException("removeRef idx did not exist");
                    }
                    if (e.refs[targetIdx] != 1L) {
                        if (onLastTarget) {
                            doNext = false;
                            continue;
                        }
                        doNext = true;
                        if (--idx != 0) continue;
                        onLastTarget = true;
                        continue;
                    }
                    doNext = true;
                } while (doNext);
                long addr = e.refs[targetIdx];
                if (addr != 0L) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)addr, (boolean)true);
                }
                e.refs[targetIdx] = 1L;
                e.removedCount = (short)(e.removedCount + 1);
            }
            while (e.addCount > 0 && e.refs[e.addCount - 1] == 1L) {
                e.removedCount = (short)(e.removedCount - 1);
                e.addCount = (short)(e.addCount - 1);
            }
            return e;
        }

        public void addRef(long refAddr) {
            this.refs[this.addCount] = refAddr;
            this.addCount = (short)(this.addCount + 1);
        }

        public boolean isEmpty() {
            return this.addCount - this.removedCount <= 0;
        }

        public boolean isFull() {
            return this.addCount >= this.refs.length;
        }

        public int size() {
            return this.addCount - this.removedCount;
        }

        public void copyToList(ArrayList<Long> result) {
            for (int i = this.addCount - 1; i >= 0; --i) {
                long addr = this.refs[i];
                if (addr == 0L) {
                    result.add(null);
                    continue;
                }
                if (addr == 1L) continue;
                result.add(addr);
            }
        }
    }
}

