/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.entry;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.pivotal.gemfirexd.internal.engine.store.entry.HDFSEventRowLocationRegionEntry;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.IOException;
import java.util.Iterator;

public final class HDFSSplitIteratorWrapper
implements Iterator<RowLocation> {
    private HDFSSplitIterator reader;
    private LocalRegion region;

    private HDFSSplitIteratorWrapper(LocalRegion region, HDFSSplitIterator splitIterator) {
        this.region = region;
        this.reader = splitIterator;
    }

    public static Iterator<?> getIterator(LocalRegion region, Object split) {
        HDFSSplitIterator splitIterator = (HDFSSplitIterator)split;
        return new HDFSSplitIteratorWrapper(region, splitIterator);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (IOException e) {
            throw new HDFSIOException("Error reading from HDFS", (Throwable)e);
        }
    }

    @Override
    public RowLocation next() {
        try {
            boolean hasNext = this.reader.next();
            if (!hasNext) {
                return null;
            }
            byte[] key = this.reader.getKey();
            PersistedEventImpl event = this.reader.getDeserializedValue();
            return new HDFSEventRowLocationRegionEntry((RegionEntryContext)this.region, key, event);
        }
        catch (IOException e) {
            throw new HDFSIOException("Error reading from HDFS", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new HDFSIOException("Error reading from HDFS", (Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

