/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.NoMemberFoundException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.FunctionUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ServerGroupUtils {
    private ServerGroupUtils() {
    }

    public static void setIsServer(boolean serverOrClient) {
        GemFireStore memStore = Misc.getMemStore();
        memStore.getAdvisee().setVMKind(serverOrClient ? GemFireStore.VMKind.DATASTORE : GemFireStore.VMKind.ACCESSOR);
        memStore.getDistributionAdvisor().distributeProfileUpdate();
    }

    public static void setServerGroups(SortedSet<String> serverGroups) {
        GemFireStore memStore = Misc.getMemStore();
        memStore.getAdvisee().setServerGroups(serverGroups);
        memStore.getDistributionAdvisor().distributeProfileUpdate();
    }

    public static void sendUpdateProfile() {
        GemFireStore memStore = Misc.getMemStore();
        memStore.getDistributionAdvisor().distributeProfileUpdate();
    }

    public static String getMyGroups() {
        return SharedUtils.toCSV(Misc.getMemStore().getAdvisee().getServerGroups());
    }

    public static String[] getMyGroupsArray() {
        SortedSet<String> vmGroups = Misc.getMemStore().getAdvisee().getServerGroups();
        String[] groups = new String[vmGroups.size()];
        return vmGroups.toArray(groups);
    }

    public static SortedSet<String> getMyGroupsSet() {
        SortedSet<String> vmGroups = Misc.getMemStore().getAdvisee().getServerGroups();
        return new TreeSet<String>(vmGroups);
    }

    public static boolean isGroupMember(Set<String> groups) {
        if (groups == null || groups.size() == 0) {
            return true;
        }
        return ServerGroupUtils.isGroupMember(Misc.getMemStoreBooting().getAdvisee().getServerGroups(), groups);
    }

    public static boolean isGroupMember(DistributedMember member, Set<String> groups, boolean isDataStore) {
        return GemFireXDUtils.getGfxdAdvisor().isGroupMember(member, groups, isDataStore);
    }

    public static boolean isGroupMember(Set<String> vmGroups, Set<String> groups) {
        if (groups.size() == 0) {
            return true;
        }
        for (String group : groups) {
            if (!vmGroups.contains(group)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDataStore() {
        return GemFireXDUtils.getMyVMKind() == GemFireStore.VMKind.DATASTORE;
    }

    public static boolean isAccessor() {
        return GemFireXDUtils.getMyVMKind() == GemFireStore.VMKind.ACCESSOR;
    }

    public static boolean isDataStore(String table, Set<String> serverGroups) {
        boolean isDataStore;
        boolean isStore = ServerGroupUtils.isDataStore();
        if (serverGroups == null || serverGroups.size() == 0) {
            isDataStore = isStore;
        } else {
            boolean bl = isDataStore = isStore && ServerGroupUtils.isGroupMember(serverGroups);
        }
        if (GemFireXDUtils.TraceConglom || !table.startsWith("SYSSTAT") && !table.startsWith("SNAPPY_HIVE_METASTORE")) {
            if (isDataStore) {
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Using the JVM as an GemFireXD datastore for table [" + table + "] with table-default-partitioned=" + Misc.getMemStore().isTableDefaultPartitioned() + (lcc != null ? " default-persistent=" + lcc.isDefaultPersistent() : "")));
            } else {
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                SanityManager.DEBUG_PRINT((String)"info:TraceConglom", (String)("Using the JVM as an GemFireXD accessor for table [" + table + "] with table-default-partitioned=" + Misc.getMemStore().isTableDefaultPartitioned() + (lcc != null ? " default-persistent=" + lcc.isDefaultPersistent() : "")));
            }
        }
        return isDataStore;
    }

    public static SortedSet<String> getServerGroupsFromContainer(GemFireContainer container) {
        TreeSet<String> tableServerGroups = new TreeSet<String>();
        ExtraTableInfo extraTableInfo = container.getExtraTableInfo();
        TableDescriptor tableDescriptor = extraTableInfo.getTableDescriptor();
        try {
            DistributionDescriptor distributionDescriptor = tableDescriptor.getDistributionDescriptor();
            tableServerGroups.addAll(distributionDescriptor.getServerGroups());
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return tableServerGroups;
    }

    public static SortedSet<String> getServerGroups(String serverGroupsString) {
        return SharedUtils.toSortedSet((String)serverGroupsString, (boolean)false);
    }

    public static SortedSet<String> getServerGroups(DistributedMember member) {
        GfxdDistributionAdvisor.GfxdProfile profile = GemFireXDUtils.getGfxdProfile(member);
        if (profile != null) {
            return profile.getServerGroups();
        }
        return null;
    }

    public static FunctionUtils.GfxdExecution onServerGroups(Set<String> serverGroups, boolean flushTXPendingOps) {
        InternalDistributedSystem dsys = Misc.getDistributedSystem();
        return new GetGroupMembersFunctionExecutor((DistributedSystem)dsys, new GetServerGroupMembers(serverGroups, false), flushTXPendingOps);
    }

    public static FunctionUtils.GfxdExecution onServerGroups(String serverGroups, boolean flushTXPendingOps) {
        return ServerGroupUtils.onServerGroups(ServerGroupUtils.getServerGroups(serverGroups), flushTXPendingOps);
    }

    private static final class GetGroupMembersFunctionExecutor
    extends FunctionUtils.GetMembersFunctionExecutor {
        GetGroupMembersFunctionExecutor(DistributedSystem dsys, FunctionUtils.GetFunctionMembers fMembers, boolean flushTXPendingOps) {
            super(dsys, fMembers, flushTXPendingOps, false);
        }

        @Override
        protected void checkMembers(Set<DistributedMember> members, Function function) {
            super.checkMembers(members, function);
            for (DistributedMember m : members) {
                if (m != null) continue;
                throw new NoMemberFoundException(LocalizedStrings.MemberFunctionExecutor_NO_MEMBER_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(new Object[]{function.getId() + " got unexpected null member in server groups [" + this.getMembers.getServerGroups() + ']'}), null);
            }
        }
    }

    public static final class GetServerGroupMembers
    implements FunctionUtils.GetFunctionMembers {
        private final Set<String> serverGroups;
        private final boolean anyOneDataStoreMember;
        private boolean preferablySelf;
        private String tablename;

        public GetServerGroupMembers(Set<String> serverGroups, boolean anyOneMember) {
            this.serverGroups = serverGroups;
            this.anyOneDataStoreMember = anyOneMember;
            this.preferablySelf = false;
            this.tablename = null;
        }

        public void setSelfPreference() {
            this.preferablySelf = true;
        }

        @Override
        public Set<DistributedMember> getMembers() {
            if (this.anyOneDataStoreMember) {
                DistributedMember member = GemFireXDUtils.getGfxdAdvisor().adviseDataStore(this.serverGroups, this.preferablySelf);
                if (member != null) {
                    return Collections.singleton(member);
                }
                return Collections.emptySet();
            }
            if (this.serverGroups == null || this.serverGroups.size() == 0) {
                return GemFireXDUtils.getGfxdAdvisor().adviseDataStores(null);
            }
            return GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(this.serverGroups);
        }

        public String getTableName() {
            return this.tablename;
        }

        public void setTableName(String tableName) {
            this.tablename = tableName;
        }

        @Override
        public Set<String> getServerGroups() {
            return this.serverGroups;
        }

        @Override
        public void postExecutionCallback() {
        }
    }
}

