/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gnu.trove.TIntIntHashMap;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.SQLException;

public final class ProjectionMetaData
implements TableMetaData {
    private final TableMetaData metadata;
    private final int[] projection;
    private TIntIntHashMap tableColumnToColumn;
    private final int numColumns;

    public ProjectionMetaData(TableMetaData fullMetaData, int[] projectionColumns) {
        this.metadata = fullMetaData;
        this.projection = projectionColumns;
        this.numColumns = projectionColumns.length;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.numColumns;
    }

    @Override
    public final int getTableColumnPosition(int column) throws SQLException {
        if (column > 0 && column <= this.numColumns) {
            return this.projection[column - 1];
        }
        throw Util.generateCsSQLException("S0022", column);
    }

    @Override
    public int getColumnPosition(String columnName) throws SQLException {
        int tablePosition = this.metadata.getColumnPosition(columnName);
        if (this.tableColumnToColumn != null) {
            return this.tableColumnToColumn.get(tablePosition);
        }
        int pos = 1;
        int retPos = 0;
        this.tableColumnToColumn = new TIntIntHashMap(this.numColumns);
        for (int tablePos : this.projection) {
            if (tablePos == tablePosition) {
                retPos = pos;
            }
            this.tableColumnToColumn.put(tablePosition, pos);
            ++pos;
        }
        if (retPos > 0) {
            return retPos;
        }
        throw Util.generateCsSQLException("42X04", columnName);
    }

    @Override
    public int getDeclaredColumnWidth(int column) throws SQLException {
        return this.metadata.getDeclaredColumnWidth(this.getTableColumnPosition(column));
    }

    @Override
    public int getSchemaVersion() {
        return this.metadata.getSchemaVersion();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.metadata.isAutoIncrement(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.metadata.isCaseSensitive(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.metadata.isSearchable(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.metadata.isCurrency(this.getTableColumnPosition(column));
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.metadata.isNullable(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.metadata.isSigned(this.getTableColumnPosition(column));
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.metadata.getColumnDisplaySize(this.getTableColumnPosition(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.metadata.getColumnLabel(this.getTableColumnPosition(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.metadata.getColumnName(this.getTableColumnPosition(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.metadata.getSchemaName(this.getTableColumnPosition(column));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.metadata.getPrecision(this.getTableColumnPosition(column));
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.metadata.getScale(this.getTableColumnPosition(column));
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.metadata.getTableName(this.getTableColumnPosition(column));
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.metadata.getCatalogName(this.getTableColumnPosition(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.metadata.getColumnType(this.getTableColumnPosition(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.metadata.getColumnTypeName(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.metadata.isReadOnly(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.metadata.isWritable(this.getTableColumnPosition(column));
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.metadata.isDefinitelyWritable(this.getTableColumnPosition(column));
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.metadata.getColumnClassName(this.getTableColumnPosition(column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.metadata.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.metadata.isWrapperFor(iface);
    }
}

