/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TreeSet;
import org.apache.spark.unsafe.types.UTF8String;

public final class OffHeapCompactExecRow
extends AbstractCompactExecRow {
    private static final long serialVersionUID = -8506169648261047433L;
    private Object source;

    public OffHeapCompactExecRow() {
    }

    OffHeapCompactExecRow(RowFormatter rf) {
        super(rf);
        this.source = null;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
    }

    OffHeapCompactExecRow(DataValueDescriptor[] dvds, RowFormatter rf) throws StandardException {
        super(rf);
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
        this.source = dvds != null ? (Object)rf.generateBytes(dvds) : null;
    }

    OffHeapCompactExecRow(Object bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
    }

    OffHeapCompactExecRow(byte[] bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
    }

    OffHeapCompactExecRow(OffHeapRow bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
    }

    OffHeapCompactExecRow(Object bytes, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        super(rf, row, rowLen, doClone);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a OffHeapCompactExecRowWithLobs instead";
    }

    @Override
    public final byte[] getRowBytes() {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return ((OffHeapRow)((Object)source)).getRowBytes();
            }
            if (cls == byte[].class) {
                return (byte[])source;
            }
            return ((OffHeapRowWithLobs)((Object)source)).getRowBytes();
        }
        return null;
    }

    @Override
    public final byte[] getRowBytes(int logicalPosition) {
        return this.getRowBytes();
    }

    @Override
    public final boolean hasByteArrays() {
        return false;
    }

    @Override
    public final Object getRawRowValue(boolean doClone) {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return ((OffHeapRow)((Object)source)).getRowBytes();
            }
            if (cls == byte[].class) {
                byte[] sourceBytes = (byte[])source;
                if (doClone) {
                    byte[] newBytes = new byte[sourceBytes.length];
                    System.arraycopy(sourceBytes, 0, newBytes, 0, sourceBytes.length);
                    return newBytes;
                }
                return sourceBytes;
            }
            return ((OffHeapRowWithLobs)((Object)source)).getRowBytes();
        }
        return null;
    }

    @Override
    protected final DataValueDescriptor basicGetColumn(int position) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getColumn(position, (OffHeapRow)((Object)source));
            }
            if (cls == byte[].class) {
                return this.formatter.getColumn(position, (byte[])source);
            }
            return this.formatter.getColumn(position, (OffHeapRowWithLobs)((Object)source));
        }
        return this.formatter.getColumn(position, (byte[])null);
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            Class<?> cls;
            Object source = this.source;
            this.source = source != null ? ((cls = source.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumns(columns, values, (OffHeapRow)((Object)source), this.formatter) : (cls == byte[].class ? (Object)this.formatter.setColumns(columns, values, (byte[])source, this.formatter) : (Object)this.formatter.setColumns(columns, values, (OffHeapByteSource)((Object)source), this.formatter))) : (Object)this.formatter.setColumns(columns, values, (byte[])null, this.formatter);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected void basicSetColumn(int columnIndex, DataValueDescriptor value) throws StandardException {
        Class<?> cls;
        Object source = this.source;
        this.source = source != null ? ((cls = source.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumn(columnIndex, value, (OffHeapRow)((Object)source), this.formatter) : (cls == byte[].class ? (Object)this.formatter.setColumn(columnIndex, value, (byte[])source, this.formatter) : (Object)this.formatter.setColumn(columnIndex, value, (OffHeapByteSource)((Object)source), this.formatter))) : (Object)this.formatter.setColumn(columnIndex, value, (byte[])null, this.formatter);
    }

    @Override
    protected final void basicSetCompactColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        this.source = this.formatter.setByteCompactColumns(columns, values);
    }

    @Override
    protected final void basicSetColumns(int nCols, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            Class<?> cls;
            Object source = this.source;
            this.source = source != null ? ((cls = source.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumns(nCols, values, (OffHeapRow)((Object)source)) : (cls == byte[].class ? (Object)this.formatter.setColumns(nCols, values, (byte[])source) : (Object)this.formatter.setColumns(nCols, values, (OffHeapByteSource)((Object)source)))) : (Object)this.formatter.setColumns(nCols, values, (byte[])null);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, AbstractCompactExecRow srcRow, int[] baseColumnMap) throws StandardException {
        Class<?> cls;
        Object fromSource = srcRow.getByteSource();
        this.source = fromSource != null ? ((cls = fromSource.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumns(columns, (OffHeapRow)((Object)fromSource), srcRow.formatter, baseColumnMap) : (cls == byte[].class ? (Object)this.formatter.setColumns(columns, (byte[])fromSource, srcRow.formatter, baseColumnMap) : (Object)this.formatter.setColumns(columns, (OffHeapByteSource)((Object)fromSource), srcRow.formatter, baseColumnMap))) : (Object)this.formatter.setColumns(columns, (byte[])null, srcRow.formatter, baseColumnMap);
    }

    @Override
    protected final void basicSetColumns(int[] columns, boolean zeroBased, AbstractCompactExecRow srcRow) throws StandardException {
        Class<?> cls;
        Object fromSource = srcRow.getByteSource();
        this.source = fromSource != null ? ((cls = fromSource.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumns(columns, zeroBased, (OffHeapRow)((Object)fromSource), srcRow.formatter) : (cls == byte[].class ? (Object)this.formatter.setColumns(columns, zeroBased, (byte[])fromSource, srcRow.formatter) : (Object)this.formatter.setColumns(columns, zeroBased, (OffHeapByteSource)((Object)fromSource), srcRow.formatter))) : (Object)this.formatter.setColumns(columns, zeroBased, (byte[])null, srcRow.formatter);
    }

    @Override
    protected final void basicSetColumns(int nCols, AbstractCompactExecRow srcRow) throws StandardException {
        Class<?> cls;
        Object fromSource = srcRow.getByteSource();
        this.source = fromSource != null ? ((cls = fromSource.getClass()) == OffHeapRow.class ? (Object)this.formatter.setColumns(nCols, (OffHeapRow)((Object)fromSource), srcRow.formatter) : (cls == byte[].class ? (Object)this.formatter.setColumns(nCols, (byte[])fromSource, srcRow.formatter) : (Object)this.formatter.setColumns(nCols, (OffHeapByteSource)((Object)fromSource), srcRow.formatter))) : (Object)this.formatter.setColumns(nCols, (byte[])null, srcRow.formatter);
    }

    @Override
    protected final void basicResetRowArray() {
        this.source = null;
        if (this.setOfKeys != null) {
            this.setOfKeys.clear();
        }
    }

    @Override
    protected final DataValueDescriptor[] basicGetRowArray() {
        try {
            Object source = this.source;
            if (source != null) {
                Class<?> cls = source.getClass();
                if (cls == OffHeapRow.class) {
                    return this.formatter.getAllColumns((OffHeapRow)((Object)source));
                }
                if (cls == byte[].class) {
                    return this.formatter.getAllColumns((byte[])source);
                }
                return this.formatter.getAllColumns((OffHeapRowWithLobs)((Object)source));
            }
            return this.formatter.getAllColumns((byte[])null);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("OffHeapCompactExecRow#getRowArray: unexpected exception", e);
        }
    }

    @Override
    protected final void basicSetRowArray(ExecRow otherRow) {
        if (!(otherRow instanceof AbstractCompactExecRow)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.basicSetRowArray((AbstractCompactExecRow)otherRow);
    }

    @Override
    protected final void basicSetRowArray(AbstractCompactExecRow otherRow) {
        if (this.formatter != otherRow.formatter) {
            this.formatter = otherRow.formatter;
        }
        this.source = otherRow.getByteSource();
    }

    @Override
    protected final void basicSetRowArray(byte[] rowArray, RowFormatter formatter) {
        this.source = rowArray;
        if (this.formatter != formatter) {
            this.formatter = formatter;
        }
    }

    @Override
    protected void basicSetRowArray(byte[][] rowArray, RowFormatter formatter) {
        if (this.formatter.container != formatter.container) {
            throw new UnsupportedOperationException("OffHeapCompactExecRow does not support byte[][]");
        }
        this.basicSetRowArray(rowArray[0], formatter);
    }

    @Override
    protected void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                OffHeapRow ohRow = (OffHeapRow)((Object)source);
                int bytesLen = ohRow.getLength();
                long memAddr = ohRow.getUnsafeAddress(0, bytesLen);
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, ohRow, null);
            } else if (cls == byte[].class) {
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, (byte[])source);
            } else {
                OffHeapRowWithLobs ohLobRow = (OffHeapRowWithLobs)((Object)source);
                int bytesLen = ohLobRow.getLength();
                long memAddr = ohLobRow.getUnsafeAddress(0, bytesLen);
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, null, ohLobRow);
            }
        } else {
            for (DataValueDescriptor dvd : dvds) {
                if (dvd == null) continue;
                dvd.restoreToNull();
            }
        }
    }

    @Override
    protected final byte[][] getRowByteArrays() {
        throw new UnsupportedOperationException("OffHeapCompactExecRow does not support byte[][]");
    }

    @Override
    protected final byte[][] getRowByteArraysIfPresent() {
        return null;
    }

    @Override
    public UTF8String getAsUTF8String(int index) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsUTF8String(index, (OffHeapRow)((Object)source));
            }
            if (cls == byte[].class) {
                return this.formatter.getAsUTF8String(index, (byte[])source);
            }
            return this.formatter.getAsUTF8String(index, (OffHeapRowWithLobs)((Object)source));
        }
        return null;
    }

    @Override
    protected String getString(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsString(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsString(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsString(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsString(position, (byte[])null, wasNull);
    }

    @Override
    protected Object getObject(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsObject(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsObject(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsObject(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsObject(position, (byte[])null, wasNull);
    }

    @Override
    protected boolean getBoolean(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsBoolean(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsBoolean(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsBoolean(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsBoolean(position, (byte[])null, wasNull);
    }

    @Override
    protected byte getByte(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsByte(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsByte(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsByte(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsByte(position, (byte[])null, wasNull);
    }

    @Override
    protected short getShort(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsShort(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsShort(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsShort(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsShort(position, (byte[])null, wasNull);
    }

    @Override
    protected int getInt(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsInt(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsInt(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsInt(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsInt(position, (byte[])null, wasNull);
    }

    @Override
    protected long getLong(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsLong(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsLong(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsLong(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsLong(position, (byte[])null, wasNull);
    }

    @Override
    protected float getFloat(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsFloat(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsFloat(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsFloat(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsFloat(position, (byte[])null, wasNull);
    }

    @Override
    protected double getDouble(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsDouble(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsDouble(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsDouble(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsDouble(position, (byte[])null, wasNull);
    }

    @Override
    protected byte[] getBytes(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsBytes(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsBytes(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsBytes(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsBytes(position, (byte[])null, wasNull);
    }

    @Override
    protected BigDecimal getBigDecimal(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsBigDecimal(position, (OffHeapRow)((Object)source), wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsBigDecimal(position, (byte[])source, wasNull);
            }
            return this.formatter.getAsBigDecimal(position, (OffHeapRowWithLobs)((Object)source), wasNull);
        }
        return this.formatter.getAsBigDecimal(position, (byte[])null, wasNull);
    }

    @Override
    public long getAsDateMillis(int index, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsDateMillis(index, (OffHeapRow)((Object)source), cal, wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsDateMillis(index, (byte[])source, cal, wasNull);
            }
            return this.formatter.getAsDateMillis(index, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    @Override
    protected Date getDate(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsDate(position, (OffHeapRow)((Object)source), cal, wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsDate(position, (byte[])source, cal, wasNull);
            }
            return this.formatter.getAsDate(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsDate(position, (byte[])null, cal, wasNull);
    }

    @Override
    protected Time getTime(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsTime(position, (OffHeapRow)((Object)source), cal, wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsTime(position, (byte[])source, cal, wasNull);
            }
            return this.formatter.getAsTime(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsTime(position, (byte[])null, cal, wasNull);
    }

    @Override
    public long getAsTimestampMicros(int index, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsTimestampMicros(index, (OffHeapRow)((Object)source), cal, wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsTimestampMicros(index, (byte[])source, cal, wasNull);
            }
            return this.formatter.getAsTimestampMicros(index, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    @Override
    protected Timestamp getTimestamp(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getAsTimestamp(position, (OffHeapRow)((Object)source), cal, wasNull);
            }
            if (cls == byte[].class) {
                return this.formatter.getAsTimestamp(position, (byte[])source, cal, wasNull);
            }
            return this.formatter.getAsTimestamp(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsTimestamp(position, (byte[])null, cal, wasNull);
    }

    @Override
    public final void setRowArrayClone(ExecRow otherRow, TreeSet<RegionAndKey> allKeys) {
        if (otherRow instanceof AbstractCompactExecRow) {
            this.basicSetRowArray((AbstractCompactExecRow)otherRow);
            this.clearCachedRow();
        } else {
            this.setRowArray(otherRow.getRowArray());
        }
        this.setOfKeys = allKeys;
    }

    @Override
    public final OffHeapCompactExecRow getClone() {
        OffHeapCompactExecRow row = new OffHeapCompactExecRow(this.source, this.formatter);
        row.setOfKeys = this.setOfKeys;
        return row;
    }

    @Override
    public final OffHeapCompactExecRow getShallowClone() {
        return this.getClone();
    }

    @Override
    public final OffHeapCompactExecRow getNewNullRow() {
        return new OffHeapCompactExecRow(this.formatter);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.compare(row, (OffHeapRow)((Object)source), logicalPosition, thisOffsetWidth, nullsOrderedLow);
            }
            if (cls == byte[].class) {
                return this.compare(row, (byte[])source, logicalPosition, thisOffsetWidth, nullsOrderedLow);
            }
            return this.compare(row, (OffHeapRowWithLobs)((Object)source), logicalPosition, thisOffsetWidth, nullsOrderedLow);
        }
        return this.compare(row, (byte[])null, logicalPosition, thisOffsetWidth, nullsOrderedLow);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, boolean nullsOrderedLow) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                OffHeapRow bytes = (OffHeapRow)((Object)source);
                return super.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
            }
            if (cls == byte[].class) {
                byte[] bytes = (byte[])source;
                return super.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
            }
            OffHeapRowWithLobs bytes = (OffHeapRowWithLobs)((Object)source);
            assert (!this.formatter.getColumnDescriptor((int)(logicalPosition - 1)).isLob) : this.formatter.getColumnDescriptor(logicalPosition - 1).toString();
            return super.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
        }
        return super.compare(row, (byte[])null, logicalPosition, -7L, nullsOrderedLow);
    }

    @Override
    public final int computeHashCode(int position, int hash) {
        Object source = this.source;
        if (source != null) {
            if (source instanceof byte[]) {
                return this.formatter.computeHashCode(position, (byte[])source, hash);
            }
            OffHeapByteSource bs = (OffHeapByteSource)((Object)source);
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return this.formatter.computeHashCode(position, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, hash);
        }
        return ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)this.formatter.getType(position).getTypeId().getTypeFormatId());
    }

    @Override
    public long isNull(int logicalPosition) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRow.class) {
                return this.formatter.getOffsetAndWidth(logicalPosition, (OffHeapRow)((Object)source));
            }
            if (cls == byte[].class) {
                return this.formatter.getOffsetAndWidth(logicalPosition, (byte[])source);
            }
            assert (!this.formatter.getColumnDescriptor((int)(logicalPosition - 1)).isLob) : this.formatter.getColumnDescriptor(logicalPosition - 1).toString();
            return this.formatter.getOffsetAndWidth(logicalPosition, (OffHeapRowWithLobs)((Object)source));
        }
        return -7L;
    }

    @Override
    public byte getGfxdID() {
        throw new UnsupportedOperationException("OffHeapCompactExecRow does not support getGfxdID()");
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("OffHeapCompactExecRow does not support toData");
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.source = DataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public Object getByteSource() {
        return this.source;
    }

    @Override
    public Object getByteSource(int offset) {
        return this.source;
    }

    @Override
    void basicSetByteSource(Object source) {
        this.source = source;
    }

    @Override
    public void releaseByteSource() {
        if (OffHeapHelper.release((Object)this.source)) {
            this.source = null;
        }
    }

    @Override
    public Object getBaseByteSource() {
        return this.source;
    }
}

