/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.CacheMap;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import java.io.File;
import java.io.IOException;

public class GlobalIndexCacheWithLocalRegion
implements CacheMap {
    private final LocalRegion region;
    private final String tableName;
    private static volatile DiskStoreImpl cacheDiskStore;

    private GlobalIndexCacheWithLocalRegion(String tableName, LocalRegion reg) {
        this.region = reg;
        this.tableName = tableName;
    }

    public static GlobalIndexCacheWithLocalRegion createInstance(String qualifiedName) throws TimeoutException, RegionExistsException, ClassNotFoundException, IOException {
        assert (qualifiedName != null) : "expected the tableName to be non-null";
        AttributesFactory afact = new AttributesFactory();
        afact.setScope(Scope.LOCAL);
        afact.setInitialCapacity(1000);
        afact.setConcurrencyChecksEnabled(false);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        if (cacheDiskStore == null) {
            GlobalIndexCacheWithLocalRegion.createCacheDiskStore(cache);
        }
        afact.setDiskSynchronous(true);
        afact.setDiskStoreName("GFXD-GLOBALINDEX-DISKSTORE");
        afact.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        afact.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100000, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        InternalRegionArguments internalRegionArgs = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true).setIsUsedForPartitionedRegionAdmin(false);
        LocalRegion reg = (LocalRegion)cache.createVMRegion(qualifiedName, afact.create(), internalRegionArgs);
        return new GlobalIndexCacheWithLocalRegion(qualifiedName, reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheDiskStore(GemFireCacheImpl cache) {
        Class<GlobalIndexCacheWithLocalRegion> clazz = GlobalIndexCacheWithLocalRegion.class;
        synchronized (GlobalIndexCacheWithLocalRegion.class) {
            if (cacheDiskStore == null) {
                String persistentDir = Misc.getMemStore().generatePersistentDirName(null);
                persistentDir = persistentDir == null || persistentDir.length() == 0 ? "." + File.separatorChar + "globalIndex" : persistentDir + File.separatorChar + "globalIndex";
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File[] diskDirs = new File[]{new File(persistentDir)};
                if (!diskDirs[0].mkdirs() && !diskDirs[0].isDirectory()) {
                    throw new DiskAccessException("Could not create directory for caching and persistence of global indexes: " + diskDirs[0].getAbsolutePath(), (Region)null);
                }
                dsf.setDiskDirs(diskDirs);
                if (DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE < 10L) {
                    dsf.setMaxOplogSize(DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
                } else {
                    dsf.setMaxOplogSize(10L);
                }
                dsf.setSyncWrites(false);
                cacheDiskStore = (DiskStoreImpl)dsf.create("GFXD-GLOBALINDEX-DISKSTORE");
                cacheDiskStore.setUsedForInternalUse();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int size() {
        return this.region.size();
    }

    public boolean isEmpty() {
        return this.region.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.region.containsKey(key);
    }

    public Object get(Object key) {
        return this.region.get(key);
    }

    public Object put(Object key, Object value) {
        return this.region.put(key, value);
    }

    public Object remove(Object key) {
        return this.region.remove(key);
    }

    public void clear() {
        this.region.clear();
    }

    public void destroyCache() {
        this.region.destroyRegion();
    }

    public static void setCacheToNull() {
        cacheDiskStore = null;
    }
}

