/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.pivotal.gemfirexd.internal.engine.store.DVDStoreResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.SQLException;

public final class CustomRowsResultSet
extends DVDStoreResultSet {
    private final FetchDVDRows fetchRows;
    private final DataValueDescriptor[] template;

    public CustomRowsResultSet(FetchDVDRows fetchRows, ResultColumnDescriptor[] columnInfo) throws StandardException {
        super(null, columnInfo.length, null, null, new EmbedResultSetMetaData(columnInfo));
        this.fetchRows = fetchRows;
        this.template = new DataValueDescriptor[columnInfo.length];
        for (int i = 0; i < columnInfo.length; ++i) {
            this.template[i] = columnInfo[i].getType().getNull();
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this.fetchRows.getNext(this.template)) {
                this.currentRowDVDs = this.template;
                return true;
            }
            this.currentRowDVDs = null;
            return false;
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e) {
            throw TransactionResourceImpl.wrapInSQLException(e);
        }
    }

    public static interface FetchDVDRows {
        public boolean getNext(DataValueDescriptor[] var1) throws SQLException, StandardException;
    }
}

