/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class CompositeRegionKey
implements Serializable,
RegionKey {
    private static final long serialVersionUID = -5397414534166595916L;
    private DataValueDescriptor[] primaryKey;

    public CompositeRegionKey() {
    }

    public CompositeRegionKey(DataValueDescriptor[] key) {
        if (key == null) {
            throw new IllegalArgumentException("key should never be null.");
        }
        this.primaryKey = key;
    }

    public void setPrimaryKey(DataValueDescriptor[] key) {
        if (key == null) {
            throw new IllegalArgumentException("key should never be null.");
        }
        this.primaryKey = key;
    }

    public final void setRegionContext(LocalRegion region) {
        for (int index = 0; index < this.primaryKey.length; ++index) {
            this.primaryKey[index].setRegionContext(region);
        }
    }

    public final KeyWithRegionContext beforeSerializationWithValue(boolean valueIsToken) {
        return this;
    }

    public final void afterDeserializationWithValue(Object val) {
    }

    @Override
    public final int nCols() {
        return this.primaryKey.length;
    }

    @Override
    public DataValueDescriptor getKeyColumn(int index) {
        return this.primaryKey[index];
    }

    @Override
    public void getKeyColumns(DataValueDescriptor[] keys) {
        try {
            for (int index = 0; index < keys.length; ++index) {
                if (keys[index] == null) {
                    keys[index] = this.primaryKey[index];
                    continue;
                }
                keys[index].setValue(this.primaryKey[index]);
            }
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("CRK.getKeyColumns: unexpected exception", se);
        }
    }

    @Override
    public void getKeyColumns(Object[] keys) throws StandardException {
        for (int index = 0; index < keys.length; ++index) {
            keys[index] = this.primaryKey[index].getObject();
        }
    }

    public final int hashCode() {
        return ResolverUtils.isUsingGFXD1302Hashing() ? CompositeRegionKey.hashCodeFromDVDs(this.primaryKey) : CompositeRegionKey.hashCodeFromDVDsPre1302(this.primaryKey);
    }

    public static int hashCodeFromDVDs(DataValueDescriptor[] val) {
        int hash = 0;
        for (int index = 0; index < val.length; ++index) {
            DataValueDescriptor dvd = val[index];
            hash = dvd != null ? ResolverUtils.addIntToHash((int)dvd.hashCode(), (int)hash) : ResolverUtils.addIntToHash((int)0, (int)hash);
        }
        return hash;
    }

    public static int hashCodeFromDVDsPre1302(DataValueDescriptor[] val) {
        int hash = 0;
        for (int index = 0; index < val.length; ++index) {
            DataValueDescriptor dvd = val[index];
            if (dvd == null) continue;
            hash ^= dvd.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CompositeRegionKey) {
            return CompositeRegionKey.dvdArrayEquals(this.primaryKey, ((CompositeRegionKey)other).primaryKey);
        }
        return false;
    }

    public static boolean dvdArrayEquals(DataValueDescriptor[] array1, DataValueDescriptor[] array2) {
        assert (array1 != null) : "DVD[] should never be null";
        assert (array2 != null) : "DVD[] should never be null";
        if (array1.length != array2.length) {
            return false;
        }
        try {
            for (int index = 0; index < array1.length; ++index) {
                DataValueDescriptor dvd1 = array1[index];
                DataValueDescriptor dvd2 = array2[index];
                if (!(dvd1 != null ? dvd2 == null || dvd2.compare(dvd1) != 0 : dvd2 != null)) continue;
                return false;
            }
        }
        catch (StandardException se) {
            return false;
        }
        return true;
    }

    public long estimateMemoryUsage() {
        return ValueRow.estimateDVDArraySize(this.primaryKey) + (long)ReflectionSingleObjectSizer.OBJECT_SIZE + (long)ReflectionSingleObjectSizer.REFERENCE_SIZE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("gemfire CRkey: ");
        if (this.primaryKey != null) {
            for (int i = 0; i < this.primaryKey.length; ++i) {
                sb.append(" element [").append(i).append("]: ").append(this.primaryKey[i].toString());
            }
        } else {
            sb.append("is null");
        }
        return sb.toString();
    }

    public final int getDSFID() {
        return -17;
    }

    public final void toData(DataOutput out) throws IOException {
        DataType.writeDVDArray(this.primaryKey, out);
    }

    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.primaryKey = DataType.readDVDArray(in);
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

