/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.LogFileUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MemberLogsMessage
extends MemberExecutorMessage {
    private String memberId;
    private Long offset;
    private Long byteLength;
    private String logFileName;
    private File logDirectory;

    public MemberLogsMessage() {
        super(true);
    }

    public MemberLogsMessage(ResultCollector<Object, Object> rc) {
        super(rc, null, false, true);
    }

    private MemberLogsMessage(MemberLogsMessage other) {
        super(other);
        this.memberId = other.getMemberId();
        this.logFileName = other.getLogFileName();
        this.logDirectory = other.getLogDirectory();
        this.byteLength = other.getByteLength();
        this.offset = other.getOffset();
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getByteLength() {
        return this.byteLength;
    }

    public void setByteLength(Long byteLength) {
        this.byteLength = byteLength;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(File logDirectory) {
        this.logDirectory = logDirectory;
    }

    @Override
    protected void execute() throws Exception {
        GemFireCacheImpl gemFireCache = GemFireCacheImpl.getExisting();
        InternalDistributedSystem ids = gemFireCache.getDistributedSystem();
        String memberId = ids.getMemberId();
        HashMap<String, Object> logDetailsMap = new HashMap<String, Object>();
        logDetailsMap.put("id", memberId);
        logDetailsMap.put("name", ids.getName());
        logDetailsMap.put("userDir", this.logDirectory);
        logDetailsMap.put("logFile", this.logFileName);
        logDetailsMap.put("logData", LogFileUtils.getLog(this.logDirectory, this.logFileName, this.offset, this.byteLength));
        this.lastResult(logDetailsMap);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        if (this.memberId != null || !this.memberId.isEmpty()) {
            Set<DistributedMember> distMembers = MemberLogsMessage.getAllGfxdMembers();
            for (DistributedMember distMember : distMembers) {
                if (!distMember.getId().equalsIgnoreCase(this.memberId)) continue;
                members.add(distMember);
                break;
            }
        }
        return members;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.memberId = DataSerializer.readString((DataInput)in);
        this.offset = (Long)DataSerializer.readObject((DataInput)in);
        this.byteLength = (Long)DataSerializer.readObject((DataInput)in);
        this.logFileName = DataSerializer.readString((DataInput)in);
        this.logDirectory = DataSerializer.readFile((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.memberId, (DataOutput)out);
        DataSerializer.writeObject((Object)this.offset, (DataOutput)out);
        DataSerializer.writeObject((Object)this.byteLength, (DataOutput)out);
        DataSerializer.writeString((String)this.logFileName, (DataOutput)out);
        DataSerializer.writeFile((File)this.logDirectory, (DataOutput)out);
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected GfxdFunctionMessage clone() {
        return new MemberLogsMessage(this);
    }

    @Override
    public byte getGfxdID() {
        return 59;
    }
}

